/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.v3210;

import com.mmm.cms.homehealth.DiagnosisCode;
import com.mmm.cms.homehealth.DiagnosisCode_Empty;
import com.mmm.cms.homehealth.GrouperDataManager;
import com.mmm.cms.homehealth.ScoringPoints;
import com.mmm.cms.homehealth.proto.AlreadyScoredException;
import com.mmm.cms.homehealth.proto.CaseMixAdjustmentItemIF;
import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.DiagnosisScoringGridIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.HomeHealthScoringModelIF;
import com.mmm.cms.homehealth.proto.ScoringPointsIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordValidatorIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecord_B_IF;
import com.mmm.cms.homehealth.v3210.ClinicalFunctional_ScoringModel_v3210;
import com.mmm.cms.util.ScoringEventFormatter;
import com.mmm.cms.util.ValidateUtils;

public class NRS_ScoringModel_v3210
extends ClinicalFunctional_ScoringModel_v3210 {
    public NRS_ScoringModel_v3210(HomeHealthGrouperIF grouper, GrouperDataManager dataManager) {
        super(grouper, dataManager, 0);
        this.setShortName("NRS Equation");
    }

    @Override
    public ScoringPointsIF score(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator) {
        ScoringPoints points = new ScoringPoints(1);
        StringBuilder buffer = new StringBuilder("Final NRS equation score: ");
        this.preprocessRecord(record, validator);
        points.setScoreAt(0, this.scoreClinical(record, validator));
        buffer.append(points.getScores()[0]);
        ScoringEventFormatter.fireScoringGeneral(this.grouper.getEventListenersList(), this.grouper, this, buffer.toString());
        return points;
    }

    @Override
    public ScoringPointsIF score(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, int[][] scoreOrder) {
        ScoringPoints points = new ScoringPoints(1);
        this.preprocessRecord(record, validator);
        points.setScoreAt(0, this.scoreClinical(record, validator, scoreOrder));
        if (this.grouper.getListenerCount() > 0) {
            StringBuilder buffer = new StringBuilder("Final NRS equation score: ");
            buffer.append(points.getScores()[0]);
            ScoringEventFormatter.fireScoringGeneral(this.grouper.getEventListenersList(), this.grouper, this, buffer.toString());
        }
        return points;
    }

    @Override
    public void preprocessRecord(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator) {
        DiagnosisCodeIF code;
        ScoringEventFormatter.fireScoringSectionStart(this.grouper.getEventListenersList(), this.grouper, this, "NRS Pre-process record");
        DiagnosisCodeIF primaryCode = record.getPRIMARY_DIAG_ICD();
        if (!primaryCode.isValidForScoring() || primaryCode.isVCode()) {
            primaryCode = record.getPMT_DIAG_ICD_A3();
        }
        if (primaryCode.isDiabeticUlcer()) {
            code = record.getOTH_DIAG1_ICD();
            if (code.isVCode()) {
                code = record.getPMT_DIAG_ICD_B3();
                if (code.isUlcer()) {
                    code.setValidForScoring(false);
                } else {
                    primaryCode.setValidForScoring(false);
                    ScoringEventFormatter.fireScoringGeneral(this.grouper.getEventListenersList(), this.grouper, this, "Set M0230_PRIMARY_DIAG_ICD not valid for scoring due to missing Ulcer code in column 3");
                }
            } else if (!code.isValidForScoring() || !code.isUlcer()) {
                primaryCode.setValidForScoring(false);
                ScoringEventFormatter.fireScoringGeneral(this.grouper.getEventListenersList(), this.grouper, this, "Set M0230_PRIMARY_DIAG_ICD not valid for scoring due to missing Ulcer code");
            } else if (code.isUlcer()) {
                code.setValidForScoring(false);
            }
        }
        if ((code = record.getOTH_DIAG1_ICD()).isDiabeticUlcer()) {
            code.setValidForScoring(false);
        }
        if ((code = record.getOTH_DIAG2_ICD()).isDiabeticUlcer()) {
            code.setValidForScoring(false);
        }
        if ((code = record.getOTH_DIAG3_ICD()).isDiabeticUlcer()) {
            code.setValidForScoring(false);
        }
        if ((code = record.getOTH_DIAG4_ICD()).isDiabeticUlcer()) {
            code.setValidForScoring(false);
        }
        if ((code = record.getOTH_DIAG5_ICD()).isDiabeticUlcer()) {
            code.setValidForScoring(false);
        }
        if ((code = record.getPMT_DIAG_ICD_B3()).isDiabeticUlcer()) {
            code.setValidForScoring(false);
        }
        if ((code = record.getPMT_DIAG_ICD_C3()).isDiabeticUlcer()) {
            code.setValidForScoring(false);
        }
        if ((code = record.getPMT_DIAG_ICD_D3()).isDiabeticUlcer()) {
            code.setValidForScoring(false);
        }
        if ((code = record.getPMT_DIAG_ICD_E3()).isDiabeticUlcer()) {
            code.setValidForScoring(false);
        }
        if ((code = record.getPMT_DIAG_ICD_F3()).isDiabeticUlcer()) {
            code.setValidForScoring(false);
        }
        if ((code = record.getPMT_DIAG_ICD_A4()).isDiabeticUlcer()) {
            code.setValidForScoring(false);
        }
        if ((code = record.getPMT_DIAG_ICD_B4()).isDiabeticUlcer()) {
            code.setValidForScoring(false);
        }
        if ((code = record.getPMT_DIAG_ICD_C4()).isDiabeticUlcer()) {
            code.setValidForScoring(false);
        }
        if ((code = record.getPMT_DIAG_ICD_D4()).isDiabeticUlcer()) {
            code.setValidForScoring(false);
        }
        if ((code = record.getPMT_DIAG_ICD_E4()).isDiabeticUlcer()) {
            code.setValidForScoring(false);
        }
        if ((code = record.getPMT_DIAG_ICD_F4()).isDiabeticUlcer()) {
            code.setValidForScoring(false);
        }
        ScoringEventFormatter.fireScoringSectionFinished(this.grouper.getEventListenersList(), this.grouper, (HomeHealthScoringModelIF)this, "NRS Pre-process record", 0);
    }

    @Override
    public void scorePrimaryOnly(HomeHealthRecordIF record, DiagnosisCodeIF diagCode, int diagIdx, DiagnosisScoringGridIF scoringGrid) throws AlreadyScoredException {
        switch (diagCode.getDiagnosticGroup().getId()) {
            case 1: {
                int tmpScore = this.calculatePrimaryAdjustment(scoringGrid, 1, 2);
                scoringGrid.setScore(diagCode, diagIdx, 1, tmpScore, false);
                ScoringEventFormatter.fireScoringIncreasePrimaryCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 1, tmpScore);
                break;
            }
            case 2: {
                int tmpScore = this.calculatePrimaryAdjustment(scoringGrid, 3, 4);
                scoringGrid.setScore(diagCode, diagIdx, 3, tmpScore, false);
                ScoringEventFormatter.fireScoringIncreasePrimaryCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 3, tmpScore);
                break;
            }
            case 3: {
                int tmpScore = this.getCaseMixAdjustmentEquation(5, 0);
                scoringGrid.addScore(diagCode, diagIdx, 5, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreasePrimaryCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 5, tmpScore);
                break;
            }
            case 4: {
                int tmpScore = this.calculatePrimaryAdjustment(scoringGrid, 6, 7);
                scoringGrid.setScore(diagCode, diagIdx, 6, tmpScore, false);
                ScoringEventFormatter.fireScoringIncreasePrimaryCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 6, tmpScore);
                break;
            }
            case 5: {
                int tmpScore = this.calculatePrimaryAdjustment(scoringGrid, 8, 9);
                scoringGrid.setScore(diagCode, diagIdx, 8, tmpScore, false);
                ScoringEventFormatter.fireScoringIncreasePrimaryCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 8, tmpScore);
                break;
            }
            case 7: {
                int tmpScore = this.calculatePrimaryAdjustment(scoringGrid, 11, 12);
                scoringGrid.setScore(diagCode, diagIdx, 11, tmpScore, false);
                ScoringEventFormatter.fireScoringIncreasePrimaryCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 11, tmpScore);
                break;
            }
            case 8: {
                int tmpScore = this.calculatePrimaryAdjustment(scoringGrid, 13, 14);
                scoringGrid.setScore(diagCode, diagIdx, 13, tmpScore, false);
                ScoringEventFormatter.fireScoringIncreasePrimaryCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 13, tmpScore);
                break;
            }
            case 9: {
                int tmpScore = this.calculatePrimaryAdjustment(scoringGrid, 15, 16);
                scoringGrid.setScore(diagCode, diagIdx, 15, tmpScore, false);
                ScoringEventFormatter.fireScoringIncreasePrimaryCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 15, tmpScore);
                break;
            }
            default: {
                if (this.getGrouper().getListenerCount() <= 0) break;
                ScoringEventFormatter.fireScoringGeneral(this.grouper.getEventListenersList(), this.grouper, this, "Diagnosis code '", diagCode.getCode(), "' valid for scoring, but Diagnosis Group ", Integer.toString(diagCode.getDiagnosticGroup().getId()), " not scorable for Primary-Only diagnosis.");
            }
        }
    }

    @Override
    public void scoreOtherOnly(HomeHealthRecordIF record, DiagnosisCodeIF diagCode, int diagIdx, DiagnosisScoringGridIF scoringGrid) throws AlreadyScoredException {
        switch (diagCode.getDiagnosticGroup().getId()) {
            case 1: {
                int tmpScore = this.getCaseMixAdjustmentEquation(2, 0);
                scoringGrid.addScore(diagCode, diagIdx, 2, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 2, tmpScore);
                break;
            }
            case 2: {
                int tmpScore = this.getCaseMixAdjustmentEquation(4, 0);
                scoringGrid.addScore(diagCode, diagIdx, 4, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 4, tmpScore);
                break;
            }
            case 4: {
                int tmpScore = this.getCaseMixAdjustmentEquation(7, 0);
                scoringGrid.addScore(diagCode, diagIdx, 7, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 7, tmpScore);
                break;
            }
            case 5: {
                int tmpScore = this.getCaseMixAdjustmentEquation(9, 0);
                scoringGrid.addScore(diagCode, diagIdx, 9, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 9, tmpScore);
                break;
            }
            case 7: {
                int tmpScore = this.getCaseMixAdjustmentEquation(12, 0);
                scoringGrid.addScore(diagCode, diagIdx, 12, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 12, tmpScore);
                break;
            }
            case 8: {
                int tmpScore = this.getCaseMixAdjustmentEquation(14, 0);
                scoringGrid.addScore(diagCode, diagIdx, 14, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 14, tmpScore);
                break;
            }
            case 9: {
                int tmpScore = this.getCaseMixAdjustmentEquation(16, 0);
                scoringGrid.addScore(diagCode, diagIdx, 16, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 16, tmpScore);
                break;
            }
            default: {
                if (this.getGrouper().getListenerCount() <= 0) break;
                ScoringEventFormatter.fireScoringGeneral(this.grouper.getEventListenersList(), this.grouper, this, "Diagnosis code '", diagCode.getCode(), "' valid for scoring, but Diagnosis Group ", diagCode.getDiagnosticGroup().getDescription(), " not scorable for Other-Only diagnosis.");
            }
        }
    }

    @Override
    public void scoreAny(HomeHealthRecordIF record, DiagnosisCodeIF diagCode, HomeHealthRecordValidatorIF validator, int diagIdx, DiagnosisScoringGridIF scoringGrid) throws AlreadyScoredException {
        switch (diagCode.getDiagnosticGroup().getId()) {
            case 6: {
                if (record.isDiagnosticGroupOnRecord(3, diagIdx)) break;
                int tmpScore = this.getCaseMixAdjustmentEquation(10, 0);
                scoringGrid.addScore(diagCode, diagIdx, 10, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 10, tmpScore);
                break;
            }
            case 10: {
                int tmpScore = this.getCaseMixAdjustmentEquation(17, 0);
                scoringGrid.addScore(diagCode, diagIdx, 17, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 17, tmpScore);
                break;
            }
            case 11: {
                int tmpScore = this.getCaseMixAdjustmentEquation(18, 0);
                scoringGrid.addScore(diagCode, diagIdx, 18, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 18, tmpScore);
                break;
            }
            case 12: {
                int tmpScore = this.getCaseMixAdjustmentEquation(19, 0);
                scoringGrid.addScore(diagCode, diagIdx, 19, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 19, tmpScore);
                break;
            }
        }
    }

    @Override
    public int scoreRemainingVariables(HomeHealthRecordIF recordBase, HomeHealthRecordValidatorIF validator, int currentScore) {
        String tmpStr;
        int tmpScore;
        int score = 0;
        HomeHealthRecord_B_IF record = (HomeHealthRecord_B_IF)recordBase;
        ScoringEventFormatter.fireScoringSectionStart(this.grouper.getEventListenersList(), this.grouper, this, "calculate Special Items");
        if (validator.isNPRSULC1_Valid()) {
            if (ValidateUtils.isValidValue(record.getNBR_PRSULC_STG1(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO})) {
                tmpScore = this.getCaseMixAdjustmentEquation(20, 0);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to NBR_PRSULC_STG1", 20, tmpScore);
            } else if (ValidateUtils.isValidValue(record.getNBR_PRSULC_STG1(), new String[][]{ValidateUtils.ARRAY_DOUBLE_THREE_FOUR})) {
                tmpScore = this.getCaseMixAdjustmentEquation(21, 0);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to NBR_PRSULC_STG1", 21, tmpScore);
            }
        }
        if (validator.isNPRSULC2_Valid() && record.getNBR_PRSULC_STG2() != null) {
            tmpStr = record.getNBR_PRSULC_STG2().trim();
            if ("01".equals(tmpStr) || "1".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(22, 0);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to NBR_PRSULC_STG2", 22, tmpScore);
            } else if ("02".equals(tmpStr) || "2".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(23, 0);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to NBR_PRSULC_STG2", 23, tmpScore);
            } else if ("03".equals(tmpStr) || "3".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(24, 0);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to NBR_PRSULC_STG2", 24, tmpScore);
            } else if ("04".equals(tmpStr) || "4".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(25, 0);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to NBR_PRSULC_STG2", 25, tmpScore);
            }
        }
        if (validator.isNPRSULC3_Valid() && record.getNBR_PRSULC_STG3() != null) {
            tmpStr = record.getNBR_PRSULC_STG3().trim();
            if ("01".equals(tmpStr) || "1".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(26, 0);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to NBR_PRSULC_STG3", 26, tmpScore);
            } else if ("02".equals(tmpStr) || "2".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(27, 0);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to NBR_PRSULC_STG3", 27, tmpScore);
            } else if ("03".equals(tmpStr) || "3".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(28, 0);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to NBR_PRSULC_STG3", 28, tmpScore);
            } else if ("04".equals(tmpStr) || "4".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(29, 0);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to NBR_PRSULC_STG3", 29, tmpScore);
            }
        }
        if (validator.isNPRSULC4_Valid() && record.getNBR_PRSULC_STG4() != null) {
            tmpStr = record.getNBR_PRSULC_STG4().trim();
            if ("01".equals(tmpStr) || "1".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(30, 0);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to NBR_PRSULC_STG4", 30, tmpScore);
            } else if ("02".equals(tmpStr) || "2".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(31, 0);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to NBR_PRSULC_STG4", 31, tmpScore);
            } else if ("03".equals(tmpStr) || "04".equals(tmpStr) || "3".equals(tmpStr) || "4".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(32, 0);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to NBR_PRSULC_STG4", 32, tmpScore);
            }
        }
        if (validator.isUNOBS_PRSULC_Valid() && "1".equals(record.getUNOBS_PRSULC())) {
            tmpScore = this.getCaseMixAdjustmentEquation(33, 0);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to UNOBS_PRSULC", 33, tmpScore);
        }
        if (validator.isNBR_STASULC_Valid()) {
            tmpStr = record.getNBR_STAS_ULCR();
            if ("02".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(34, 0);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to NBR_STASULC", 34, tmpScore);
            } else if ("03".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(35, 0);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to NBR_STASULC", 35, tmpScore);
            } else if ("04".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(36, 0);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to NBR_STASULC", 36, tmpScore);
            }
        }
        if (validator.isUNOBS_STASULC_Valid() && "1".equals(record.getUNOBS_STASULC())) {
            tmpScore = this.getCaseMixAdjustmentEquation(37, 0);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to UNOBS_STASULC", 37, tmpScore);
        }
        if (validator.isSTATSTASIS_Valid()) {
            tmpStr = record.getSTUS_PRBLM_STAS_ULCR();
            if ("01".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(38, 0);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to STAT_PRB_STASULC", 38, tmpScore);
            } else if ("02".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(39, 0);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to STAT_PRB_STASULC", 39, tmpScore);
            } else if ("03".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(40, 0);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to STAT_PRB_STASULC", 40, tmpScore);
            }
        }
        if (validator.isSTATSURG_Valid()) {
            tmpStr = record.getSTUS_PRBLM_SRGCL_WND();
            if ("02".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(41, 0);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to STAT_PRB_SURGWND", 41, tmpScore);
            } else if ("03".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(42, 0);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to STAT_PRB_SURGWND", 42, tmpScore);
            }
        }
        if (validator.isOSTOMY_Valid()) {
            tmpStr = record.getOSTOMY();
            if ("01".equals(tmpStr)) {
                if (currentScore > 0 || score > 0) {
                    tmpScore = this.getCaseMixAdjustmentEquation(45, 0);
                    score += tmpScore;
                    ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to OSTOMY and skin score > 0", 45, tmpScore);
                }
                tmpScore = this.getCaseMixAdjustmentEquation(43, 0);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to OSTOMY", 43, tmpScore);
            } else if ("02".equals(tmpStr)) {
                if (currentScore > 0 || score > 0) {
                    tmpScore = this.getCaseMixAdjustmentEquation(46, 0);
                    score += tmpScore;
                    ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to OSTOMY and skin score > 0", 46, tmpScore);
                }
                tmpScore = this.getCaseMixAdjustmentEquation(44, 0);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to OSTOMY", 44, tmpScore);
            }
        }
        if (validator.isTHERAPIES_Valid() && validator.isINTERNAL_LOGIC_Valid() && "1".equals(record.getTHH_IV_INFUSION())) {
            tmpScore = this.getCaseMixAdjustmentEquation(47, 0);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to THH_IV_INFUSION", 47, tmpScore);
        }
        if (validator.isUR_INCONT_Valid() && "02".equals(record.getUR_INCONT())) {
            tmpScore = this.getCaseMixAdjustmentEquation(48, 0);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to UR_INCONT", 48, tmpScore);
        }
        if (validator.isBWLINCONT_Valid() && ("04".equals(tmpStr = record.getBWL_INCONT()) || "05".equals(tmpStr))) {
            tmpScore = this.getCaseMixAdjustmentEquation(49, 0);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to BWL_INCONT", 49, tmpScore);
        }
        ScoringEventFormatter.fireScoringSectionFinished(this.grouper.getEventListenersList(), this.grouper, (HomeHealthScoringModelIF)this, "calculate Special Items", score);
        return score;
    }

    @Override
    public String getName() {
        return "Non-Routine Supplies Scoring Model 3210";
    }

    @Override
    public int getCaseMixAdjustmentEquation(int caseMixId, int equationId) {
        CaseMixAdjustmentItemIF nrsCasemix = this.grouperDataManager.getNRSCaseMixAdjustment(caseMixId);
        return nrsCasemix != null ? nrsCasemix.getEarly13AndUnder() : 0;
    }

    @Override
    protected DiagnosisCodeIF getDiagnosisCode(String codeValue) {
        DiagnosisCodeIF code = DiagnosisCode_Empty.DEFAULT;
        if (codeValue != null && !(codeValue = codeValue.trim()).isEmpty() && (code = this.grouperDataManager.getNRSDiagnosisCode(codeValue)) == null) {
            code = new DiagnosisCode(codeValue);
        }
        return code;
    }
}

