/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.v3312;

import com.mmm.cms.homehealth.GrouperDataManager;
import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordValidatorIF;
import com.mmm.cms.homehealth.v3210.GrouperVersion_v3210;
import com.mmm.cms.homehealth.v3312.ClinicalFunctional_ScoringModel_v3312;
import com.mmm.cms.homehealth.v3312.GrouperDataManager_V3312;
import com.mmm.cms.homehealth.v3312.HomeHealthRecordClinicalValidator_v3312;
import com.mmm.cms.homehealth.v3312.NRS_ScoringModel_v3312;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Properties;

public class GrouperVersion_v3312
extends GrouperVersion_v3210
implements HomeHealthGrouperIF {
    public GrouperVersion_v3312() {
        this(new GregorianCalendar(2012, 0, 1), new GregorianCalendar(2012, 11, 31), null, "V3312");
    }

    public GrouperVersion_v3312(Calendar start, Calendar thru, Calendar window, String versionName) {
        super(start, thru, window, versionName);
    }

    @Override
    public int[][] determineScoreOrder(HomeHealthRecordIF record) {
        int[][] scoreOrder = new int[6][3];
        block0: for (int diagIdx = 0; diagIdx < 6; ++diagIdx) {
            DiagnosisCodeIF diagCode = record.getDiagnosisCode(diagIdx);
            if (diagCode.isOptionalPaymentCode()) {
                DiagnosisCodeIF diagCodeOptional = record.getOptionalDiagnosisCode4(diagIdx);
                if (diagCodeOptional.isValidForScoring()) {
                    scoreOrder[diagIdx][2] = 2;
                    scoreOrder[diagIdx][1] = 2;
                    continue;
                }
                diagCodeOptional = record.getOptionalDiagnosisCode3(diagIdx);
                if (!diagCodeOptional.isValidForScoring()) continue;
                scoreOrder[diagIdx][1] = 1;
                continue;
            }
            if (!diagCode.isValidForScoring()) continue;
            if (diagCode.isSecondaryOnly()) {
                scoreOrder[diagIdx][0] = 2;
                for (int preIdx = diagIdx - 1; preIdx >= 0; --preIdx) {
                    DiagnosisCodeIF prevDiagCode = record.getDiagnosisCode(preIdx);
                    if (!diagCode.isValidEtiologyPairing(prevDiagCode)) continue;
                    scoreOrder[preIdx][0] = 2;
                    continue block0;
                }
                continue;
            }
            scoreOrder[diagIdx][0] = 1;
        }
        return scoreOrder;
    }

    @Override
    public HomeHealthRecordValidatorIF getClinicalValidator() {
        return new HomeHealthRecordClinicalValidator_v3312(this);
    }

    @Override
    public String getName() {
        return "HHA PPS Grouper - January 2012 Logic updates, " + this.getVersion();
    }

    @Override
    public HomeHealthRecordValidatorIF getNRSValidator() {
        return new HomeHealthRecordClinicalValidator_v3312(this);
    }

    @Override
    public void init(Properties props) throws Exception {
        GrouperDataManager_V3312 grouperManager = new GrouperDataManager_V3312(this);
        ((GrouperDataManager)grouperManager).init(props);
        this.setGrouperDataManager(grouperManager);
        this.clinicalModel_1 = new ClinicalFunctional_ScoringModel_v3312(this, grouperManager, 1);
        this.clinicalModel_2 = new ClinicalFunctional_ScoringModel_v3312(this, grouperManager, 2);
        this.clinicalModel_3 = new ClinicalFunctional_ScoringModel_v3312(this, grouperManager, 3);
        this.clinicalModel_4 = new ClinicalFunctional_ScoringModel_v3312(this, grouperManager, 4);
        this.nrsScoringModel = new NRS_ScoringModel_v3312(this, grouperManager);
    }
}

