/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.v3413;

import com.mmm.cms.homehealth.DiagnosisScoringGrid;
import com.mmm.cms.homehealth.GrouperDataManager;
import com.mmm.cms.homehealth.proto.AlreadyScoredException;
import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.DiagnosisScoringGridIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.HomeHealthScoringModelIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordValidatorIF;
import com.mmm.cms.homehealth.v3312.ClinicalFunctional_ScoringModel_v3312;
import com.mmm.cms.homehealth.v3312.ManifestationUtils;
import com.mmm.cms.util.ScoringEventFormatter;

public class ClinicalFunctional_ScoringModel_v3413
extends ClinicalFunctional_ScoringModel_v3312 {
    public ClinicalFunctional_ScoringModel_v3413(HomeHealthGrouperIF grouper, GrouperDataManager grouperDataManager, int equationId) {
        super(grouper, grouperDataManager, equationId);
    }

    @Override
    public String getName() {
        return "Clinical / Functional Scoring Model V3413";
    }

    @Override
    public int scoreClinical(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, int[][] scoreOrder) {
        DiagnosisScoringGrid scoringGrid = new DiagnosisScoringGrid();
        ScoringEventFormatter.fireScoringSectionStart(this.grouper.getEventListenersList(), this.grouper, this, "Clinical Scoring");
        for (int currentPass = 1; currentPass <= 2; ++currentPass) {
            for (int diagIdx = 0; diagIdx < 6; ++diagIdx) {
                DiagnosisCodeIF pairedDiagCode;
                DiagnosisCodeIF diagCode = record.getDiagnosisCode(diagIdx);
                if (diagCode.isVCode() && diagCode.isOptionalPaymentCode()) {
                    if (!diagCode.isEtiologyInPairingList(record.getOptionalDiagnosisCode3(diagIdx))) continue;
                    this.scoreClinicalColumn3_4(record, validator, diagIdx, scoringGrid, scoreOrder, currentPass);
                    continue;
                }
                if (currentPass != scoreOrder[diagIdx][0] || !diagCode.isValidForScoring()) continue;
                this.scoreClinicalCode(record, diagCode, validator, diagIdx, scoringGrid);
                if (!diagCode.isSecondaryOnly() || (pairedDiagCode = ManifestationUtils.getPairedCode(this.grouper, record, diagCode, diagIdx)) == null || !pairedDiagCode.isValidForScoring()) continue;
                if (scoringGrid.getTotalScoreForDiagnosis(pairedDiagCode.getOffset()) == 0) {
                    this.scoreClinicalCode(record, pairedDiagCode, validator, pairedDiagCode.getOffset(), scoringGrid);
                }
                this.resolveEtiologyManifestationContention(pairedDiagCode, pairedDiagCode.getOffset(), diagCode, diagIdx, scoringGrid);
            }
        }
        int totalScore = scoringGrid.getTotalScore();
        totalScore += this.scoreRemainingVariables(record, validator, totalScore);
        ScoringEventFormatter.fireScoringSectionFinished(this.grouper.getEventListenersList(), this.grouper, (HomeHealthScoringModelIF)this, "Clinical Scoring", totalScore);
        return totalScore;
    }

    @Override
    public void scoreClinicalCode(HomeHealthRecordIF record, DiagnosisCodeIF diagCode, HomeHealthRecordValidatorIF validator, int diagIdx, DiagnosisScoringGridIF scoringGrid) {
        if (this.grouper.getListenerCount() > 0) {
            ScoringEventFormatter.fireScoringGeneral(this.grouper.getEventListenersList(), this.grouper, this, "Attempting to score Diagnosis ", diagCode.getCode(), " (", diagCode.getDiagnosticGroup().getDescription(), ") at position ", Integer.toString(diagIdx + 1));
        }
        try {
            if (diagIdx == 0 || diagIdx == 6 || diagCode.isSecondaryOnly() && (diagIdx == 1 || diagIdx == 12)) {
                this.scorePrimaryOnly(record, diagCode, diagIdx, scoringGrid);
            } else if (diagIdx == 1 && record.getPRIMARY_DIAG_ICD().isPrimaryAwardableCode() && diagCode.getDiagnosticGroup().isAlternatePrimaryScorable()) {
                this.scorePrimaryOnly(record, diagCode, diagIdx, scoringGrid);
            } else if (diagIdx == 2 && diagCode.isSecondaryOnly() && record.getPRIMARY_DIAG_ICD().isPrimaryAwardableCode() && record.getOTH_DIAG1_ICD().getDiagnosticGroup().isAlternatePrimaryScorable()) {
                this.scorePrimaryOnly(record, diagCode, diagIdx, scoringGrid);
            } else if (diagIdx == 2 && diagCode.isSecondaryOnly() && record.getPRIMARY_DIAG_ICD().isPrimaryAwardableCode() && diagCode.getDiagnosticGroup().isAlternatePrimaryScorable()) {
                this.scorePrimaryOnly(record, diagCode, diagIdx, scoringGrid);
            } else {
                this.scoreOtherOnly(record, diagCode, diagIdx, scoringGrid);
            }
            this.scoreAny(record, diagCode, validator, diagIdx, scoringGrid);
        }
        catch (AlreadyScoredException e) {
            ScoringEventFormatter.fireDxGroupAlreadyScored(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, e);
        }
    }

    @Override
    public void scorePrimaryOnly(HomeHealthRecordIF record, DiagnosisCodeIF diagCode, int diagIdx, DiagnosisScoringGridIF scoringGrid) throws AlreadyScoredException {
        switch (diagCode.getDiagnosticGroup().getId()) {
            case 4: {
                int tmpScore = this.calculatePrimaryAdjustment(scoringGrid, 4, 5);
                scoringGrid.addScore(diagCode, diagIdx, 4, tmpScore, false);
                ScoringEventFormatter.fireScoringIncreasePrimaryCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 4, tmpScore);
                break;
            }
            case 10: {
                int tmpScore = this.getCaseMixAdjustmentEquation(12, super.getEquationId());
                scoringGrid.addScore(diagCode, diagIdx, 12, tmpScore, false);
                ScoringEventFormatter.fireScoringIncreasePrimaryCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 12, tmpScore);
                break;
            }
            case 19: {
                int tmpScore = this.calculatePrimaryAdjustment(scoringGrid, 25, 26);
                scoringGrid.addScore(diagCode, diagIdx, 25, tmpScore, false);
                ScoringEventFormatter.fireScoringIncreasePrimaryCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 25, tmpScore);
                break;
            }
        }
    }
}

