/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.v4115;

import com.mmm.cms.homehealth.AbstractGrouper_2;
import com.mmm.cms.homehealth.PointsScoringEquations;
import com.mmm.cms.homehealth.ScoringEventCollector;
import com.mmm.cms.homehealth.ScoringResults;
import com.mmm.cms.homehealth.TreatmentAuthorization_2015;
import com.mmm.cms.homehealth.hipps.HIPPSCode_2015;
import com.mmm.cms.homehealth.proto.DiagnosisScoringStatus_EN;
import com.mmm.cms.homehealth.proto.HIPPSCodeIF;
import com.mmm.cms.homehealth.proto.HomeHealthEventIF;
import com.mmm.cms.homehealth.proto.HomeHealthEventListenerIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.PointsScoringEquationsIF;
import com.mmm.cms.homehealth.proto.ScoringPointsIF;
import com.mmm.cms.homehealth.proto.ScoringResultsIF;
import com.mmm.cms.homehealth.proto.edits.HH_PPS_OasisC1EditsEN;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordValidatorIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecord_C1_IF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecord_C_IF;
import com.mmm.cms.homehealth.v4115.ClinicalFunctional_ScoringModel_v4115;
import com.mmm.cms.homehealth.v4115.GrouperDataManager_V4115;
import com.mmm.cms.homehealth.v4115.HomeHealthRecordValidator_v4115;
import com.mmm.cms.homehealth.v4115.NRS_ScoringModel_v4115;
import com.mmm.cms.homehealth.vut.proto.CollectionValidationEditsIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditIF;
import com.mmm.cms.util.ScoringEventFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class GrouperVersion_v4115
extends AbstractGrouper_2
implements HomeHealthGrouperIF {
    public GrouperVersion_v4115() {
        super(new GregorianCalendar(2015, 0, 1), new GregorianCalendar(2015, 8, 30), null, "V4115");
    }

    protected GrouperVersion_v4115(Calendar effectiveStart, Calendar effectiveThru, Calendar effectiveWindow, String versionName) {
        super(effectiveStart, effectiveThru, effectiveWindow, versionName);
    }

    @Override
    public Class getAcceptableRecordClass() {
        return HomeHealthRecord_C1_IF.class;
    }

    @Override
    public HomeHealthRecordValidatorIF getClinicalValidator() {
        return new HomeHealthRecordValidator_v4115(this);
    }

    public HomeHealthRecordValidatorIF getClinicalValidator(CollectionValidationEditsIF validationEdits) {
        return new HomeHealthRecordValidator_v4115(this, validationEdits);
    }

    @Override
    public HomeHealthRecordValidatorIF getNRSValidator() {
        return new HomeHealthRecordValidator_v4115(this);
    }

    public HomeHealthRecordValidatorIF getNRSValidator(CollectionValidationEditsIF validationEdits) {
        return new HomeHealthRecordValidator_v4115(this, validationEdits);
    }

    @Override
    public void init(Properties props) throws Exception {
        this.dataManager = new GrouperDataManager_V4115(this);
        this.dataManager.init(props);
        this.clinicalModel_1 = new ClinicalFunctional_ScoringModel_v4115(this, this.dataManager, 1);
        this.clinicalModel_2 = new ClinicalFunctional_ScoringModel_v4115(this, this.dataManager, 2);
        this.clinicalModel_3 = new ClinicalFunctional_ScoringModel_v4115(this, this.dataManager, 3);
        this.clinicalModel_4 = new ClinicalFunctional_ScoringModel_v4115(this, this.dataManager, 4);
        this.nrsScoringModel = new NRS_ScoringModel_v4115(this, this.dataManager);
    }

    @Override
    public HomeHealthRecordValidatorIF populateValidateClinicalCodes(HomeHealthRecordIF record) {
        HomeHealthRecordValidatorIF validator = this.getClinicalValidator();
        this.clinicalModel_1.populateCodes(record);
        validator.validate(record);
        return validator;
    }

    @Override
    public ScoringResultsIF score(HomeHealthRecordIF recordOasisC, boolean validateDates, CollectionValidationEditsIF validationEdits, Collection<HomeHealthEventListenerIF> listeners) {
        ScoringResults scoringResult;
        boolean eventCollectorFound;
        boolean listenersCreated;
        ScoringEventCollector scoringEventCollector = null;
        if (listeners == null) {
            listenersCreated = true;
            listeners = new ArrayList<HomeHealthEventListenerIF>();
        } else {
            listenersCreated = false;
            for (HomeHealthEventListenerIF listener : listeners) {
                if (!(listener instanceof ScoringEventCollector)) continue;
                scoringEventCollector = (ScoringEventCollector)listener;
                break;
            }
        }
        if (scoringEventCollector == null) {
            scoringEventCollector = new ScoringEventCollector();
            listeners.add(scoringEventCollector);
            eventCollectorFound = false;
        } else {
            eventCollectorFound = true;
        }
        ScoringEventFormatter.fireScoringRecord(listeners, this, "Pre-scoring: ", recordOasisC);
        if (validateDates && !this.isValidForVersion(recordOasisC)) {
            ScoringEventFormatter.fireScoringGeneral(listeners, this, null, ": record not valid for this version");
            scoringResult = new ScoringResults(recordOasisC);
        } else if (recordOasisC instanceof HomeHealthRecord_C_IF) {
            HIPPSCodeIF hippsCode;
            DiagnosisScoringStatus_EN[] diagnosisStatus = new DiagnosisScoringStatus_EN[6];
            DiagnosisScoringStatus_EN[] nrsDiagnosisStatus = new DiagnosisScoringStatus_EN[6];
            PointsScoringEquations clinicalScore = new PointsScoringEquations();
            PointsScoringEquations functionalScore = new PointsScoringEquations();
            ScoringEventFormatter.fireScoringGeneral(listeners, this, null, "populating codes for Clinical/Functional scoring");
            this.clinicalModel_1.populateCodes(recordOasisC);
            ScoringEventFormatter.fireScoringRecord(listeners, this, "Post-populating record: ", recordOasisC);
            ScoringEventFormatter.fireScoringGeneral(listeners, this, null, "Validating record");
            HomeHealthRecordValidatorIF validator = this.getClinicalValidator(validationEdits);
            CollectionValidationEditsIF validationEdits_Results = validator.validate(recordOasisC, listeners);
            ScoringEventFormatter.fireScoringGeneral(listeners, this, null, "Validating record - Done");
            this.reportNonScoringDiagnosis(recordOasisC, diagnosisStatus, this.clinicalModel_1, listeners);
            List editList = validationEdits_Results.getEdits((OasisEditIF)HH_PPS_OasisC1EditsEN.EDIT_70020);
            if (editList == null || editList.isEmpty()) {
                HomeHealthRecordValidatorIF nrsValidator;
                int[][] scoreOrder = this.determineScoreOrder(recordOasisC);
                this.reportPrimaryCodeSelection(listeners, recordOasisC, scoreOrder);
                ScoringPointsIF scoringPoints = this.clinicalModel_1.score(recordOasisC, validator, scoreOrder, listeners);
                clinicalScore.setEarly13AndUnder(scoringPoints.getScores()[0]);
                functionalScore.setEarly13AndUnder(scoringPoints.getScores()[1]);
                scoringPoints = this.clinicalModel_2.score(recordOasisC, validator, scoreOrder, listeners);
                clinicalScore.setEarly14Plus(scoringPoints.getScores()[0]);
                functionalScore.setEarly14Plus(scoringPoints.getScores()[1]);
                scoringPoints = this.clinicalModel_3.score(recordOasisC, validator, scoreOrder, listeners);
                clinicalScore.setLater13AndUnder(scoringPoints.getScores()[0]);
                functionalScore.setLater13AndUnder(scoringPoints.getScores()[1]);
                scoringPoints = this.clinicalModel_4.score(recordOasisC, validator, scoreOrder, listeners);
                clinicalScore.setLater14Plus(scoringPoints.getScores()[0]);
                functionalScore.setLater14Plus(scoringPoints.getScores()[1]);
                ScoringEventFormatter.fireScoringGeneral(listeners, this, null, "populating codes for Non-Routine Supplies scoring");
                this.nrsScoringModel.populateCodes(recordOasisC);
                ScoringEventFormatter.fireScoringRecord(listeners, this, "Post-populate with NRS Diagnosis: ", recordOasisC);
                ScoringEventFormatter.fireScoringGeneral(listeners, this, null, "Validating NRS record");
                if (validationEdits == null) {
                    nrsValidator = this.getNRSValidator();
                    nrsValidator.validate(recordOasisC, listeners);
                } else {
                    nrsValidator = this.getNRSValidator(((HomeHealthRecordValidator_v4115)validator).getEdits());
                }
                ScoringEventFormatter.fireScoringGeneral(listeners, this, null, "Validating NRS record - Done");
                this.reportNonScoringDiagnosis(recordOasisC, nrsDiagnosisStatus, this.nrsScoringModel, listeners);
                scoreOrder = this.determineScoreOrder(recordOasisC);
                this.reportPrimaryCodeSelection(listeners, recordOasisC, scoreOrder);
                scoringPoints = this.nrsScoringModel.score(recordOasisC, nrsValidator, scoreOrder, listeners);
                int nrsScore = scoringPoints.getScores()[0];
                hippsCode = this.createHippsCode(recordOasisC, validator, clinicalScore, functionalScore, nrsScore);
            } else {
                hippsCode = this.createHippsCode();
            }
            TreatmentAuthorization_2015 treatment = hippsCode.getCode().trim().isEmpty() ? new TreatmentAuthorization_2015(recordOasisC) : new TreatmentAuthorization_2015(recordOasisC, validator, clinicalScore, functionalScore);
            scoringResult = new ScoringResults(((HomeHealthRecordValidator_v4115)validator).getEdits(), scoringEventCollector.getEvents(), hippsCode, this.getVersion(), validator.getDataValidityFlag(), treatment, diagnosisStatus, nrsDiagnosisStatus);
        } else {
            ScoringEventFormatter.fireScoringGeneral(listeners, this, null, ": Invalid record format for this version");
            scoringResult = new ScoringResults(recordOasisC);
        }
        if (!listenersCreated && !eventCollectorFound) {
            listeners.remove(scoringEventCollector);
        }
        return scoringResult;
    }

    @Override
    public void addEventListener(HomeHealthEventListenerIF listener) {
    }

    @Override
    public Iterator<HomeHealthEventListenerIF> getEventListeners() {
        return null;
    }

    @Override
    public List<HomeHealthEventListenerIF> getEventListenersList() {
        return null;
    }

    @Override
    public void notifyEventListeners(HomeHealthEventIF event) {
    }

    @Override
    public void removeEventListeners() {
    }

    @Override
    public void removeEventListener(HomeHealthEventListenerIF listener) {
    }

    @Override
    public int getListenerCount() {
        return 0;
    }

    public void reportPrimaryCodeSelection(Collection<HomeHealthEventListenerIF> listeners, HomeHealthRecordIF recordOasisC, int[][] scoreOrder) {
        int idx;
        int n = idx = recordOasisC.getPRIMARY_DIAG_ICD().isPrimaryAwardableCode() ? 1 : 0;
        if (scoreOrder[idx][0] > 0) {
            ScoringEventFormatter.fireScoringGeneral(listeners, this, null, "Primary Code identified for Scoring: ", recordOasisC.getDiagnosisCode(idx).getCode(), " in position ", Integer.toString(idx + 1));
        }
        if (scoreOrder[++idx][0] == 2) {
            ScoringEventFormatter.fireScoringGeneral(listeners, this, null, "Primary Code identified for Scoring: ", recordOasisC.getDiagnosisCode(idx).getCode(), " in position ", Integer.toString(idx + 1));
        }
    }

    @Override
    public HIPPSCodeIF createHippsCode() {
        return new HIPPSCode_2015();
    }

    @Override
    public HIPPSCodeIF createHippsCode(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, PointsScoringEquationsIF clinicalScore, PointsScoringEquationsIF functionalScore, int nrsScore) {
        return new HIPPSCode_2015(record, validator, clinicalScore, functionalScore, nrsScore);
    }
}

