/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.v8119;

import com.mmm.cms.homehealth.proto.DataManagerIF;
import com.mmm.cms.homehealth.proto.HomeHealthEventListenerIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.HomeHealthScoringModelIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordValidatorIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecord_D_IF;
import com.mmm.cms.homehealth.v5115.NRS_ScoringModel_v5115;
import com.mmm.cms.util.IntegerUtils;
import com.mmm.cms.util.ScoringEventFormatter;
import com.mmm.cms.util.ScoringModelUtils;
import com.mmm.cms.util.ValidateUtils;
import java.util.Collection;

public class NRS_ScoringModel_v8119
extends NRS_ScoringModel_v5115 {
    public NRS_ScoringModel_v8119(HomeHealthGrouperIF grouper, DataManagerIF dataManager) {
        super(grouper, dataManager);
    }

    @Override
    public String getName() {
        return "Non-Routine Supplies Scoring Model V8119";
    }

    @Override
    public int scoreRemainingVariables(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, int currentScore, Collection<HomeHealthEventListenerIF> listeners) {
        String tmpStr;
        int tmpScore;
        int tmpInt;
        int score = 0;
        ScoringEventFormatter.fireScoringSectionStart(listeners, this.grouper, this, "calculate Special Items");
        if (validator.isNPRSULC1_Valid()) {
            tmpInt = IntegerUtils.parseInt(record.getNBR_PRSULC_STG1(), Integer.MAX_VALUE);
            if (tmpInt == 1 || tmpInt == 2) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 20, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to NBR_PRSULC_STG1", 20, tmpScore);
            } else if (tmpInt == 3 || tmpInt == 4) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 21, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to NBR_PRSULC_STG1", 21, tmpScore);
            }
        }
        if (validator.isNPRSULC2_Valid() && !ValidateUtils.isValidValue(tmpStr = record.getNBR_PRSULC_STG2(), ValidateUtils.ARRAY_CARET_VALUES, ValidateUtils.ARRAY_DASH_VALUES)) {
            tmpInt = IntegerUtils.parseInt(tmpStr, Integer.MAX_VALUE);
            if (1 == tmpInt) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 22, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to NBR_PRSULC_STG2", 22, tmpScore);
            } else if (2 == tmpInt) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 23, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to NBR_PRSULC_STG2", 23, tmpScore);
            } else if (3 == tmpInt) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 24, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to NBR_PRSULC_STG2", 24, tmpScore);
            } else if (4 <= tmpInt) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 25, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to NBR_PRSULC_STG2", 25, tmpScore);
            }
        }
        if (validator.isNPRSULC3_Valid() && !ValidateUtils.isValidValue(tmpStr = record.getNBR_PRSULC_STG3(), ValidateUtils.ARRAY_CARET_VALUES, ValidateUtils.ARRAY_DASH_VALUES)) {
            tmpInt = IntegerUtils.parseInt(tmpStr, Integer.MAX_VALUE);
            if (1 == tmpInt) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 26, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to NBR_PRSULC_STG3", 26, tmpScore);
            } else if (2 == tmpInt) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 27, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to NBR_PRSULC_STG3", 27, tmpScore);
            } else if (3 == tmpInt) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 28, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to NBR_PRSULC_STG3", 28, tmpScore);
            } else if (4 <= tmpInt) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 29, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to NBR_PRSULC_STG3", 29, tmpScore);
            }
        }
        if (validator.isNPRSULC4_Valid() && !ValidateUtils.isValidValue(tmpStr = record.getNBR_PRSULC_STG4(), ValidateUtils.ARRAY_CARET_VALUES, ValidateUtils.ARRAY_DASH_VALUES)) {
            tmpInt = IntegerUtils.parseInt(tmpStr, Integer.MAX_VALUE);
            if (1 == tmpInt) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 30, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to NBR_PRSULC_STG4", 30, tmpScore);
            } else if (2 == tmpInt) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 31, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to NBR_PRSULC_STG4", 31, tmpScore);
            } else if (3 <= tmpInt) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 32, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to NBR_PRSULC_STG4", 32, tmpScore);
            }
        }
        if (validator.isUNOBS_PRSULC_Valid()) {
            tmpInt = IntegerUtils.parseInt(((HomeHealthRecord_D_IF)record).getNSTG_DRSG(), Integer.MIN_VALUE);
            int tmpInt2 = IntegerUtils.parseInt(((HomeHealthRecord_D_IF)record).getNSTG_CVRG(), Integer.MIN_VALUE);
            if (tmpInt > 0 || tmpInt2 > 0) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 33, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to NSTG_DRSG or NSTG_CVRG", 33, tmpScore);
            }
        }
        if (validator.isNBR_STASULC_Valid()) {
            tmpInt = IntegerUtils.parseInt(record.getNBR_STAS_ULCR(), Integer.MAX_VALUE);
            if (tmpInt == 2) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 34, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to NBR_STASULC", 34, tmpScore);
            } else if (tmpInt == 3) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 35, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to NBR_STASULC", 35, tmpScore);
            } else if (tmpInt == 4) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 36, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to NBR_STASULC", 36, tmpScore);
            }
        }
        if (validator.isUNOBS_STASULC_Valid() && ((tmpInt = IntegerUtils.parseInt(record.getSTAS_ULCR_PRSNT(), Integer.MAX_VALUE)) == 1 || tmpInt == 3)) {
            tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 37, this.getId());
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to Unobserved STAS_ULCR_PRSNT", 37, tmpScore);
        }
        if (validator.isSTATSTASIS_Valid()) {
            tmpInt = IntegerUtils.parseInt(record.getSTUS_PRBLM_STAS_ULCR(), Integer.MAX_VALUE);
            if (tmpInt == 1) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 38, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to STAT_PRB_STASULC", 38, tmpScore);
            } else if (tmpInt == 2) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 39, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to STAT_PRB_STASULC", 39, tmpScore);
            } else if (tmpInt == 3) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 40, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to STAT_PRB_STASULC", 40, tmpScore);
            }
        }
        if (validator.isSTATSURG_Valid()) {
            tmpInt = IntegerUtils.parseInt(record.getSTUS_PRBLM_SRGCL_WND(), Integer.MAX_VALUE);
            if (tmpInt == 2) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 41, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to STAT_PRB_SURGWND", 41, tmpScore);
            } else if (tmpInt == 3) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 42, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to STAT_PRB_SURGWND", 42, tmpScore);
            }
        }
        if (validator.isOSTOMY_Valid()) {
            tmpInt = IntegerUtils.parseInt(record.getOSTOMY(), Integer.MAX_VALUE);
            if (tmpInt == 1) {
                if (currentScore > 0 || score > 0) {
                    tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 45, this.getId());
                    score += tmpScore;
                    ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to OSTOMY and skin score > 0", 45, tmpScore);
                }
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 43, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to OSTOMY", 43, tmpScore);
            } else if (tmpInt == 2) {
                if (currentScore > 0 || score > 0) {
                    tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 46, this.getId());
                    score += tmpScore;
                    ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to OSTOMY and skin score > 0", 46, tmpScore);
                }
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 44, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to OSTOMY", 44, tmpScore);
            }
        }
        if (validator.isTHERAPIES_Valid() && validator.isINTERNAL_LOGIC_Valid() && "1".equals(record.getTHH_IV_INFUSION())) {
            tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 47, this.getId());
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to THH_IV_INFUSION", 47, tmpScore);
        }
        if (validator.isUR_INCONT_Valid() && (tmpInt = IntegerUtils.parseInt(record.getUR_INCONT(), Integer.MAX_VALUE)) == 2) {
            tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 48, this.getId());
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to UR_INCONT", 48, tmpScore);
        }
        if (validator.isBWLINCONT_Valid() && ((tmpInt = IntegerUtils.parseInt(record.getBWL_INCONT(), Integer.MAX_VALUE)) == 4 || tmpInt == 5)) {
            tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 49, this.getId());
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to BWL_INCONT", 49, tmpScore);
        }
        ScoringEventFormatter.fireScoringSectionFinished(listeners, this.grouper, (HomeHealthScoringModelIF)this, "calculate Special Items", score);
        return score;
    }
}

