/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.vut;

import com.mmm.cms.homehealth.vut.proto.CollectionValidationEditsIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditIF;
import com.mmm.cms.homehealth.vut.proto.OasisValidationEditIF;
import java.util.ArrayList;
import java.util.List;

public class CollectionValidationEdits
extends ArrayList<OasisValidationEditIF>
implements CollectionValidationEditsIF {
    @Override
    public boolean add(OasisValidationEditIF newEdit) {
        long editId = newEdit.getEdit().getId();
        String dataItem = (String)newEdit.getOasisDataItem().getKey();
        for (OasisValidationEditIF edit : this) {
            if (editId != edit.getEdit().getId() || !dataItem.equals(edit.getOasisDataItem().getKey())) continue;
            return false;
        }
        return super.add(newEdit);
    }

    public List<OasisValidationEditIF> getEdits(OasisEditIF editType) {
        ArrayList<OasisValidationEditIF> edits = new ArrayList<OasisValidationEditIF>();
        for (OasisValidationEditIF edit : this) {
            if (edit.getEdit() != editType) continue;
            edits.add(edit);
        }
        return edits;
    }

    public List<OasisValidationEditIF> getEdits(String dataItemName) {
        ArrayList<OasisValidationEditIF> edits = new ArrayList<OasisValidationEditIF>();
        for (OasisValidationEditIF edit : this) {
            if (!dataItemName.equals(edit.getOasisDataItem().getKey())) continue;
            edits.add(edit);
        }
        return edits;
    }

    public boolean isEditPresent(OasisEditIF editType) {
        boolean present = false;
        for (OasisValidationEditIF edit : this) {
            if (edit.getEdit() != editType) continue;
            present = true;
            break;
        }
        return present;
    }

    public boolean isEditPresent(String dataItemName) {
        boolean present = false;
        for (OasisValidationEditIF edit : this) {
            if (!dataItemName.equals(edit.getOasisDataItem().getKey())) continue;
            present = true;
            break;
        }
        return present;
    }

    @Override
    public String toString() {
        int idx = 0;
        StringBuilder buffer = new StringBuilder(512);
        buffer.append("CollectionValidationEdits{");
        for (OasisValidationEditIF edit : this) {
            if (idx++ > 0) {
                buffer.append(",");
            }
            buffer.append("{ ");
            buffer.append(edit.toString());
            buffer.append("}");
        }
        buffer.append("}");
        return buffer.toString();
    }
}

