/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.vut.oasis;

import com.mmm.cms.homehealth.proto.RecordItemValidatorIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecord_C1_IF;
import com.mmm.cms.homehealth.vut.HHOasisDataItem;
import com.mmm.cms.homehealth.vut.OasisValidationEdit;
import com.mmm.cms.homehealth.vut.oasis.AbstractClinicalItemValidator;
import com.mmm.cms.homehealth.vut.oasis.AbstractItemValidator;
import com.mmm.cms.homehealth.vut.proto.CollectionValidationEditsIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditsEN;
import com.mmm.cms.util.IntegerUtils;
import com.mmm.cms.util.ValidateUtils;
import java.util.List;

public class ValidatePressureUlcer_OASIS_C1
extends AbstractClinicalItemValidator
implements RecordItemValidatorIF {
    static final String[] validNumberOf;

    public ValidatePressureUlcer_OASIS_C1() {
        super(HomeHealthRecord_C1_IF.class);
    }

    @Override
    public List<OasisEditIF> getEditIdsUsed() {
        return super.getEditIdsUsed_base(new OasisEditIF[]{OasisEditsEN.EDIT_3060, OasisEditsEN.EDIT_3010, OasisEditsEN.EDIT_4130, OasisEditsEN.EDIT_4140, OasisEditsEN.EDIT_4150, OasisEditsEN.EDIT_4160, OasisEditsEN.EDIT_4170, OasisEditsEN.EDIT_4210, OasisEditsEN.EDIT_5110, OasisEditsEN.EDIT_5120, OasisEditsEN.EDIT_5130});
    }

    @Override
    public int validate(HomeHealthRecordIF record, CollectionValidationEditsIF edits) {
        int count = 0;
        String assessmentReason = record.getASSMT_REASON();
        if (ValidateUtils.isValidValue(assessmentReason, new String[][]{AbstractItemValidator.ASSESSMENT_1_3_4_5_9_ONLY}) && record instanceof HomeHealthRecord_C1_IF) {
            int intNonStageDeepTissue;
            HomeHealthRecord_C1_IF recordC = (HomeHealthRecord_C1_IF)record;
            String UNHLD_STG2_PRSR_ULCR = recordC.getUNHLD_STG2_PRSR_ULCR();
            String STG_PRBLM_ULCER = recordC.getSTG_PRBLM_ULCER();
            String NBR_PRSULC_STG1 = recordC.getNBR_PRSULC_STG1();
            String NBR_PRSULC_STG2 = recordC.getNBR_PRSULC_STG2();
            String NBR_PRSULC_STG3 = recordC.getNBR_PRSULC_STG3();
            String NBR_PRSULC_STG4 = recordC.getNBR_PRSULC_STG4();
            String NSTG_CVRG = recordC.getNSTG_CVRG();
            String NSTG_DEEP_TISUE = recordC.getNSTG_DEEP_TISUE();
            String NSTG_DRSG = recordC.getNSTG_DRSG();
            String STUS_PRBLM_PRSR_ULCR = recordC.getSTUS_PRBLM_PRSR_ULCR();
            boolean isRFA_1_3_9 = ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{AbstractItemValidator.ASSESSMENT_1_3_9_ONLY});
            if (!ValidateUtils.isEmpty(UNHLD_STG2_PRSR_ULCR) && !ValidateUtils.isNumeric(UNHLD_STG2_PRSR_ULCR)) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3060, new HHOasisDataItem("M1306_UNHLD_STG2_PRSR_ULCR", UNHLD_STG2_PRSR_ULCR)));
            }
            if (!ValidateUtils.isEmptyCaret(NBR_PRSULC_STG2) && !this.isValueInRange01To99(NBR_PRSULC_STG2)) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3010, new HHOasisDataItem("M1308_NBR_PRSULC_STG2", NBR_PRSULC_STG2)));
            }
            if (!ValidateUtils.isEmptyCaret(NBR_PRSULC_STG3) && !this.isValueInRange01To99(NBR_PRSULC_STG3)) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3010, new HHOasisDataItem("M1308_NBR_PRSULC_STG3", NBR_PRSULC_STG3)));
            }
            if (!ValidateUtils.isEmptyCaret(NBR_PRSULC_STG4) && !this.isValueInRange01To99(NBR_PRSULC_STG4)) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3010, new HHOasisDataItem("M1308_NBR_PRSULC_STG4", NBR_PRSULC_STG4)));
            }
            if (!ValidateUtils.isEmptyCaret(NSTG_CVRG) && !this.isValueInRange01To99(NSTG_CVRG)) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3010, new HHOasisDataItem("M1308_NSTG_CVRG", NSTG_CVRG)));
            }
            if (!ValidateUtils.isEmptyCaret(NSTG_DEEP_TISUE) && !this.isValueInRange01To99(NSTG_DEEP_TISUE)) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3010, new HHOasisDataItem("M1308_NSTG_DEEP_TISUE", NSTG_DEEP_TISUE)));
            }
            if (!ValidateUtils.isEmptyCaret(NSTG_DRSG) && !this.isValueInRange01To99(NSTG_DRSG)) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3010, new HHOasisDataItem("M1308_NSTG_DRSG", NSTG_DRSG)));
            }
            if (isRFA_1_3_9 && !ValidateUtils.isValidValue(STUS_PRBLM_PRSR_ULCR, ValidateUtils.ARRAY_DOUBLE_0, ValidateUtils.ARRAY_DOUBLE_1, ValidateUtils.ARRAY_DOUBLE_2, ValidateUtils.ARRAY_DOUBLE_3, ValidateUtils.ARRAY_CARET_VALUES, {"NA"})) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3060, new HHOasisDataItem("M1320_STUS_PRBLM_PRSR_ULCR", STUS_PRBLM_PRSR_ULCR)));
            }
            if (!ValidateUtils.isValidValue(STG_PRBLM_ULCER, ValidateUtils.ARRAY_DOUBLE_1, ValidateUtils.ARRAY_DOUBLE_2, ValidateUtils.ARRAY_DOUBLE_3, ValidateUtils.ARRAY_DOUBLE_4, {"NA"})) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3060, new HHOasisDataItem("M1324_STG_PRBLM_ULCER", STG_PRBLM_ULCER)));
            }
            if ("0".equals(UNHLD_STG2_PRSR_ULCR)) {
                if (!(ValidateUtils.isEmpty(NBR_PRSULC_STG2) && ValidateUtils.isEmpty(NBR_PRSULC_STG3) && ValidateUtils.isEmpty(NBR_PRSULC_STG4) && ValidateUtils.isEmpty(NSTG_CVRG) && ValidateUtils.isEmpty(NSTG_DEEP_TISUE) && ValidateUtils.isEmpty(NSTG_DRSG) && ValidateUtils.isEmpty(STUS_PRBLM_PRSR_ULCR))) {
                    ++count;
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5110, new HHOasisDataItem("M1306_UNHLD_STG2_PRSR_ULCR", UNHLD_STG2_PRSR_ULCR)));
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5110, new HHOasisDataItem("M1308_NBR_PRSULC_STG2", NBR_PRSULC_STG2)));
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5110, new HHOasisDataItem("M1308_NBR_PRSULC_STG3", NBR_PRSULC_STG3)));
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5110, new HHOasisDataItem("M1308_NBR_PRSULC_STG4", NBR_PRSULC_STG4)));
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5110, new HHOasisDataItem("M1308_NSTG_CVRG", NSTG_CVRG)));
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5110, new HHOasisDataItem("M1308_NSTG_DRSG", NSTG_DRSG)));
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5110, new HHOasisDataItem("M1308_NSTG_DEEP_TISUE", NSTG_DEEP_TISUE)));
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5110, new HHOasisDataItem("M1320_STUS_PRBLM_PRSR_ULCR", STUS_PRBLM_PRSR_ULCR)));
                }
            } else if ("1".equals(UNHLD_STG2_PRSR_ULCR)) {
                if (ValidateUtils.isEmpty(NBR_PRSULC_STG2) || edits.isEditPresent("M1308_NBR_PRSULC_STG2") || ValidateUtils.isEmpty(NBR_PRSULC_STG3) || edits.isEditPresent("M1308_NBR_PRSULC_STG3") || ValidateUtils.isEmpty(NBR_PRSULC_STG4) || edits.isEditPresent("M1308_NBR_PRSULC_STG4") || ValidateUtils.isEmpty(NSTG_CVRG) || edits.isEditPresent("M1308_NSTG_CVRG") || ValidateUtils.isEmpty(NSTG_DEEP_TISUE) || edits.isEditPresent("M1308_NSTG_DEEP_TISUE") || ValidateUtils.isEmpty(NSTG_DRSG) || edits.isEditPresent("M1308_NSTG_DRSG")) {
                    ++count;
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5120, new HHOasisDataItem("M1306_UNHLD_STG2_PRSR_ULCR", UNHLD_STG2_PRSR_ULCR)));
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5120, new HHOasisDataItem("M1308_NBR_PRSULC_STG2", NBR_PRSULC_STG2)));
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5120, new HHOasisDataItem("M1308_NBR_PRSULC_STG3", NBR_PRSULC_STG3)));
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5120, new HHOasisDataItem("M1308_NBR_PRSULC_STG4", NBR_PRSULC_STG4)));
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5120, new HHOasisDataItem("M1308_NSTG_CVRG", NSTG_CVRG)));
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5120, new HHOasisDataItem("M1308_NSTG_DRSG", NSTG_DRSG)));
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5120, new HHOasisDataItem("M1308_NSTG_DEEP_TISUE", NSTG_DEEP_TISUE)));
                } else if (ValidateUtils.isValidValue(NBR_PRSULC_STG2, new String[][]{ValidateUtils.ARRAY_DOUBLE_0}) && ValidateUtils.isValidValue(NBR_PRSULC_STG3, new String[][]{ValidateUtils.ARRAY_DOUBLE_0}) && ValidateUtils.isValidValue(NBR_PRSULC_STG4, new String[][]{ValidateUtils.ARRAY_DOUBLE_0}) && ValidateUtils.isValidValue(NSTG_CVRG, new String[][]{ValidateUtils.ARRAY_DOUBLE_0}) && ValidateUtils.isValidValue(NSTG_DRSG, new String[][]{ValidateUtils.ARRAY_DOUBLE_0}) && ValidateUtils.isValidValue(NSTG_DEEP_TISUE, new String[][]{ValidateUtils.ARRAY_DOUBLE_0})) {
                    ++count;
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5130, new HHOasisDataItem("M1308_NBR_PRSULC_STG2", NBR_PRSULC_STG2)));
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5130, new HHOasisDataItem("M1308_NBR_PRSULC_STG3", NBR_PRSULC_STG3)));
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5130, new HHOasisDataItem("M1308_NBR_PRSULC_STG4", NBR_PRSULC_STG4)));
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5130, new HHOasisDataItem("M1308_NSTG_CVRG", NSTG_CVRG)));
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5130, new HHOasisDataItem("M1308_NSTG_DRSG", NSTG_DRSG)));
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5130, new HHOasisDataItem("M1308_NSTG_DEEP_TISUE", NSTG_DEEP_TISUE)));
                }
            } else {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3060, new HHOasisDataItem("M1306_UNHLD_STG2_PRSR_ULCR", UNHLD_STG2_PRSR_ULCR)));
            }
            if (ValidateUtils.isValidValue(NBR_PRSULC_STG1, new String[][]{ValidateUtils.ARRAY_DOUBLE_0}) && (ValidateUtils.isValidValue(NBR_PRSULC_STG2, new String[][]{ValidateUtils.ARRAY_DOUBLE_0}) || ValidateUtils.isEmpty(NBR_PRSULC_STG2)) && (ValidateUtils.isValidValue(NBR_PRSULC_STG3, new String[][]{ValidateUtils.ARRAY_DOUBLE_0}) || ValidateUtils.isEmpty(NBR_PRSULC_STG3)) && (ValidateUtils.isValidValue(NBR_PRSULC_STG4, new String[][]{ValidateUtils.ARRAY_DOUBLE_0}) || ValidateUtils.isEmpty(NBR_PRSULC_STG4)) && !"NA".equals(STG_PRBLM_ULCER)) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4210, new HHOasisDataItem("M1322_NBR_PRSULC_STG1", NBR_PRSULC_STG1)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4210, new HHOasisDataItem("M1308_NBR_PRSULC_STG2", NBR_PRSULC_STG2)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4210, new HHOasisDataItem("M1308_NBR_PRSULC_STG3", NBR_PRSULC_STG3)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4210, new HHOasisDataItem("M1308_NBR_PRSULC_STG4", NBR_PRSULC_STG4)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4210, new HHOasisDataItem("M1324_STG_PRBLM_ULCER", STG_PRBLM_ULCER)));
            }
            int intStage2 = ValidateUtils.isEmpty(NBR_PRSULC_STG2) ? -1 : IntegerUtils.parseInt(NBR_PRSULC_STG2, -1);
            int intStage3 = ValidateUtils.isEmpty(NBR_PRSULC_STG3) ? -1 : IntegerUtils.parseInt(NBR_PRSULC_STG3, -1);
            int intStage4 = ValidateUtils.isEmpty(NBR_PRSULC_STG4) ? -1 : IntegerUtils.parseInt(NBR_PRSULC_STG4, -1);
            int intNonStageCovering = ValidateUtils.isEmpty(NSTG_CVRG) ? -1 : IntegerUtils.parseInt(NSTG_CVRG, -1);
            int n = intNonStageDeepTissue = ValidateUtils.isEmpty(NSTG_DEEP_TISUE) ? -1 : IntegerUtils.parseInt(NSTG_DEEP_TISUE, -1);
            if (intStage2 == 0 && intStage3 == 0 && intStage4 == 0 && intNonStageCovering == 0 && intNonStageDeepTissue == 0 && isRFA_1_3_9 && !"NA".equals(STUS_PRBLM_PRSR_ULCR)) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4130, new HHOasisDataItem("M1308_NBR_PRSULC_STG2", NBR_PRSULC_STG2)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4130, new HHOasisDataItem("M1308_NBR_PRSULC_STG3", NBR_PRSULC_STG3)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4130, new HHOasisDataItem("M1308_NBR_PRSULC_STG4", NBR_PRSULC_STG4)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4130, new HHOasisDataItem("M1308_NSTG_CVRG", NSTG_CVRG)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4130, new HHOasisDataItem("M1308_NSTG_DEEP_TISUE", NSTG_DEEP_TISUE)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4130, new HHOasisDataItem("M1320_STUS_PRBLM_PRSR_ULCR", STUS_PRBLM_PRSR_ULCR)));
            }
            if ((intStage2 > 0 || intNonStageDeepTissue > 0) && intStage3 == 0 && intStage4 == 0 && intNonStageCovering == 0 && isRFA_1_3_9 && !"03".equals(STUS_PRBLM_PRSR_ULCR)) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4140, new HHOasisDataItem("M1308_NBR_PRSULC_STG2", NBR_PRSULC_STG2)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4140, new HHOasisDataItem("M1308_NBR_PRSULC_STG3", NBR_PRSULC_STG3)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4140, new HHOasisDataItem("M1308_NBR_PRSULC_STG4", NBR_PRSULC_STG4)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4140, new HHOasisDataItem("M1308_NSTG_CVRG", NSTG_CVRG)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4140, new HHOasisDataItem("M1308_NSTG_DEEP_TISUE", NSTG_DEEP_TISUE)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4140, new HHOasisDataItem("M1320_STUS_PRBLM_PRSR_ULCR", STUS_PRBLM_PRSR_ULCR)));
            }
            if ((intStage3 > 0 || intStage4 > 0) && isRFA_1_3_9 && !ValidateUtils.isValidValue(STUS_PRBLM_PRSR_ULCR, ValidateUtils.ARRAY_DOUBLE_0, ValidateUtils.ARRAY_DOUBLE_1, ValidateUtils.ARRAY_DOUBLE_2, ValidateUtils.ARRAY_DOUBLE_3)) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4150, new HHOasisDataItem("M1308_NBR_PRSULC_STG3", NBR_PRSULC_STG3)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4150, new HHOasisDataItem("M1308_NBR_PRSULC_STG4", NBR_PRSULC_STG4)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4150, new HHOasisDataItem("M1320_STUS_PRBLM_PRSR_ULCR", STUS_PRBLM_PRSR_ULCR)));
            }
            if (intNonStageCovering > 0 && intStage2 == 0 && intStage3 == 0 && intStage4 == 0 && intNonStageDeepTissue == 0 && isRFA_1_3_9 && !ValidateUtils.isValidValue(STUS_PRBLM_PRSR_ULCR, new String[][]{ValidateUtils.ARRAY_DOUBLE_2}) && !ValidateUtils.isValidValue(STUS_PRBLM_PRSR_ULCR, new String[][]{ValidateUtils.ARRAY_DOUBLE_3})) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4160, new HHOasisDataItem("M1308_NBR_PRSULC_STG2", NBR_PRSULC_STG2)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4160, new HHOasisDataItem("M1308_NBR_PRSULC_STG3", NBR_PRSULC_STG3)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4160, new HHOasisDataItem("M1308_NBR_PRSULC_STG4", NBR_PRSULC_STG4)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4160, new HHOasisDataItem("M1308_NSTG_CVRG", NSTG_CVRG)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4160, new HHOasisDataItem("M1308_NSTG_DEEP_TISUE", NSTG_DEEP_TISUE)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4160, new HHOasisDataItem("M1320_STUS_PRBLM_PRSR_ULCR", STUS_PRBLM_PRSR_ULCR)));
            }
            if (ValidateUtils.isValidValue(NBR_PRSULC_STG1, ValidateUtils.ARRAY_DOUBLE_0, ValidateUtils.ARRAY_DOUBLE_1, ValidateUtils.ARRAY_DOUBLE_2, ValidateUtils.ARRAY_DOUBLE_3, ValidateUtils.ARRAY_DOUBLE_4)) {
                if ("01".equals(STG_PRBLM_ULCER) && !ValidateUtils.isValidValue(NBR_PRSULC_STG1, ValidateUtils.ARRAY_DOUBLE_1, ValidateUtils.ARRAY_DOUBLE_2, ValidateUtils.ARRAY_DOUBLE_3, ValidateUtils.ARRAY_DOUBLE_4)) {
                    ++count;
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4170, new HHOasisDataItem("M1322_NBR_PRSULC_STG1", NBR_PRSULC_STG1)));
                }
            } else {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3060, new HHOasisDataItem("M1322_NBR_PRSULC_STG1", NBR_PRSULC_STG1)));
            }
        }
        return count;
    }

    private boolean isValueInRange01To99(String value) {
        boolean valid = false;
        switch (value.length()) {
            case 2: {
                char char1 = value.charAt(0);
                char char2 = value.charAt(1);
                if (char1 == ' ') {
                    valid = Character.isDigit(char2);
                    break;
                }
                if (!Character.isDigit(char1)) break;
                valid = Character.isDigit(char2) || char2 == ' ';
                break;
            }
            case 1: {
                valid = Character.isDigit(value.charAt(0));
            }
        }
        return valid;
    }

    @Override
    public String getDescription() {
        return "Validates Pressure Ulcers for Stage 1 thru 4, and Non-staging pressure ulcers for edits: 3060, 4130, 4140,4150, 4160, 4170, 4210, 5110, 5120, 5130";
    }

    static {
        int idx;
        validNumberOf = new String[110];
        for (idx = 0; idx < 10; ++idx) {
            ValidatePressureUlcer_OASIS_C1.validNumberOf[idx] = "0" + idx;
            ValidatePressureUlcer_OASIS_C1.validNumberOf[idx + 10] = idx + " ";
        }
        for (idx = 20; idx < validNumberOf.length; ++idx) {
            ValidatePressureUlcer_OASIS_C1.validNumberOf[idx] = Integer.toString(idx);
        }
    }
}

