/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.vut.oasis;

import com.mmm.cms.homehealth.proto.RecordItemValidatorIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.vut.HHOasisDataItem;
import com.mmm.cms.homehealth.vut.OasisValidationEdit;
import com.mmm.cms.homehealth.vut.oasis.AbstractClinicalItemValidator;
import com.mmm.cms.homehealth.vut.oasis.AbstractItemValidator;
import com.mmm.cms.homehealth.vut.proto.CollectionValidationEditsIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditsEN;
import com.mmm.cms.util.IntegerUtils;
import com.mmm.cms.util.ValidateUtils;
import java.util.List;

public class ValidateStageMostProblematicPressureUlcer_OASIS_D
extends AbstractClinicalItemValidator
implements RecordItemValidatorIF {
    @Override
    public List<OasisEditIF> getEditIdsUsed() {
        return super.getEditIdsUsed_base(new OasisEditIF[]{OasisEditsEN.EDIT_3060, OasisEditsEN.EDIT_4170, OasisEditsEN.EDIT_4181, OasisEditsEN.EDIT_4191, OasisEditsEN.EDIT_4201});
    }

    @Override
    public int validate(HomeHealthRecordIF record, CollectionValidationEditsIF edits) {
        int count = 0;
        boolean isRFA_1_3_4_5_only = ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{AbstractItemValidator.ASSESSMENT_1_3_4_5_ONLY});
        boolean isRFA_1_3_4_5_9_only = ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{AbstractItemValidator.ASSESSMENT_1_3_4_5_9_ONLY});
        if (isRFA_1_3_4_5_9_only) {
            String tmpStr;
            String problemUlcer = record.getSTG_PRBLM_ULCER();
            if (ValidateUtils.isValidValue(problemUlcer, new String[][]{ValidateUtils.ARRAY_DOUBLE_1}) && (ValidateUtils.isValidValue(tmpStr = record.getNBR_PRSULC_STG1(), new String[][]{ValidateUtils.ARRAY_CARET_VALUES}) || IntegerUtils.parseInt(tmpStr, 0) <= 0) && isRFA_1_3_4_5_only) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4170, new HHOasisDataItem("M1322_NBR_PRSULC_STG1", tmpStr)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4170, new HHOasisDataItem("M1324_STG_PRBLM_ULCER", problemUlcer)));
            }
            if (ValidateUtils.isValidValue(problemUlcer, new String[][]{ValidateUtils.ARRAY_DOUBLE_2}) && (ValidateUtils.isValidValue(tmpStr = record.getNBR_PRSULC_STG2(), new String[][]{ValidateUtils.ARRAY_CARET_VALUES}) || IntegerUtils.parseInt(tmpStr, 0) <= 0)) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4181, new HHOasisDataItem("M1324_STG_PRBLM_ULCER", problemUlcer)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4181, new HHOasisDataItem("M1311_NBR_PRSULC_STG2_A1", tmpStr)));
            }
            if (ValidateUtils.isValidValue(problemUlcer, new String[][]{ValidateUtils.ARRAY_DOUBLE_3}) && (ValidateUtils.isValidValue(tmpStr = record.getNBR_PRSULC_STG3(), new String[][]{ValidateUtils.ARRAY_CARET_VALUES}) || IntegerUtils.parseInt(tmpStr, 0) <= 0)) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4191, new HHOasisDataItem("M1324_STG_PRBLM_ULCER", problemUlcer)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4191, new HHOasisDataItem("M1311_NBR_PRSULC_STG3_B1", tmpStr)));
            }
            if (ValidateUtils.isValidValue(problemUlcer, new String[][]{ValidateUtils.ARRAY_DOUBLE_4}) && (ValidateUtils.isValidValue(tmpStr = record.getNBR_PRSULC_STG4(), new String[][]{ValidateUtils.ARRAY_CARET_VALUES}) || IntegerUtils.parseInt(tmpStr, 0) <= 0)) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4201, new HHOasisDataItem("M1324_STG_PRBLM_ULCER", problemUlcer)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4201, new HHOasisDataItem("M1311_NBR_PRSULC_STG4_C1", tmpStr)));
            }
        }
        return count;
    }

    @Override
    public String getDescription() {
        return "Validates Stage Most Problematic Pressure Ulcer for edits: 3060, 4170, 4181, 4191, 4201\n";
    }
}

