/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.vut.oasis;

import com.mmm.cms.homehealth.proto.RecordItemValidatorIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.vut.HHOasisDataItem;
import com.mmm.cms.homehealth.vut.OasisValidationEdit;
import com.mmm.cms.homehealth.vut.oasis.AbstractClinicalItemValidator;
import com.mmm.cms.homehealth.vut.oasis.AbstractItemValidator;
import com.mmm.cms.homehealth.vut.proto.CollectionValidationEditsIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditsEN;
import com.mmm.cms.util.ValidateUtils;
import java.util.List;

public class ValidateTherapyAtHome
extends AbstractClinicalItemValidator
implements RecordItemValidatorIF {
    @Override
    public List<OasisEditIF> getEditIdsUsed() {
        return super.getEditIdsUsed_base(new OasisEditIF[]{OasisEditsEN.EDIT_3060, OasisEditsEN.EDIT_3880, OasisEditsEN.EDIT_3890});
    }

    @Override
    public int validate(HomeHealthRecordIF record, CollectionValidationEditsIF edits) {
        int count = 0;
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{AbstractItemValidator.ASSESSMENT_1_3_4_5_ONLY})) {
            if (!ValidateUtils.isValidValue(record.getTHH_IV_INFUSION(), new String[][]{ValidateUtils.ARRAY_ZERO_ONE})) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3060, new HHOasisDataItem("M1030_THH_IV_INFUSION", record.getTHH_IV_INFUSION())));
            }
            if (!ValidateUtils.isValidValue(record.getTHH_PAR_NUTRITION(), new String[][]{ValidateUtils.ARRAY_ZERO_ONE})) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3060, new HHOasisDataItem("M1030_THH_PAR_NUTRITION", record.getTHH_PAR_NUTRITION())));
            }
            if (!ValidateUtils.isValidValue(record.getTHH_ENT_NUTRITION(), new String[][]{ValidateUtils.ARRAY_ZERO_ONE})) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3060, new HHOasisDataItem("M1030_THH_ENT_NUTRITION", record.getTHH_ENT_NUTRITION())));
            }
            if (!ValidateUtils.isValidValue(record.getTHH_NONE_ABOVE(), new String[][]{ValidateUtils.ARRAY_ZERO_ONE})) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3060, new HHOasisDataItem("M1030_THH_NONE_ABOVE", record.getTHH_NONE_ABOVE())));
            }
            if ("1".equals(record.getTHH_NONE_ABOVE())) {
                if ("1".equals(record.getTHH_IV_INFUSION()) || "1".equals(record.getTHH_PAR_NUTRITION()) || "1".equals(record.getTHH_ENT_NUTRITION())) {
                    count += 4;
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3890, new HHOasisDataItem("M1030_THH_NONE_ABOVE", record.getTHH_NONE_ABOVE())));
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3890, new HHOasisDataItem("M1030_THH_IV_INFUSION", record.getTHH_IV_INFUSION())));
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3890, new HHOasisDataItem("M1030_THH_PAR_NUTRITION", record.getTHH_PAR_NUTRITION())));
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3890, new HHOasisDataItem("M1030_THH_ENT_NUTRITION", record.getTHH_ENT_NUTRITION())));
                }
            } else if ("0".equals(record.getTHH_NONE_ABOVE()) && "0".equals(record.getTHH_IV_INFUSION()) && "0".equals(record.getTHH_PAR_NUTRITION()) && "0".equals(record.getTHH_ENT_NUTRITION())) {
                count += 4;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3880, new HHOasisDataItem("M1030_THH_NONE_ABOVE", record.getTHH_NONE_ABOVE())));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3880, new HHOasisDataItem("M1030_THH_IV_INFUSION", record.getTHH_IV_INFUSION())));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3880, new HHOasisDataItem("M1030_THH_PAR_NUTRITION", record.getTHH_PAR_NUTRITION())));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3880, new HHOasisDataItem("M1030_THH_ENT_NUTRITION", record.getTHH_ENT_NUTRITION())));
            }
        }
        return count;
    }

    @Override
    public String getDescription() {
        return "Validates therapy at home, IV infusion, Par Nutrition and Enteral Nutrition for edits: 3060, 3880, 3890";
    }
}

