/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.vut.oasis;

import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.RecordItemValidatorIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.vut.HHOasisDataItem;
import com.mmm.cms.homehealth.vut.OasisValidationEdit;
import com.mmm.cms.homehealth.vut.oasis.AbstractClinicalItemValidator;
import com.mmm.cms.homehealth.vut.oasis.AbstractItemValidator;
import com.mmm.cms.homehealth.vut.proto.CollectionValidationEditsIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditsEN;
import com.mmm.cms.util.ValidateUtils;
import java.util.List;

public class ValidateUniqueDiagnosis
extends AbstractClinicalItemValidator
implements RecordItemValidatorIF {
    public ValidateUniqueDiagnosis() {
    }

    public ValidateUniqueDiagnosis(String otherPrefix) {
        super(otherPrefix);
    }

    @Override
    public List<OasisEditIF> getEditIdsUsed() {
        return super.getEditIdsUsed_base(new OasisEditIF[]{OasisEditsEN.EDIT_5000});
    }

    @Override
    public int validate(HomeHealthRecordIF record, CollectionValidationEditsIF edits) {
        int count = 0;
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{AbstractItemValidator.ASSESSMENT_1_3_4_5_ONLY})) {
            int idx = 0;
            block0: while (idx < 5 && count == 0) {
                DiagnosisCodeIF currentCode;
                if (!(currentCode = record.getDiagnosisCode(idx++)).isValidCode()) continue;
                int j = idx;
                while (j < 6) {
                    DiagnosisCodeIF otherCode;
                    if (!(otherCode = record.getDiagnosisCode(j++)).isValidCode() || !currentCode.equals(otherCode)) continue;
                    otherCode.setValidForScoring(false);
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5000, new HHOasisDataItem(this.getOtherPrefix() + j + "_ICD", otherCode.getCode())));
                    ++count;
                    continue block0;
                }
            }
        }
        return count;
    }

    @Override
    public String getDescription() {
        return "Validates Existing Codes for edits: 5000";
    }
}

