/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.vut.oasis;

import com.mmm.cms.homehealth.proto.RecordItemValidatorIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecord_C1_IF;
import com.mmm.cms.homehealth.vut.HHOasisDataItem;
import com.mmm.cms.homehealth.vut.OasisValidationEdit;
import com.mmm.cms.homehealth.vut.oasis.AbstractClinicalItemValidator;
import com.mmm.cms.homehealth.vut.oasis.AbstractItemValidator;
import com.mmm.cms.homehealth.vut.proto.CollectionValidationEditsIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditsEN;
import com.mmm.cms.util.ValidateUtils;
import java.util.List;

public class ValidateUrinaryIncontinence
extends AbstractClinicalItemValidator
implements RecordItemValidatorIF {
    @Override
    public List<OasisEditIF> getEditIdsUsed() {
        return super.getEditIdsUsed_base(new OasisEditIF[]{OasisEditsEN.EDIT_3060, OasisEditsEN.EDIT_4330, OasisEditsEN.EDIT_4340});
    }

    @Override
    public int validate(HomeHealthRecordIF record, CollectionValidationEditsIF edits) {
        int count = 0;
        String assessmentReason = record.getASSMT_REASON();
        if (ValidateUtils.isValidValue(assessmentReason, new String[][]{AbstractItemValidator.ASSESSMENT_1_3_4_5_9_ONLY})) {
            String urIncontTiming = ((HomeHealthRecord_C1_IF)record).getINCNTNT_TIMING();
            String urIncont = record.getUR_INCONT();
            if (!ValidateUtils.isValidValue(urIncont, ValidateUtils.ARRAY_DOUBLE_0, ValidateUtils.ARRAY_DOUBLE_1, ValidateUtils.ARRAY_DOUBLE_2)) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3060, new HHOasisDataItem("M1610_UR_INCONT", urIncont)));
            }
            if (ValidateUtils.isValidValue(assessmentReason, new String[][]{AbstractItemValidator.ASSESSMENT_1_3_9_ONLY})) {
                if (!ValidateUtils.isValidValue(urIncontTiming, ValidateUtils.ARRAY_DOUBLE_0, ValidateUtils.ARRAY_DOUBLE_1, ValidateUtils.ARRAY_DOUBLE_2, ValidateUtils.ARRAY_DOUBLE_3, ValidateUtils.ARRAY_DOUBLE_4, ValidateUtils.ARRAY_CARET_VALUES)) {
                    ++count;
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3060, new HHOasisDataItem("M1615_INCNTNT_TIMING", urIncontTiming)));
                }
                if (count == 0) {
                    if (ValidateUtils.isValidValue(urIncont, ValidateUtils.ARRAY_DOUBLE_0, ValidateUtils.ARRAY_DOUBLE_2) && !ValidateUtils.isValidValue(urIncontTiming, new String[][]{ValidateUtils.ARRAY_CARET_VALUES})) {
                        ++count;
                        edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4330, new HHOasisDataItem("M1615_INCNTNT_TIMING", urIncontTiming)));
                        edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4330, new HHOasisDataItem("M1610_UR_INCONT", urIncont)));
                    } else if (ValidateUtils.isValidValue(urIncont, new String[][]{ValidateUtils.ARRAY_DOUBLE_1}) && ValidateUtils.isValidValue(urIncontTiming, new String[][]{ValidateUtils.ARRAY_CARET_VALUES})) {
                        ++count;
                        edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4340, new HHOasisDataItem("M1615_INCNTNT_TIMING", urIncontTiming)));
                        edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4340, new HHOasisDataItem("M1610_UR_INCONT", urIncont)));
                    }
                }
            }
        }
        return count;
    }

    @Override
    public String getDescription() {
        return "Validates Urinary Incontinence for edits: 3060, 4330, 4340";
    }
}

