/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.vut.pps;

import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.RecordItemValidator_HH_PPS_IF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.vut.pps.ValidateExistingCodes;
import com.mmm.cms.homehealth.vut.pps.ValidateManifestationAsPrimaryDiagnosis;
import com.mmm.cms.homehealth.vut.pps.ValidateManifestationEtiologyPairs;
import com.mmm.cms.homehealth.vut.pps.ValidateManifestationEtiologyPairs_C2_220;
import com.mmm.cms.homehealth.vut.pps.ValidateOptionalPaymentCodes;
import com.mmm.cms.homehealth.vut.pps.ValidateOptionalPaymentManifestation;
import com.mmm.cms.homehealth.vut.pps.ValidatePrimaryDiagnosis;

public class HhPpsValidatorItems {
    private static HhPpsValidatorItems myInstance;
    public static final RecordItemValidator_HH_PPS_IF[] HHPPS_ITEMS_C_2_10;
    public static final RecordItemValidator_HH_PPS_IF[] HHPPS_ITEMS_C1_2_11;
    public static final RecordItemValidator_HH_PPS_IF[] HHPPS_ITEMS_C1_2_12;
    public static final RecordItemValidator_HH_PPS_IF[] HHPPS_ITEMS_C2_2_20;
    public static final RecordItemValidator_HH_PPS_IF[] HHPPS_ITEMS_D_2_30;

    private HhPpsValidatorItems() {
    }

    public static HhPpsValidatorItems getInstance() {
        if (myInstance == null) {
            myInstance = new HhPpsValidatorItems();
        }
        return myInstance;
    }

    public RecordItemValidator_HH_PPS_IF[] getValidationItems(HomeHealthGrouperIF grouper, HomeHealthRecordIF record) {
        switch (record.getRecordType()) {
            case OASIS_C: {
                return HHPPS_ITEMS_C_2_10;
            }
            case OASIS_C1_ICD_9: {
                return HHPPS_ITEMS_C1_2_11;
            }
            case OASIS_C1_ICD_10: {
                return HHPPS_ITEMS_C1_2_12;
            }
            case OASIS_C2: {
                return HHPPS_ITEMS_C2_2_20;
            }
            case OASIS_D: {
                return HHPPS_ITEMS_D_2_30;
            }
        }
        return null;
    }

    static {
        HHPPS_ITEMS_C_2_10 = new RecordItemValidator_HH_PPS_IF[]{new ValidateExistingCodes(), new ValidateOptionalPaymentCodes(), new ValidateManifestationAsPrimaryDiagnosis(), new ValidateOptionalPaymentManifestation(), new ValidatePrimaryDiagnosis(), new ValidateManifestationEtiologyPairs()};
        HHPPS_ITEMS_C1_2_11 = HHPPS_ITEMS_C_2_10;
        HHPPS_ITEMS_C1_2_12 = new RecordItemValidator_HH_PPS_IF[]{new ValidateExistingCodes("M1021_PRIMARY_DIAG_ICD", "M1023_OTH_DIAG", "M1025_OPT_DIAG_ICD_"), new ValidateManifestationAsPrimaryDiagnosis("M1021_PRIMARY_DIAG_ICD", "M1023_OTH_DIAG", "M1025_OPT_DIAG_ICD_"), new ValidatePrimaryDiagnosis("M1021_PRIMARY_DIAG_ICD", "M1023_OTH_DIAG", "M1025_OPT_DIAG_ICD_"), new ValidateManifestationEtiologyPairs("M1021_PRIMARY_DIAG_ICD", "M1023_OTH_DIAG", "M1025_OPT_DIAG_ICD_")};
        HHPPS_ITEMS_C2_2_20 = new RecordItemValidator_HH_PPS_IF[]{new ValidateExistingCodes("M1021_PRIMARY_DIAG_ICD", "M1023_OTH_DIAG", "M1025_OPT_DIAG_ICD_"), new ValidateManifestationAsPrimaryDiagnosis("M1021_PRIMARY_DIAG_ICD", "M1023_OTH_DIAG", "M1025_OPT_DIAG_ICD_"), new ValidatePrimaryDiagnosis("M1021_PRIMARY_DIAG_ICD", "M1023_OTH_DIAG", "M1025_OPT_DIAG_ICD_"), new ValidateManifestationEtiologyPairs_C2_220("M1021_PRIMARY_DIAG_ICD", "M1023_OTH_DIAG", "M1025_OPT_DIAG_ICD_")};
        HHPPS_ITEMS_D_2_30 = new RecordItemValidator_HH_PPS_IF[]{new ValidateExistingCodes("M1021_PRIMARY_DIAG_ICD", "M1023_OTH_DIAG", "M1025_OPT_DIAG_ICD_"), new ValidateManifestationAsPrimaryDiagnosis("M1021_PRIMARY_DIAG_ICD", "M1023_OTH_DIAG", "M1025_OPT_DIAG_ICD_"), new ValidatePrimaryDiagnosis("M1021_PRIMARY_DIAG_ICD", "M1023_OTH_DIAG", "M1025_OPT_DIAG_ICD_"), new ValidateManifestationEtiologyPairs_C2_220("M1021_PRIMARY_DIAG_ICD", "M1023_OTH_DIAG", "M1025_OPT_DIAG_ICD_")};
    }
}

