/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.vut.pps;

import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.RecordItemValidator_HH_PPS_IF;
import com.mmm.cms.homehealth.proto.edits.HH_PPS_OasisC1EditsEN;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.v3312.ManifestationUtils;
import com.mmm.cms.homehealth.vut.HHOasisDataItem;
import com.mmm.cms.homehealth.vut.OasisValidationEdit;
import com.mmm.cms.homehealth.vut.oasis.AbstractItemValidator;
import com.mmm.cms.homehealth.vut.pps.AbstractPPSManifestationItemValidator;
import com.mmm.cms.homehealth.vut.proto.CollectionValidationEditsIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditIF;
import com.mmm.cms.util.ValidateUtils;
import java.util.List;

public class ValidateManifestationEtiologyPairs
extends AbstractPPSManifestationItemValidator
implements RecordItemValidator_HH_PPS_IF {
    public ValidateManifestationEtiologyPairs() {
    }

    public ValidateManifestationEtiologyPairs(String primaryPrefix, String otherPrefix, String optPrefix) {
        super(primaryPrefix, otherPrefix, optPrefix);
    }

    @Override
    public List<OasisEditIF> getEditIdsUsed() {
        return super.getEditIdsUsed_base(HH_PPS_OasisC1EditsEN.EDIT_70030);
    }

    @Override
    public int validate(HomeHealthGrouperIF grouper, HomeHealthRecordIF record, CollectionValidationEditsIF edits) {
        int count = 0;
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{AbstractItemValidator.ASSESSMENT_1_3_4_5_ONLY})) {
            for (int idx = 1; idx < 6; ++idx) {
                DiagnosisCodeIF code = record.getDiagnosisCode(idx);
                if (!code.isSecondaryOnly() || code.getDiagnosticGroup().getId() <= 0) continue;
                boolean etiologyPairFound = ManifestationUtils.getPairedCode(grouper, record, code, idx) != null;
                code.setValidForScoring(etiologyPairFound);
                if (etiologyPairFound) continue;
                edits.add((Object)new OasisValidationEdit(HH_PPS_OasisC1EditsEN.EDIT_70030, new HHOasisDataItem(this.getOtherPrefix() + idx + "_ICD", code.getCode())));
                ++count;
            }
        }
        return count;
    }

    @Override
    public String getDescription() {
        return "Validates OptionalPaymentCodes for  edits: 70030";
    }
}

