/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.util;

import com.mmm.cms.util.HexavigesimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HexavigesimalCalendarFormat
extends Format {
    private static final HexavigesimalFormat hexavFormat = new HexavigesimalFormat();

    public static void main(String[] args) {
        int idx;
        String[][] converts = new String[366][2];
        HexavigesimalCalendarFormat format = new HexavigesimalCalendarFormat();
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(2012, 0, 1);
        System.out.print("Initial Date is: ");
        format.printlnCalendar(cal);
        System.out.println();
        for (idx = 0; idx < converts.length; ++idx) {
            String str;
            converts[idx][0] = str = format.format(cal);
            try {
                Calendar calendar = (Calendar)format.parseObject("12" + str);
                converts[idx][1] = calendar.get(2) + 1 + "/" + calendar.get(5) + "/" + calendar.get(1);
            }
            catch (ParseException ex) {
                Logger.getLogger(format.getClass().getName()).log(Level.SEVERE, "HH-PPS: ", ex);
                converts[idx][1] = "Could not convert back";
            }
            ((Calendar)cal).add(5, 1);
        }
        for (idx = 0; idx < converts.length; ++idx) {
            System.out.println(converts[idx][0] + " = " + converts[idx][1]);
        }
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj instanceof GregorianCalendar) {
            return this.format((GregorianCalendar)obj, toAppendTo, pos);
        }
        throw new IllegalArgumentException("HexavigesimalCalendarFormat - only formats GregorianCalendar objects");
    }

    @Override
    public Object parseObject(String string) throws ParseException {
        ParsePosition pos = new ParsePosition(0);
        return this.parseObject(string, pos);
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        int idx;
        GregorianCalendar calendar = null;
        if (source != null && (idx = pos.getIndex()) + 4 <= source.length()) {
            int year = 2000 + Integer.parseInt(source.substring(idx, idx + 2));
            int part1 = source.charAt(idx + 2) - 65;
            int part2 = source.charAt(idx + 3) - 65 + 1;
            int dayOfYear = 26 * part1 + part2;
            calendar = new GregorianCalendar();
            calendar.set(6, dayOfYear);
            calendar.set(1, year);
        }
        return calendar;
    }

    public StringBuffer format(GregorianCalendar calendar, StringBuffer toAppendTo, FieldPosition pos) {
        int yearDay = calendar.get(6);
        if (yearDay > 59 && !calendar.isLeapYear(calendar.get(1))) {
            ++yearDay;
        }
        return hexavFormat.format(yearDay + 26, toAppendTo, pos);
    }

    private void printCalendar(Calendar calendar) {
        SimpleDateFormat sdf = new SimpleDateFormat("d MMM yyyy hh:mm aaa");
        String date = sdf.format(calendar.getTime());
        System.out.print(date);
        System.out.print("(day " + calendar.get(6) + ")");
    }

    private void printlnCalendar(Calendar calendar) {
        this.printCalendar(calendar);
        System.out.println();
    }
}

