/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.util;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Currency;

public class IntegerFormat
extends NumberFormat {
    public static final IntegerFormat INTEGER_FORMAT_DIGITS_3;
    public static final IntegerFormat INTEGER_FORMAT_DIGITS_2;
    private char fillerChar;

    public IntegerFormat() {
        this.fillerChar = (char)32;
    }

    public IntegerFormat(char filler) {
        this.fillerChar = filler;
    }

    public char getFillerChar() {
        return this.fillerChar;
    }

    public void setFillerChar(char fillerChar) {
        this.fillerChar = fillerChar;
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        int maxDigits = this.getMaximumIntegerDigits();
        String str = Long.toString(number);
        int len = str.length();
        if (len == maxDigits) {
            toAppendTo.append(str);
        } else if (len > maxDigits) {
            toAppendTo.append(str.substring(len - maxDigits));
        } else if (len < maxDigits) {
            int fillCount = maxDigits - len;
            char[] fillChars = new char[fillCount];
            for (int idx = 0; idx < fillChars.length; ++idx) {
                fillChars[idx] = this.fillerChar;
            }
            toAppendTo.append(fillChars);
            toAppendTo.append(str);
        }
        return toAppendTo;
    }

    @Override
    public Number parse(String source, ParsePosition parsePosition) {
        return parsePosition == null ? Integer.parseInt(source) : Integer.parseInt(source.substring(parsePosition.getIndex()));
    }

    @Override
    public void setCurrency(Currency currency) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMaximumFractionDigits(int newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMinimumFractionDigits(int newValue) {
        throw new UnsupportedOperationException();
    }

    static {
        INTEGER_FORMAT_DIGITS_2 = new IntegerFormat('0');
        INTEGER_FORMAT_DIGITS_2.setMinimumIntegerDigits(2);
        INTEGER_FORMAT_DIGITS_2.setMaximumIntegerDigits(2);
        INTEGER_FORMAT_DIGITS_3 = new IntegerFormat('0');
        INTEGER_FORMAT_DIGITS_3.setMinimumIntegerDigits(3);
        INTEGER_FORMAT_DIGITS_3.setMaximumIntegerDigits(3);
    }
}

