/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.util;

import com.mmm.cms.homehealth.proto.HIPPSCodeIF;
import com.mmm.cms.homehealth.proto.ScoringResultsIF;
import com.mmm.cms.util.IntegerFormat;

public class ScoringResultsFormatter {
    protected static final IntegerFormat RECORD_NUMBER_FORMAT = new IntegerFormat('0');

    public static String formatContinousScore(ScoringResultsIF scoringResult) {
        String str;
        if (scoringResult == null) {
            str = "                             ";
        } else {
            StringBuilder buffer = new StringBuilder(30);
            String[] scoreParts = ScoringResultsFormatter.formatScoringParts(scoringResult);
            buffer.append(scoreParts[0]);
            buffer.append(scoreParts[1]);
            buffer.append(scoreParts[2]);
            buffer.append(scoreParts[3]);
            str = buffer.toString();
        }
        return str;
    }

    public static String formatTestingScore(ScoringResultsIF scoringResult, int recNum) {
        return ScoringResultsFormatter.formatTestingScore(scoringResult, recNum, false, false);
    }

    public static String formatTestingScore(ScoringResultsIF scoringResult, int recNum, boolean hideTAC, boolean hideVersion) {
        StringBuilder buffer = new StringBuilder(30);
        String[] scoreParts = ScoringResultsFormatter.formatScoringParts(scoringResult);
        buffer.append(ScoringResultsFormatter.formatRecordNumber(recNum, true));
        buffer.append(": Code ");
        buffer.append(scoreParts[0]);
        if (!hideTAC) {
            buffer.append("--OASIS ");
            buffer.append(scoreParts[1]);
        }
        if (!hideVersion) {
            buffer.append("--Version ");
            buffer.append(scoreParts[2]);
        }
        buffer.append(" --Flag ");
        buffer.append(scoreParts[3]);
        return buffer.toString();
    }

    public static String[] formatScoringParts(ScoringResultsIF scoringResult) {
        String[] scores = new String[4];
        if (scoringResult == null) {
            scores[0] = "     ";
            scores[1] = "                  ";
            scores[2] = "     ";
            scores[3] = " ";
        } else {
            scores[2] = scoringResult.getGrouperVersion();
            scores[3] = scores[2] == null || scores[2].trim().isEmpty() ? " " : (scoringResult.getValidityFlag() == null ? " " : scoringResult.getValidityFlag().getValidityFlag());
            HIPPSCodeIF hipps = scoringResult.getHIPPSCode();
            if (hipps != null && hipps.getGroupingStep() > 0) {
                scores[0] = hipps.getCode();
                scores[1] = scoringResult.getTreatmentAuthorization() != null ? scoringResult.getTreatmentAuthorization().getAuthorizationCode() : "                  ";
            } else {
                scores[0] = "     ";
                scores[1] = "                  ";
            }
        }
        return scores;
    }

    public static String formatRecordNumber(int recNum, boolean includeText) {
        return includeText ? "Rec " + RECORD_NUMBER_FORMAT.format(recNum) : RECORD_NUMBER_FORMAT.format(recNum);
    }

    static {
        RECORD_NUMBER_FORMAT.setMinimumIntegerDigits(9);
        RECORD_NUMBER_FORMAT.setMaximumIntegerDigits(9);
    }
}

