/*
 * Decompiled with CFR 0.152.
 */
package com.utilities.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;

public class NodeUtils {
    public static ArrayList<CheckBox> getAllCheckBoxes(Parent root) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList<CheckBox> checkBoxes = new ArrayList<CheckBox>();
        NodeUtils.addAllDescendents(root, nodes);
        for (Node n : nodes) {
            if (!(n instanceof CheckBox)) continue;
            checkBoxes.add((CheckBox)n);
        }
        return checkBoxes;
    }

    public static ArrayList<ComboBox> getAllComboBoxes(Parent root) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList<ComboBox> comboBoxes = new ArrayList<ComboBox>();
        NodeUtils.addAllDescendents(root, nodes);
        for (Node n : nodes) {
            if (!(n instanceof ComboBox)) continue;
            comboBoxes.add((ComboBox)n);
        }
        return comboBoxes;
    }

    public static void clearNodes(Parent root) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeUtils.addAllDescendents(root, nodes);
        for (Node n : nodes) {
            if (n instanceof ComboBox) {
                ((ComboBox)n).getSelectionModel().select(0);
            }
            if (n instanceof CheckBox) {
                ((CheckBox)n).setSelected(false);
            }
            if (n instanceof TextField) {
                ((TextField)n).setText("");
            }
            if (!(n instanceof TableView)) continue;
            ((TableView)n).getItems().clear();
        }
    }

    public static void disableDXNodes(Parent root, boolean isDisable) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeUtils.addAllDescendents(root, nodes);
        List<String> ignore = Arrays.asList("fromDate", "claimID", "clearButton", "detailedReportTab", "fromDatePicker", "grouperVersion", "removeDX", "rotTable", "none", "exportViewButton", "exportTableButton", "exportAllButton");
        for (Node n : nodes) {
            if (n.getId() == null || ignore.contains(n.getId()) || n instanceof TabPane) continue;
            n.setDisable(isDisable);
        }
    }

    private static void addAllDescendents(Parent root, ArrayList<Node> nodes) {
        List children = Collections.EMPTY_LIST;
        if (root instanceof ButtonBar) {
            children = ((ButtonBar)root).getButtons();
        } else if (root instanceof TitledPane) {
            NodeUtils.addAllDescendents((Parent)((TitledPane)root).getContent(), nodes);
        } else if (root instanceof TabPane) {
            for (Tab tab : ((TabPane)root).getTabs()) {
                Node tabContent = tab.getContent();
                if (!(tabContent instanceof Parent)) continue;
                NodeUtils.addAllDescendents((Parent)tab.getContent(), nodes);
            }
        } else {
            children = root.getChildrenUnmodifiable();
        }
        for (Node node : children) {
            nodes.add(node);
            if (!(node instanceof Parent)) continue;
            NodeUtils.addAllDescendents((Parent)node, nodes);
        }
    }
}

