/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.grouper;

import gov.cms.hh.data.files.TableNames_EN;
import gov.cms.hh.grouper.DataContainer;
import gov.cms.hh.grouper.DataContainerIF;
import gov.cms.hh.grouper.DataManagerIF;
import gov.cms.hh.reference.objects.ClinicalGroupObject;
import gov.cms.hh.reference.objects.ComorbidityGroupObject;
import gov.cms.hh.reference.objects.ComorbidityInteractionObject;
import gov.cms.hh.reference.objects.DiagnosisObject;
import gov.cms.hh.reference.objects.DiagnosisSubchapterObject;
import gov.cms.hh.reference.objects.HippsValueObject;
import gov.cms.hh.reference.objects.OasisRespondObject;
import gov.cms.hh.reference.objects.ReturnCodeObject;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataManager
implements DataManagerIF {
    private static final Logger LOG = Logger.getLogger(DataManager.class.getName());
    private Map<TableNames_EN, DataContainerIF> dataMap;

    public DataManager(String rtBasePath, boolean loadDescriptions) {
        this.loadData(rtBasePath, loadDescriptions);
    }

    public DataManager(String rtBasePath) {
        this.loadData(rtBasePath, false);
    }

    private void loadData(String rtBasePath, boolean loadDescriptions) {
        this.dataMap = new TreeMap<TableNames_EN, DataContainerIF>();
        String inpFile = rtBasePath + "/" + TableNames_EN.Diagnoses.getFileName();
        DataContainer diagnoses = new DataContainer(inpFile, 0, DiagnosisObject.class, loadDescriptions);
        this.dataMap.put(TableNames_EN.Diagnoses, diagnoses);
        inpFile = rtBasePath + "/" + TableNames_EN.Clinical_Groups.getFileName();
        DataContainer clinicalGroups = new DataContainer(inpFile, 0, ClinicalGroupObject.class, loadDescriptions);
        this.dataMap.put(TableNames_EN.Clinical_Groups, clinicalGroups);
        inpFile = rtBasePath + "/" + TableNames_EN.Comorbidity_Groups.getFileName();
        DataContainer comorbidityGroups = new DataContainer(inpFile, 0, ComorbidityGroupObject.class, loadDescriptions);
        this.dataMap.put(TableNames_EN.Comorbidity_Groups, comorbidityGroups);
        inpFile = rtBasePath + "/" + TableNames_EN.Comorbidity_Interactions.getFileName();
        DataContainer comorbidityInteractions = new DataContainer(inpFile, 0, ComorbidityInteractionObject.class, loadDescriptions);
        this.dataMap.put(TableNames_EN.Comorbidity_Interactions, comorbidityInteractions);
        inpFile = rtBasePath + "/" + TableNames_EN.Diagnosis_Subchapters.getFileName();
        DataContainer diagnosisSubchapters = new DataContainer(inpFile, 0, DiagnosisSubchapterObject.class, loadDescriptions);
        this.dataMap.put(TableNames_EN.Diagnosis_Subchapters, diagnosisSubchapters);
        inpFile = rtBasePath + "/" + TableNames_EN.HIPPS_Structure.getFileName();
        DataContainer hippsValues = new DataContainer(inpFile, HippsValueObject.class, loadDescriptions);
        this.dataMap.put(TableNames_EN.HIPPS_Structure, hippsValues);
        inpFile = rtBasePath + "/" + TableNames_EN.OASIS_Responses.getFileName();
        DataContainer oasisResponces = new DataContainer(inpFile, OasisRespondObject.class, loadDescriptions);
        this.dataMap.put(TableNames_EN.OASIS_Responses, oasisResponces);
        inpFile = rtBasePath + "/" + TableNames_EN.Return_Codes.getFileName();
        DataContainer returnCodes = new DataContainer(inpFile, 0, ReturnCodeObject.class, loadDescriptions);
        this.dataMap.put(TableNames_EN.Return_Codes, returnCodes);
        LOG.log(Level.INFO, "Grouper Data Manager instantiated: RT path: {0}, Descriptions loaded: {1}", new Object[]{rtBasePath, loadDescriptions});
    }

    @Override
    public Map<TableNames_EN, DataContainerIF> getDataMap() {
        return this.dataMap;
    }

    @Override
    public void setDataMap(Map<TableNames_EN, DataContainerIF> dataMap) {
        this.dataMap = dataMap;
    }
}

