/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.logic.specification.abstr;

/**
 *
 * @author CMS
 * @param <T>
 */
public abstract class AbstractSpecification<T> implements Specification<T> {

    /**
     *
     * @param t
     * @return
     */
    @Override
    public abstract boolean isSatisfiedBy(T t);

    /**
     *
     * @param s
     * @return
     */
    public AbstractSpecification<T> or(Specification<T> s) {
        return new OrSpecification<>(this, s);
    }

    /**
     *
     * @param s
     * @return
     */
    public AbstractSpecification<T> and(Specification<T> s) {
        return new AndSpecification<>(this, s);
    }

    /**
     *
     * @return
     */
    public AbstractSpecification<T> not() {
        return new NotSpecification<>(this);
    }

}
