/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.logic.validation;

import gov.cms.hh.data.meta.enumer.EditId_EN;
import java.util.List;

/**
 *
 * @author CMS
 */
public interface EditCollectionIF {

    /**
     *
     * @return
     */
    List<EditIF> getCriticalEdits();

    /**
     *
     * @param editId
     * @return
     */
    List<EditIF> getEditId(EditId_EN editId);

    /**
     *
     * @return
     */
    boolean hasCriticalEdits();

    /**
     *
     * @param editId
     * @return
     */
    boolean hasEditId(EditId_EN editId);

    /**
     *
     * @param edit
     */
    void addEdit(EditIF edit);

    /**
     *
     * @param editList
     */
    void addEdits(List<EditIF> editList);

    /**
     *
     * @return
     */
    List<EditIF> getEdits();
}
