/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.grouper;

import gov.cms.hh.claim.ClaimAdapter;
import gov.cms.hh.claim.ClaimIF;
import gov.cms.hh.claim.HippsCode;
import gov.cms.hh.claim.ReturnCode;
import gov.cms.hh.data.exchange.ClaimContainer;
import gov.cms.hh.data.exchange.ClaimContainerIF;
import gov.cms.hh.data.exchange.HippsContainer;
import gov.cms.hh.data.exchange.ReturnCodeContainer;
import gov.cms.hh.data.exchange.ValidityFlagContainer;
import gov.cms.hh.data.files.TableNames_EN;
import gov.cms.hh.data.interf.PositionAccessorIF;
import gov.cms.hh.data.meta.enumer.ActionFlag_EN;
import gov.cms.hh.grouper.ClaimManager;
import gov.cms.hh.grouper.ClaimManagerIF;
import gov.cms.hh.grouper.DataContainerIF;
import gov.cms.hh.grouper.DataManager;
import gov.cms.hh.grouper.DataManagerIF;
import gov.cms.hh.grouper.GrouperIF;
import gov.cms.hh.logic.processor.HippsProcessor;
import gov.cms.hh.logic.validation.EditIF;
import gov.cms.hh.reference.objects.ClaimObject;
import gov.cms.hh.reference.objects.GrouperVersionObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractGrouper
implements GrouperIF {
    private static final Logger LOG = Logger.getLogger(AbstractGrouper.class.getName());
    DataManagerIF dataManager;
    ClaimManagerIF claimManager;
    private int id;
    private String name;
    private String description;
    private boolean active;
    private Date startDate;
    private Date endDate;
    private boolean defaultFlag;

    @Override
    public List<Integer> getClaimLayout() {
        return this.claimManager.getClaimLayout();
    }

    @Override
    public List<Integer> getClaimLayoutInputOnly() {
        return this.claimManager.getClaimLayoutInputOnly();
    }

    @Override
    public Date getStartDate() {
        return new Date(this.startDate.getTime());
    }

    public void setStartDate(Date startDate) {
        this.startDate = new Date(startDate.getTime());
    }

    @Override
    public Date getEndDate() {
        return new Date(this.endDate.getTime());
    }

    public void setEndDate(Date endDate) {
        this.endDate = new Date(endDate.getTime());
    }

    public AbstractGrouper(int id, String name, String description, String startDate, String endDate, boolean active, boolean defaultt) throws ParseException {
        this.id = id;
        this.name = name;
        this.description = description;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        this.startDate = sdf.parse(startDate);
        this.endDate = sdf.parse(endDate);
        this.active = active;
        this.defaultFlag = defaultt;
        this.dataManager = new DataManager(this.buildRtBasePath(), true);
        this.claimManager = new ClaimManager(this.buildClaimLayoutPath());
        LOG.log(Level.INFO, "Grouper version {0} instantiated", this.name);
    }

    private String buildRtBasePath() {
        String retPath = "Versions/" + this.name.replaceAll("\\.", "") + "/RT";
        return retPath;
    }

    private String buildClaimLayoutPath() {
        String retPath = "Versions/" + this.name.replaceAll("\\.", "");
        return retPath;
    }

    public AbstractGrouper(Integer id, GrouperVersionObject grouperVersionObject) throws ParseException {
        this(id, grouperVersionObject.getId(), grouperVersionObject.getDescription(), grouperVersionObject.getStartDate(), grouperVersionObject.getEndDate(), Integer.parseInt(grouperVersionObject.getActiveFlag()) > 0, Integer.parseInt(grouperVersionObject.getDefaultFlag()) > 0);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isDefault() {
        return this.defaultFlag;
    }

    public void setDefault(boolean defaultFlag) {
        this.defaultFlag = defaultFlag;
    }

    @Override
    public ClaimContainerIF getEmptyClaim() {
        return new ClaimContainer();
    }

    @Override
    public void group(ClaimContainerIF claimInput) {
        ClaimIF claim = new ClaimAdapter().convert(claimInput);
        this.group(claim);
        claimInput.setVersionUsed(claim.getGrouperVersion());
        claimInput.setHippsCode(claim.getHippsCode().getFinalHippsCode());
        HippsContainer hipps = new HippsContainer();
        if (claim.getHippsCode().isHippsComplete()) {
            for (int i = 1; i < hipps.getPositionsCount() + 1; ++i) {
                String value = claim.getHippsCode().getValue(i).getValue();
                String posDesc = claim.getHippsCode().getValue(i).getPositionDescription();
                String valDesc = claim.getHippsCode().getValue(i).getValueDescription();
                hipps.setPositionValue(i, value);
                hipps.setPositionDescription(i, posDesc + ": " + valDesc);
            }
        }
        claimInput.setHippsContainer(hipps);
        claimInput.setValidityFlag(new ValidityFlagContainer(claim.getSingleValidityFlag().getValue(), claim.getSingleValidityFlag().getDescription()));
        claimInput.setReturnCode(new ReturnCodeContainer(String.format("%02d", claim.getSingleReturnCode().getId()), claim.getSingleReturnCode().getDescription()));
        claimInput.setEdits(claim.getClaimEdits());
    }

    protected void group(ClaimIF claim) {
        int GRC_INTERNAL_ERROR = 50;
        if (claim == null) {
            return;
        }
        try {
            this.processClaim(claim, this.dataManager);
            claim.setGrouperVersion(this.getVersion());
        }
        catch (Exception e) {
            claim.getReturnCodes().getCollection().clear();
            claim.getReturnCodes().getCollection().add(new ReturnCode(50, "Grouper Internal Error"));
            claim.setHippsCode(new HippsCode());
            claim.setGrouperVersion(this.getVersion());
            LOG.info("*** SEVERE: Grouper Internal Error with processing claim ***");
            for (EditIF edit : claim.getClaimEdits().getEdits()) {
                LOG.info(edit.toString());
            }
        }
    }

    protected void processClaim(ClaimIF claim, DataManagerIF dataManager) {
        HippsProcessor hp = new HippsProcessor();
        hp.process(claim, dataManager);
    }

    @Override
    public String group(String claimInput) {
        ClaimObject claimIn = this.claimManager.loadClaim(claimInput);
        ClaimAdapter ca = new ClaimAdapter();
        ClaimIF claim = ca.convert(claimIn);
        this.group(claim);
        String retStr = this.formatResult(claim);
        claimIn.setVersionUsed(claim.getGrouperVersion());
        claimIn.setHippsCode(claim.getHippsCode().getHippsCode());
        claimIn.setByPosition(55, claim.getSingleValidityFlag().getValue());
        claimIn.setByPosition(56, String.format("%02d", claim.getSingleReturnCode().getId()));
        if (claimIn.getOptions().getActionFlag().equalsIgnoreCase(ActionFlag_EN.Y.name())) {
            LOG.info("*** Grouping Detail Report ***");
            LOG.info(claimIn.toString());
            LOG.log(Level.INFO, "*** Output string = {0}", retStr);
            claim.getClaimEdits().getEdits().forEach(edit -> LOG.info(edit.toString()));
        }
        return retStr;
    }

    protected String formatResult(ClaimIF claim) {
        String retStr = this.getVersion() + claim.getHippsCode().getFinalHippsCode() + claim.getSingleValidityFlag().getValue() + String.format("%02d", claim.getSingleReturnCode().getId());
        return retStr;
    }

    @Override
    public String getVersion() {
        return this.getName();
    }

    @Override
    public DataContainerIF<PositionAccessorIF> getAvailableTableContent(TableNames_EN tableType) {
        return this.dataManager.getDataMap().get(tableType);
    }
}

