/*
 * Decompiled with CFR 0.152.
 */
package com.utilities;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public class Xml2Txt {
    private final File tmp = new File("tmp/");
    private final File outputFile = new File("./tmp/output.txt");
    private final File xmlOutput = new File(this.tmp.getAbsolutePath() + "/data.xml");
    private final File xslLayout = new File(this.tmp.getAbsolutePath() + "/style.xsl");

    File convert() throws Exception {
        if (!this.tmp.exists()) {
            this.tmp.mkdir();
        }
        if (!this.outputFile.exists()) {
            this.outputFile.createNewFile();
        }
        File xmlOutput = new File(this.xmlOutput.getAbsolutePath());
        File xslLayout = new File(this.xslLayout.getAbsolutePath());
        InputStream in = this.getClass().getResourceAsStream("/" + xslLayout.getName());
        this.convertToFile(in, xslLayout);
        in = this.getClass().getResourceAsStream("/" + xmlOutput.getName());
        this.convertToFile(in, xmlOutput);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(xmlOutput);
        StreamSource styleSource = new StreamSource(xslLayout);
        Transformer transformer = TransformerFactory.newInstance().newTransformer(styleSource);
        DOMSource source = new DOMSource(document);
        StreamResult outputTarget = new StreamResult(this.outputFile);
        transformer.transform(source, outputTarget);
        return this.outputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertToFile(InputStream inputStream, File outputFile) {
        FileOutputStream outputStream = null;
        try {
            int read;
            outputStream = new FileOutputStream(outputFile);
            byte[] bytes = new byte[1024];
            while ((read = inputStream.read(bytes)) != -1) {
                ((OutputStream)outputStream).write(bytes, 0, read);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outputStream != null) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    void cleanUp() {
        this.outputFile.delete();
        this.xslLayout.delete();
        this.xmlOutput.delete();
        this.tmp.delete();
    }
}

