/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.diagnosis;

import gov.cms.hh.claim.ClaimElementBase;
import gov.cms.hh.diagnosis.ClinicalGroup;
import gov.cms.hh.diagnosis.ComorbidityGroup;
import gov.cms.hh.diagnosis.DiagnosisIF;
import gov.cms.hh.diagnosis.DiagnosisSubchapter;
import gov.cms.hh.reference.objects.DiagnosisObject;

public class Diagnosis
extends ClaimElementBase
implements DiagnosisIF {
    private static final long serialVersionUID = 1L;
    private int id;
    private String value;
    private String description;
    private boolean manifestation;
    private boolean primaryAwarding;
    private boolean ECOI;
    private boolean codeFirst;
    private boolean unacceptablePdx;
    private ClinicalGroup clinicalGroup;
    private ComorbidityGroup comorbidityGroup;
    private DiagnosisSubchapter diagnosisSubchapter;

    @Override
    public boolean isCodeFirst() {
        return this.codeFirst;
    }

    @Override
    public void setCodeFirst(boolean codeFirst) {
        this.codeFirst = codeFirst;
    }

    @Override
    public boolean isUnacceptablePdx() {
        return this.unacceptablePdx;
    }

    @Override
    public void setUnacceptablePdx(boolean unacceptablePdx) {
        this.unacceptablePdx = unacceptablePdx;
    }

    public String toString() {
        return "Diagnosis{id=" + this.id + ", value=" + this.value + ", description=" + this.description + ", manifestation=" + this.manifestation + ", primaryAwarding=" + this.primaryAwarding + ", ECOI=" + this.ECOI + ", codeFirst=" + this.codeFirst + ", unacceptablePdx=" + this.unacceptablePdx + ", clinicalGroup=" + this.clinicalGroup + ", comorbidityGroup=" + this.comorbidityGroup + ", diagnosisSubchapter=" + this.diagnosisSubchapter + '}';
    }

    public Diagnosis() {
    }

    public Diagnosis(int id, String value, String description, boolean manifestation, boolean primaryAwarding, boolean ECOI, boolean codeFirst, boolean unacceptablePdx, ClinicalGroup clinicalGroup, ComorbidityGroup comorbidityGroup, DiagnosisSubchapter diagnosisSubchapter) {
        this.id = id;
        this.value = value;
        this.description = description;
        this.manifestation = manifestation;
        this.primaryAwarding = primaryAwarding;
        this.ECOI = ECOI;
        this.codeFirst = codeFirst;
        this.unacceptablePdx = unacceptablePdx;
        this.clinicalGroup = clinicalGroup;
        this.comorbidityGroup = comorbidityGroup;
        this.diagnosisSubchapter = diagnosisSubchapter;
    }

    public Diagnosis(int id, DiagnosisObject diagObj, ClinicalGroup clinicalGroup, ComorbidityGroup comorbidityGroup, DiagnosisSubchapter diagnosisSubchapter) {
        this(id, diagObj.getValue(), diagObj.getDescription(), Integer.parseInt(diagObj.getManifestationFlag()) > 0, Integer.parseInt(diagObj.getPrimaryAwardingFlag()) > 0, Integer.parseInt(diagObj.getEcoiFlag()) > 0, Integer.parseInt(diagObj.getCodeFirstFlag()) > 0, Integer.parseInt(diagObj.getUnacceptablePdxFlag()) > 0, clinicalGroup, comorbidityGroup, diagnosisSubchapter);
    }

    @Override
    public ClinicalGroup getClinicalGroup() {
        return this.clinicalGroup;
    }

    @Override
    public void setClinicalGroup(ClinicalGroup clinicalGroup) {
        this.clinicalGroup = clinicalGroup;
    }

    @Override
    public ComorbidityGroup getComorbidityGroup() {
        return this.comorbidityGroup;
    }

    @Override
    public void setComorbidityGroup(ComorbidityGroup comorbidityGroup) {
        this.comorbidityGroup = comorbidityGroup;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isManifestation() {
        return this.manifestation;
    }

    @Override
    public void setManifestation(boolean manifestation) {
        this.manifestation = manifestation;
    }

    @Override
    public boolean isPrimaryAwarding() {
        return this.primaryAwarding;
    }

    @Override
    public void setPrimaryAwarding(boolean primaryAwarding) {
        this.primaryAwarding = primaryAwarding;
    }

    @Override
    public boolean isECOI() {
        return this.ECOI;
    }

    @Override
    public void setECOI(boolean ECOI) {
        this.ECOI = ECOI;
    }

    @Override
    public DiagnosisSubchapter getDiagnosisSubchapter() {
        return this.diagnosisSubchapter;
    }

    @Override
    public void setDiagnosisSubchapter(DiagnosisSubchapter diagnosisSubchapter) {
        this.diagnosisSubchapter = diagnosisSubchapter;
    }
}

