/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.grouper;

import gov.cms.hh.data.interf.PositionAccessorIF;
import gov.cms.hh.data.loader.DataLoader;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

/**
 *
 * @author CMS
 * @param <T>
 */
public final class DataContainer<T> implements DataContainerIF<T> {

    /**
     *
     * @param inpFile
     * @param clazz
     */
    public DataContainer(String inpFile, Class clazz) {
        this(inpFile, clazz, false);
    }
    
    /**
     *
     * @param inpFile
     * @param clazz
     * @param loadDescriptions
     */
    public DataContainer(String inpFile, Class clazz, boolean loadDescriptions) {
        addAllWithId(readData(inpFile, clazz, loadDescriptions));
    }

    /**
     *
     * @param inpFile
     * @param colNum
     * @param clazz
     */
    public DataContainer(String inpFile, int colNum, Class clazz) {
        this(inpFile, colNum, clazz, false);
    }
    
    /**
     *
     * @param inpFile
     * @param colNum
     * @param clazz
     * @param loadDescriptions
     */
    public DataContainer(String inpFile, int colNum, Class clazz, boolean loadDescriptions) {
        addAll(colNum, readData(inpFile, clazz, loadDescriptions));
    }

    private List<T> readData(String inpFile, Class clazz, boolean loadDescriptions) {
        InputStream inStr = this.getClass().getClassLoader().getResourceAsStream(inpFile);
        DataLoader<T> loader = new DataLoader(clazz, loadDescriptions);
        return loader.loadFile(inStr, true);
    }
    
    /**
     * @return the dataMap
     */
    @Override
    public Map<String, T> getDataMap() {
        return dataMap;
    }

    /**
     * @param dataMap the dataMap to set
     */
    @Override
    public void setDataMap(Map<String, T> dataMap) {
        this.dataMap = dataMap;
    }

    /**
     * @return the columnNames
     */
    @Override
    public T getColumnNames() {
        return columnNames;
    }

    /**
     * @param columnNames the columnNames to set
     */
    @Override
    public void setColumnNames(T columnNames) {
        this.columnNames = columnNames;
    }
    private Map<String, T> dataMap;
    private T columnNames;

    /**
     *
     * @param key
     * @param data
     */
    @Override
    public void add(String key, T data) {
        if (dataMap == null) {
            dataMap = new TreeMap<>();
        }
        dataMap.put(key, data);
    }

    /**
     *
     * @param keyPosition
     * @param data
     */
    @Override
    public void addAll(int keyPosition, List<T> data) {
        if (data == null) {
            return;
        }
        if (dataMap == null) {
            dataMap = new TreeMap<>();
            if (data.size() > 0) {
                setColumnNames(data.get(0));
                for (int i = 1; i < data.size(); i++) {
                    dataMap.put(((PositionAccessorIF) data.get(i)).getByPosition(keyPosition), data.get(i));
                }
            }
        } else {
            data.forEach((t) -> {
                dataMap.put(((PositionAccessorIF) t).getByPosition(keyPosition), t);
            });
        }
    }

    /**
     *
     * @return
     */
    @Override
    public List<T> getData() {
        return dataMap.values().stream().collect(Collectors.toList());
    }

    /**
     *
     * @param keyPosition
     * @param data
     */
    @Override
    public void replaceAll(int keyPosition, List<T> data) {
        dataMap = null;
        addAll(keyPosition, data);
    }

    /**
     *
     * @param data
     */
    @Override
    public void addAllWithId(List<T> data) {
        if (data == null) {
            return;
        }
        if (dataMap == null) {
            dataMap = new TreeMap<>();
            if (data.size() > 0) {
                setColumnNames(data.get(0));
                for (int i = 1; i < data.size(); i++) {
                    dataMap.put("" + i, data.get(i));
                }
            }
        } else {
            data.forEach((t) -> {
                dataMap.put("" + dataMap.values().size(), t);
            });
        }
    }

    /**
     *
     * @param data
     */
    @Override
    public void replaceAllWithId(List<T> data) {
        dataMap = null;
        addAllWithId(data);
    }
}
