/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.grouper;

import gov.cms.hh.data.files.TableNames_EN;
import gov.cms.hh.grouper.DataContainer;
import gov.cms.hh.grouper.DataContainerIF;
import gov.cms.hh.grouper.DataManagerIF;
import gov.cms.hh.reference.objects.ClinicalGroupObject;
import gov.cms.hh.reference.objects.CodeFirstConditionObject;
import gov.cms.hh.reference.objects.ComorbidityGroupObject;
import gov.cms.hh.reference.objects.ComorbidityInteractionObject;
import gov.cms.hh.reference.objects.DiagnosisObject;
import gov.cms.hh.reference.objects.DiagnosisSubchapterObject;
import gov.cms.hh.reference.objects.HippsValueObject;
import gov.cms.hh.reference.objects.OasisRespondObject;
import gov.cms.hh.reference.objects.ReturnCodeObject;
import gov.cms.hh.reference.objects.ValidityFlagObject;
import java.io.InputStream;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

public class DataManager
implements DataManagerIF {
    private static final Logger LOG = Logger.getLogger(DataManager.class.getName());
    private final Object lock = new Object();
    private Map<TableNames_EN, DataContainerIF> dataMap;
    private String rtBasePath;
    private boolean loadDescriptions;

    public DataManager(String rtBasePath, boolean loadDescriptions) {
        this.rtBasePath = rtBasePath;
        this.loadDescriptions = loadDescriptions;
    }

    public DataManager(String rtBasePath) {
        this(rtBasePath, false);
    }

    private void loadRotData() {
        this.dataMap = new TreeMap<TableNames_EN, DataContainerIF>();
        String inpFile = this.getRtBasePath() + "/" + TableNames_EN.Diagnoses.getFileName();
        DataContainer diagnoses = new DataContainer(inpFile, 0, DiagnosisObject.class, this.isLoadDescriptions());
        this.dataMap.put(TableNames_EN.Diagnoses, diagnoses);
        inpFile = this.getRtBasePath() + "/" + TableNames_EN.Clinical_Groups.getFileName();
        DataContainer clinicalGroups = new DataContainer(inpFile, 0, ClinicalGroupObject.class, this.isLoadDescriptions());
        this.dataMap.put(TableNames_EN.Clinical_Groups, clinicalGroups);
        inpFile = this.getRtBasePath() + "/" + TableNames_EN.Comorbidity_Groups.getFileName();
        DataContainer comorbidityGroups = new DataContainer(inpFile, 0, ComorbidityGroupObject.class, this.isLoadDescriptions());
        this.dataMap.put(TableNames_EN.Comorbidity_Groups, comorbidityGroups);
        inpFile = this.getRtBasePath() + "/" + TableNames_EN.Comorbidity_Interactions.getFileName();
        DataContainer comorbidityInteractions = new DataContainer(inpFile, 0, ComorbidityInteractionObject.class, this.isLoadDescriptions());
        this.dataMap.put(TableNames_EN.Comorbidity_Interactions, comorbidityInteractions);
        inpFile = this.getRtBasePath() + "/" + TableNames_EN.Diagnosis_Subchapters.getFileName();
        DataContainer diagnosisSubchapters = new DataContainer(inpFile, 0, DiagnosisSubchapterObject.class, this.isLoadDescriptions());
        this.dataMap.put(TableNames_EN.Diagnosis_Subchapters, diagnosisSubchapters);
        inpFile = this.getRtBasePath() + "/" + TableNames_EN.HIPPS_Structure.getFileName();
        DataContainer hippsValues = new DataContainer(inpFile, HippsValueObject.class, true);
        this.dataMap.put(TableNames_EN.HIPPS_Structure, hippsValues);
        inpFile = this.getRtBasePath() + "/" + TableNames_EN.OASIS_Responses.getFileName();
        DataContainer oasisResponces = new DataContainer(inpFile, OasisRespondObject.class, this.isLoadDescriptions());
        this.dataMap.put(TableNames_EN.OASIS_Responses, oasisResponces);
        inpFile = this.getRtBasePath() + "/" + TableNames_EN.Return_Codes.getFileName();
        DataContainer returnCodes = new DataContainer(inpFile, 0, ReturnCodeObject.class, true);
        this.dataMap.put(TableNames_EN.Return_Codes, returnCodes);
        inpFile = this.getRtBasePath() + "/" + TableNames_EN.Validity_Flags.getFileName();
        InputStream inStr = this.getClass().getClassLoader().getResourceAsStream(inpFile);
        if (inStr != null) {
            DataContainer validityFlags = new DataContainer(inpFile, 0, ValidityFlagObject.class, true);
            this.dataMap.put(TableNames_EN.Validity_Flags, validityFlags);
        }
        inpFile = this.getRtBasePath() + "/" + TableNames_EN.CodeFirst_Conditions.getFileName();
        inStr = this.getClass().getClassLoader().getResourceAsStream(inpFile);
        if (inStr != null) {
            DataContainer codeFirstConditions = new DataContainer(inpFile, 0, CodeFirstConditionObject.class, this.isLoadDescriptions());
            this.dataMap.put(TableNames_EN.CodeFirst_Conditions, codeFirstConditions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<TableNames_EN, DataContainerIF> getDataMap() {
        Object object = this.lock;
        synchronized (object) {
            if (this.dataMap == null || this.dataMap.isEmpty()) {
                this.loadRotData();
            }
        }
        return this.dataMap;
    }

    @Override
    public void setDataMap(Map<TableNames_EN, DataContainerIF> dataMap) {
        this.dataMap = dataMap;
    }

    @Override
    public boolean isLoadDescriptions() {
        return this.loadDescriptions;
    }

    public void setLoadDescriptions(boolean loadDescriptions) {
        this.loadDescriptions = loadDescriptions;
    }

    public String getRtBasePath() {
        return this.rtBasePath;
    }

    public void setRtBasePath(String rtBasePath) {
        this.rtBasePath = rtBasePath;
    }
}

