/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.logic.specification;

import gov.cms.hh.grouper.GrouperIF;
import gov.cms.hh.logic.specification.abstr.AbstractClaimDateValidator;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;

public class IsSpanClaim
extends AbstractClaimDateValidator {
    public IsSpanClaim(String date) {
        super(date);
    }

    @Override
    public boolean isSatisfiedBy(GrouperIF gv) {
        return this.isDaysInRange(gv.getEndDate());
    }

    protected boolean isDaysInRange(Date end) {
        LocalDate endDate;
        if (this.getDate() == null) {
            return false;
        }
        LocalDate startDate = this.getDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        long days = ChronoUnit.DAYS.between(startDate, endDate = end.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
        return days < 29L;
    }
}

