/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.data.exchange;

import gov.cms.hh.logic.validation.EditCollectionIF;
import java.util.List;
import java.util.Map;

/**
 *
 * @author CMS
 */
public interface ClaimContainerIF {

    /**
     *
     * @param sdx
     * @param poa
     */
    void addSdx(String sdx, String poa);

    /**
     * @return the ambulation
     */
    String getAmbulation();

    /**
     * @return the bathing
     */
    String getBathing();

    /**
     * @return the claimId
     */
    String getClaimId();

    /**
     * @return the dressLower
     */
    String getDressLower();

    /**
     * @return the dressUpper
     */
    String getDressUpper();

    /**
     * @return the fromDate
     */
    String getFromDate();

    /**
     * @return the throughDate
     */
    String getThroughDate();

    /**
     * @return the grooming
     */
    String getGrooming();

    /**
     * @return the HippsCode
     */
    String getHippsCode();

    /**
     * @return the hospRiskCompliance
     */
    String getHospRiskCompliance();

    /**
     * @return the hospRiskFiveMoreMeds
     */
    String getHospRiskFiveMoreMeds();

    /**
     * @return the hospRiskHistoryFalls
     */
    String getHospRiskHistoryFalls();

    /**
     * @return the hospRiskMentalBehavDecl
     */
    String getHospRiskMentalBehavDecl();

    /**
     * @return the hospRiskMultiEdVisit
     */
    String getHospRiskMultiEdVisit();

    /**
     * @return the hospRiskMultiHospital
     */
    String getHospRiskMultiHospital();

    /**
     * @return the hospRiskNoneAbove
     */
    String getHospRiskNoneAbove();

    /**
     * @return the hospRiskOtherRisk
     */
    String getHospRiskOtherRisk();

    /**
     * @return the hospRiskRiskExhaustion
     */
    String getHospRiskExhaustion();

    /**
     * @return the hospRiskWeightLoss
     */
    String getHospRiskWeightLoss();

    /**
     * @return the pdx
     */
    DxContainerIF getPdx();

    /**
     * @return the periodTiming
     */
    String getPeriodTiming();

    /**
     * @return the referralSource
     */
    String getReferralSource();

    /**
     * @return the returnCode
     */
    ReturnCodeContainerIF getReturnCode();

    /**
     *
     * @return
     */
    String getReturnCodeDescription();

    /**
     *
     * @return
     */
    String getReturnCodeValue();

    /**
     * @return the sdxList
     */
    List<DxContainerIF> getSdxList();

    /**
     * @return the toileting
     */
    String getToileting();

    /**
     * @return the transferring
     */
    String getTransferring();

    /**
     * @return the validityFlag
     */
    ValidityFlagContainerIF getValidityFlag();

    /**
     *
     * @return
     */
    String getValidityFlagDescription();

    /**
     *
     * @return
     */
    String getValidityFlagValue();

    /**
     * @return the versionUsed
     */
    String getVersionUsed();

    /**
     * @param ambulation the ambulation to set
     */
    void setAmbulation(String ambulation);

    /**
     * @param bathing the bathing to set
     */
    void setBathing(String bathing);

    /**
     * @param claimId the claimId to set
     */
    void setClaimId(String claimId);

    /**
     * @param dressLower the dressLower to set
     */
    void setDressLower(String dressLower);

    /**
     * @param dressUpper the dressUpper to set
     */
    void setDressUpper(String dressUpper);

    /**
     * @param fromDate the fromDate to set
     */
    void setFromDate(String fromDate);

    /**
     * @param throughDate the throughDate to set
     */
    void setThroughDate(String throughDate);

    /**
     * @param grooming the grooming to set
     */
    void setGrooming(String grooming);

    /**
     * @param HippsCode the HippsCode to set
     */
    void setHippsCode(String HippsCode);

    /**
     * @param hospRiskCompliance the hospRiskCompliance to set
     */
    void setHospRiskCompliance(String hospRiskCompliance);

    /**
     * @param hospRiskFiveMoreMeds the hospRiskFiveMoreMeds to set
     */
    void setHospRiskFiveMoreMeds(String hospRiskFiveMoreMeds);

    /**
     * @param hospRiskHistoryFalls the hospRiskHistoryFalls to set
     */
    void setHospRiskHistoryFalls(String hospRiskHistoryFalls);

    /**
     * @param hospRiskMentalBehavDecl the hospRiskMentalBehavDecl to set
     */
    void setHospRiskMentalBehavDecl(String hospRiskMentalBehavDecl);

    /**
     * @param hospRiskMultiEdVisit the hospRiskMultiEdVisit to set
     */
    void setHospRiskMultiEdVisit(String hospRiskMultiEdVisit);

    /**
     * @param hospRiskMultiHospital the hospRiskMultiHospital to set
     */
    void setHospRiskMultiHospital(String hospRiskMultiHospital);

    /**
     * @param hospRiskNoneAbove the hospRiskNoneAbove to set
     */
    void setHospRiskNoneAbove(String hospRiskNoneAbove);

    /**
     * @param hospRiskOtherRisk the hospRiskOtherRisk to set
     */
    void setHospRiskOtherRisk(String hospRiskOtherRisk);

    /**
     * @param hospRiskRiskExhaustion
     */
    void setHospRiskExhaustion(String hospRiskRiskExhaustion);

    /**
     * @param hospRiskWeightLoss the hospRiskWeightLoss to set
     */
    void setHospRiskWeightLoss(String hospRiskWeightLoss);

    /**
     *
     * @param pdx
     * @param poa
     */
    void setPdx(String pdx, String poa);

    /**
     * @param pdx the pdx to set
     */
    void setPdx(DxContainerIF pdx);

    /**
     * @param periodTiming the periodTiming to set
     */
    void setPeriodTiming(String periodTiming);

    /**
     * @param referralSource the referralSource to set
     */
    void setReferralSource(String referralSource);

    /**
     * @param returnCode the returnCode to set
     */
    void setReturnCode(ReturnCodeContainerIF returnCode);

    /**
     * @param sdxList the sdxList to set
     */
    void setSdxList(List<DxContainerIF> sdxList);

    /**
     * @param toileting the toileting to set
     */
    void setToileting(String toileting);

    /**
     * @param transferring the transferring to set
     */
    void setTransferring(String transferring);

    /**
     * @param validityFlag the validityFlag to set
     */
    void setValidityFlag(ValidityFlagContainerIF validityFlag);

    /**
     * @param versionUsed the versionUsed to set
     */
    void setVersionUsed(String versionUsed);

    /**
     *
     * @return
     */
    Map<String, String> getFunctionalFields();
    
    /**
     * @return the editList
     */
    public EditCollectionIF getEdits();

    /**
     * @param edits the editList to set
     */
    public void setEdits(EditCollectionIF edits);

    /**
     * @return the hippsContainerIF
     */
    public HippsContainerIF getHippsContainer();

    /**
     * @param hippsContainerIF the hippsContainerIF to set
     */
    public void setHippsContainer(HippsContainerIF hippsContainerIF);

}