/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.cookie;

import com.ning.http.client.cookie.RFC2616DateParser;
import java.text.ParsePosition;
import java.util.BitSet;
import java.util.Date;

public class CookieUtil {
    private static final BitSet VALID_COOKIE_VALUE_OCTETS = CookieUtil.validCookieValueOctets();
    private static final BitSet VALID_COOKIE_NAME_OCTETS = CookieUtil.validCookieNameOctets();

    private static BitSet validCookieValueOctets() {
        int i2;
        BitSet bits = new BitSet(8);
        bits.set(33);
        for (i2 = 35; i2 <= 43; ++i2) {
            bits.set(i2);
        }
        for (i2 = 45; i2 <= 58; ++i2) {
            bits.set(i2);
        }
        for (i2 = 60; i2 <= 91; ++i2) {
            bits.set(i2);
        }
        for (i2 = 93; i2 <= 126; ++i2) {
            bits.set(i2);
        }
        return bits;
    }

    private static BitSet validCookieNameOctets() {
        int[] separators;
        BitSet bits = new BitSet(8);
        for (int i2 = 32; i2 < 127; ++i2) {
            bits.set(i2);
        }
        for (int separator : separators = new int[]{40, 41, 60, 62, 64, 44, 59, 58, 92, 34, 47, 91, 93, 63, 61, 123, 125, 32, 9}) {
            bits.set(separator, false);
        }
        return bits;
    }

    static int firstInvalidCookieNameOctet(CharSequence cs) {
        return CookieUtil.firstInvalidOctet(cs, VALID_COOKIE_NAME_OCTETS);
    }

    static int firstInvalidCookieValueOctet(CharSequence cs) {
        return CookieUtil.firstInvalidOctet(cs, VALID_COOKIE_VALUE_OCTETS);
    }

    static int firstInvalidOctet(CharSequence cs, BitSet bits) {
        for (int i2 = 0; i2 < cs.length(); ++i2) {
            char c = cs.charAt(i2);
            if (bits.get(c)) continue;
            return i2;
        }
        return -1;
    }

    static CharSequence unwrapValue(CharSequence cs) {
        int len = cs.length();
        if (len > 0 && cs.charAt(0) == '\"') {
            if (len >= 2 && cs.charAt(len - 1) == '\"') {
                return len == 2 ? "" : cs.subSequence(1, len - 1);
            }
            return null;
        }
        return cs;
    }

    static long computeExpiresAsMaxAge(String expires) {
        Date expiresDate;
        if (expires != null && (expiresDate = RFC2616DateParser.get().parse(expires, new ParsePosition(0))) != null) {
            long maxAgeMillis = expiresDate.getTime() - System.currentTimeMillis();
            return maxAgeMillis / 1000L + (long)(maxAgeMillis % 1000L != 0L ? 1 : 0);
        }
        return Long.MIN_VALUE;
    }

    private CookieUtil() {
    }
}

