/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.application.resources;

import com.codahale.metrics.annotation.Timed;
import gov.cms.fiss.pricers.common.application.OpenApiApplicationConfiguration;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/v1/supported-years")
@Produces(value={"application/json"})
public class SupportedYearResource {
    final OpenApiApplicationConfiguration applicationConfiguration;

    public SupportedYearResource(OpenApiApplicationConfiguration applicationConfiguration) {
        this.applicationConfiguration = applicationConfiguration;
    }

    @GET
    @Timed(name="supported-years")
    @Operation(summary="Supported year endpoint.", description="Provides the supported years for the current deployment of the pricer application.", responses={@ApiResponse(responseCode="200", description="The supported years for the pricer application.", content={@Content(examples={@ExampleObject(description="The response content.", name="default", summary="Example years", value="[\n  2020,\n  2021,\n  2022\n]")}, mediaType="application/json")})})
    public List<Integer> getYears() {
        return this.applicationConfiguration.getSupportedYears();
    }
}

