/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps;

import gov.cms.fiss.pricers.common.application.OpenApiPricerApplication;
import gov.cms.fiss.pricers.common.application.contract.OpenApiCustomizer;
import gov.cms.fiss.pricers.common.application.resources.ApcRateResource;
import gov.cms.fiss.pricers.common.application.resources.CbsaWageIndexResource;
import gov.cms.fiss.pricers.opps.OppsPricerConfiguration;
import gov.cms.fiss.pricers.opps.core.OppsPricerDispatch;
import gov.cms.fiss.pricers.opps.resources.OppsClaimPricingResource;
import gov.cms.fiss.pricers.opps.resources.OppsExtractionUtil;
import io.dropwizard.setup.Environment;
import io.swagger.v3.oas.models.info.Info;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OppsPricerApplication
extends OpenApiPricerApplication<OppsPricerConfiguration> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OppsPricerApplication.class);

    public static void main(String[] args) throws Exception {
        new OppsPricerApplication().run(args);
    }

    @Override
    protected void configureApplication(OppsPricerConfiguration configuration, Environment environment) {
        OppsClaimPricingResource v2Resource = new OppsClaimPricingResource(new OppsPricerDispatch(configuration));
        environment.jersey().register(v2Resource);
        environment.jersey().register(new ApcRateResource(configuration, OppsExtractionUtil.APC_EXTRACTOR));
        environment.jersey().register(new CbsaWageIndexResource(configuration, OppsExtractionUtil.CBSA_EXTRACTOR));
    }

    @Override
    protected List<OpenApiCustomizer> getContractCustomizers() {
        ArrayList<OpenApiCustomizer> customizers = new ArrayList<OpenApiCustomizer>(super.getContractCustomizers());
        customizers.add((configuration, environment, oas) -> oas.info(new Info().title("OPPS Pricer").version("v1")));
        return customizers;
    }

    @Override
    protected Map<Integer, String> getCalculationVersions() {
        return Map.of(2020, "2020.4", 2021, "2021.4", 2022, "2022.2", 2023, "2023.2", 2024, "2024.4");
    }

    @Override
    public String getName() {
        return "opps-pricer";
    }

    @Override
    protected List<Package> getResourcePackages() {
        return Collections.singletonList(OppsClaimPricingResource.class.getPackage());
    }
}

