/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.api.v2;

import gov.cms.fiss.pricers.common.api.ClaimData;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.serialization.StrictLocalDate;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.opps.api.v2.PayerOnlyValueCodeOffsetData;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import lombok.Generated;

@Schema(description="The billing information associated with the claim.")
public class OppsClaimData
extends ClaimData {
    @Max(value=9L)
    @Min(value=0L)
    @Schema(description="The number of blood pints allowed for deductibles.", example="3", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BENE-BLOOD-PINTS", value="PIC 9(01)")})})
    private @Max(value=9L) @Min(value=0L) int bloodPintsRemaining;
    @BigDecimalScale
    @DecimalMax(value="999999999.99")
    @DecimalMin(value="0")
    @Digits(integer=9, fraction=2)
    @Schema(description="The device credit applied to the claim.", example="8734.56", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="L-DEVICE-CREDIT", value="PIC 9(09)V9(02)")})})
    private @DecimalMax(value="999999999.99") @DecimalMin(value="0") @Digits(integer=9, fraction=2) BigDecimal deviceCredit;
    @ArraySchema(arraySchema=@Schema(description="The IOCE service lines.", required=true), uniqueItems=true, extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OCE-DATA", value="OPPS-OCE-LINE OCCURS 450 TIMES"), @ExtensionProperty(name="OCE-IN-DATE", value="OCE-IN-LINES OCCURS 450 TIMES")})})
    @NotEmpty
    @Size(max=450)
    @Valid
    private @NotEmpty @Size(max=450) @Valid List<@NotNull IoceServiceLineData> ioceServiceLines;
    @BigDecimalScale
    @DecimalMax(value="99999999999.99")
    @DecimalMin(value="0")
    @Digits(integer=11, fraction=2)
    @Schema(description="The patient's deductible.", example="30043568744.23", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BENE-DEDUCT", value="PIC 9(11)V9(02)")})})
    private @DecimalMax(value="99999999999.99") @DecimalMin(value="0") @Digits(integer=11, fraction=2) BigDecimal patientDeductible;
    @Valid
    private PayerOnlyValueCodeOffsetData payerOnlyValueCodeOffsets = new PayerOnlyValueCodeOffsetData();
    @BigDecimalScale
    @DecimalMax(value="9999999999.99")
    @DecimalMin(value="0")
    @Digits(integer=10, fraction=2)
    @Schema(description="The prior outlier payment total.", example="256060.93", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="L-PRIOR-OUTL-TOTAL", value="PIC 9(10)V9(02)")})})
    private @DecimalMax(value="9999999999.99") @DecimalMin(value="0") @Digits(integer=10, fraction=2) BigDecimal priorOutlierTotal = BigDecimalUtils.ZERO;
    @BigDecimalScale
    @DecimalMax(value="9999999999.99")
    @DecimalMin(value="0")
    @Digits(integer=10, fraction=2)
    @Schema(description="The prior payment total.", example="983745.33", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="L-PRIOR-PYMT-TOTAL", value="PIC 9(10)V9(02)")})})
    private @DecimalMax(value="9999999999.99") @DecimalMin(value="0") @Digits(integer=10, fraction=2) BigDecimal priorPaymentTotal = BigDecimalUtils.ZERO;
    @NotNull
    @Schema(description="The start date of service.", example="2020-05-13", format="yyyy-MM-dd", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="L-SERVICE-FROM-DATE", value="PIC 9(08)")})})
    @StrictLocalDate
    private LocalDate serviceFromDate;
    @NotNull
    @Pattern(regexp="[A-Z\\d]{3}", message="must be three alphanumeric characters")
    @Schema(description="The code indicating the specific type of bill: inpatient, outpatient, adjustments, voids, etc.", example="137", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="L-TYPE-OF-BILL", value="PIC X(03)")})})
    private @NotNull @Pattern(regexp="[A-Z\\d]{3}", message="must be three alphanumeric characters") String typeOfBill;

    @Generated
    public int getBloodPintsRemaining() {
        return this.bloodPintsRemaining;
    }

    @Generated
    public BigDecimal getDeviceCredit() {
        return this.deviceCredit;
    }

    @Generated
    public List<@NotNull IoceServiceLineData> getIoceServiceLines() {
        return this.ioceServiceLines;
    }

    @Generated
    public BigDecimal getPatientDeductible() {
        return this.patientDeductible;
    }

    @Generated
    public PayerOnlyValueCodeOffsetData getPayerOnlyValueCodeOffsets() {
        return this.payerOnlyValueCodeOffsets;
    }

    @Generated
    public BigDecimal getPriorOutlierTotal() {
        return this.priorOutlierTotal;
    }

    @Generated
    public BigDecimal getPriorPaymentTotal() {
        return this.priorPaymentTotal;
    }

    @Generated
    public LocalDate getServiceFromDate() {
        return this.serviceFromDate;
    }

    @Generated
    public String getTypeOfBill() {
        return this.typeOfBill;
    }

    @Generated
    public void setBloodPintsRemaining(int bloodPintsRemaining) {
        this.bloodPintsRemaining = bloodPintsRemaining;
    }

    @Generated
    public void setDeviceCredit(BigDecimal deviceCredit) {
        this.deviceCredit = deviceCredit;
    }

    @Generated
    public void setIoceServiceLines(List<@NotNull IoceServiceLineData> ioceServiceLines) {
        this.ioceServiceLines = ioceServiceLines;
    }

    @Generated
    public void setPatientDeductible(BigDecimal patientDeductible) {
        this.patientDeductible = patientDeductible;
    }

    @Generated
    public void setPayerOnlyValueCodeOffsets(PayerOnlyValueCodeOffsetData payerOnlyValueCodeOffsets) {
        this.payerOnlyValueCodeOffsets = payerOnlyValueCodeOffsets;
    }

    @Generated
    public void setPriorOutlierTotal(BigDecimal priorOutlierTotal) {
        this.priorOutlierTotal = priorOutlierTotal;
    }

    @Generated
    public void setPriorPaymentTotal(BigDecimal priorPaymentTotal) {
        this.priorPaymentTotal = priorPaymentTotal;
    }

    @Generated
    public void setServiceFromDate(LocalDate serviceFromDate) {
        this.serviceFromDate = serviceFromDate;
    }

    @Generated
    public void setTypeOfBill(String typeOfBill) {
        this.typeOfBill = typeOfBill;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OppsClaimData)) {
            return false;
        }
        OppsClaimData other = (OppsClaimData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getBloodPintsRemaining() != other.getBloodPintsRemaining()) {
            return false;
        }
        BigDecimal this$deviceCredit = this.getDeviceCredit();
        BigDecimal other$deviceCredit = other.getDeviceCredit();
        if (this$deviceCredit == null ? other$deviceCredit != null : !((Object)this$deviceCredit).equals(other$deviceCredit)) {
            return false;
        }
        List<IoceServiceLineData> this$ioceServiceLines = this.getIoceServiceLines();
        List<IoceServiceLineData> other$ioceServiceLines = other.getIoceServiceLines();
        if (this$ioceServiceLines == null ? other$ioceServiceLines != null : !((Object)this$ioceServiceLines).equals(other$ioceServiceLines)) {
            return false;
        }
        BigDecimal this$patientDeductible = this.getPatientDeductible();
        BigDecimal other$patientDeductible = other.getPatientDeductible();
        if (this$patientDeductible == null ? other$patientDeductible != null : !((Object)this$patientDeductible).equals(other$patientDeductible)) {
            return false;
        }
        PayerOnlyValueCodeOffsetData this$payerOnlyValueCodeOffsets = this.getPayerOnlyValueCodeOffsets();
        PayerOnlyValueCodeOffsetData other$payerOnlyValueCodeOffsets = other.getPayerOnlyValueCodeOffsets();
        if (this$payerOnlyValueCodeOffsets == null ? other$payerOnlyValueCodeOffsets != null : !((Object)this$payerOnlyValueCodeOffsets).equals(other$payerOnlyValueCodeOffsets)) {
            return false;
        }
        BigDecimal this$priorOutlierTotal = this.getPriorOutlierTotal();
        BigDecimal other$priorOutlierTotal = other.getPriorOutlierTotal();
        if (this$priorOutlierTotal == null ? other$priorOutlierTotal != null : !((Object)this$priorOutlierTotal).equals(other$priorOutlierTotal)) {
            return false;
        }
        BigDecimal this$priorPaymentTotal = this.getPriorPaymentTotal();
        BigDecimal other$priorPaymentTotal = other.getPriorPaymentTotal();
        if (this$priorPaymentTotal == null ? other$priorPaymentTotal != null : !((Object)this$priorPaymentTotal).equals(other$priorPaymentTotal)) {
            return false;
        }
        LocalDate this$serviceFromDate = this.getServiceFromDate();
        LocalDate other$serviceFromDate = other.getServiceFromDate();
        if (this$serviceFromDate == null ? other$serviceFromDate != null : !((Object)this$serviceFromDate).equals(other$serviceFromDate)) {
            return false;
        }
        String this$typeOfBill = this.getTypeOfBill();
        String other$typeOfBill = other.getTypeOfBill();
        return !(this$typeOfBill == null ? other$typeOfBill != null : !this$typeOfBill.equals(other$typeOfBill));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OppsClaimData;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getBloodPintsRemaining();
        BigDecimal $deviceCredit = this.getDeviceCredit();
        result = result * 59 + ($deviceCredit == null ? 43 : ((Object)$deviceCredit).hashCode());
        List<IoceServiceLineData> $ioceServiceLines = this.getIoceServiceLines();
        result = result * 59 + ($ioceServiceLines == null ? 43 : ((Object)$ioceServiceLines).hashCode());
        BigDecimal $patientDeductible = this.getPatientDeductible();
        result = result * 59 + ($patientDeductible == null ? 43 : ((Object)$patientDeductible).hashCode());
        PayerOnlyValueCodeOffsetData $payerOnlyValueCodeOffsets = this.getPayerOnlyValueCodeOffsets();
        result = result * 59 + ($payerOnlyValueCodeOffsets == null ? 43 : ((Object)$payerOnlyValueCodeOffsets).hashCode());
        BigDecimal $priorOutlierTotal = this.getPriorOutlierTotal();
        result = result * 59 + ($priorOutlierTotal == null ? 43 : ((Object)$priorOutlierTotal).hashCode());
        BigDecimal $priorPaymentTotal = this.getPriorPaymentTotal();
        result = result * 59 + ($priorPaymentTotal == null ? 43 : ((Object)$priorPaymentTotal).hashCode());
        LocalDate $serviceFromDate = this.getServiceFromDate();
        result = result * 59 + ($serviceFromDate == null ? 43 : ((Object)$serviceFromDate).hashCode());
        String $typeOfBill = this.getTypeOfBill();
        result = result * 59 + ($typeOfBill == null ? 43 : $typeOfBill.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "OppsClaimData(bloodPintsRemaining=" + this.getBloodPintsRemaining() + ", deviceCredit=" + this.getDeviceCredit() + ", ioceServiceLines=" + this.getIoceServiceLines() + ", patientDeductible=" + this.getPatientDeductible() + ", payerOnlyValueCodeOffsets=" + this.getPayerOnlyValueCodeOffsets() + ", priorOutlierTotal=" + this.getPriorOutlierTotal() + ", priorPaymentTotal=" + this.getPriorPaymentTotal() + ", serviceFromDate=" + this.getServiceFromDate() + ", typeOfBill=" + this.getTypeOfBill() + ")";
    }

    @Generated
    public OppsClaimData() {
    }
}

