/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.api.v2;

import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import lombok.Generated;

@Schema(description="The APC payment offset amounts for payer value codes.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="L-PAYER-ONLY-VALUE-CODES", value="<structure>")})})
public class PayerOnlyValueCodeOffsetData {
    @BigDecimalScale
    @DecimalMax(value="999999999.99")
    @DecimalMin(value="0")
    @Digits(integer=9, fraction=2)
    @Schema(description="The APC payment offset amount for payer value code QN (APC device offset).", example="98236.75", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="L-PAYER-ONLY-VC-QN", value="PIC 9(09)V9(02)")})})
    private @DecimalMax(value="999999999.99") @DecimalMin(value="0") @Digits(integer=9, fraction=2) BigDecimal apcDeviceOffsetAmountQn;
    @BigDecimalScale
    @DecimalMax(value="999999999.99")
    @DecimalMin(value="0")
    @Digits(integer=9, fraction=2)
    @Schema(description="The APC payment offset amount for payer value code QO (additional APC device offset).", example="8079234.65", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="L-PAYER-ONLY-VC-QO", value="PIC 9(09)V9(02)")})})
    private @DecimalMax(value="999999999.99") @DecimalMin(value="0") @Digits(integer=9, fraction=2) BigDecimal apcDeviceOffsetAmountQo;
    @BigDecimalScale
    @DecimalMax(value="999999999.99")
    @DecimalMin(value="0")
    @Digits(integer=9, fraction=2)
    @Schema(description="The APC payment offset amount for payer value code QU (condition for device credit present).", example="345906.87", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="L-PAYER-ONLY-VC-QU", value="PIC 9(09)V9(02)")})})
    private @DecimalMax(value="999999999.99") @DecimalMin(value="0") @Digits(integer=9, fraction=2) BigDecimal deviceCreditCapOffsetAmountQu;
    @BigDecimalScale
    @DecimalMax(value="999999999.99")
    @DecimalMin(value="0")
    @Digits(integer=9, fraction=2)
    @Schema(description="The APC payment offset amount for payer value code QQ (terminated procedure with pass-through device OR condition for device credit present).", example="3454665.35", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="L-PAYER-ONLY-VC-QQ", value="PIC 9(09)V9(02)")})})
    private @DecimalMax(value="999999999.99") @DecimalMin(value="0") @Digits(integer=9, fraction=2) BigDecimal terminatedPassthroughOffsetAmountQq;
    @BigDecimalScale
    @DecimalMax(value="999999999.99")
    @DecimalMin(value="0")
    @Digits(integer=9, fraction=2)
    @Schema(description="Condition for First non-opioid device payment limitation.", example="2894335.35", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="L-PAYER-ONLY-VC-QV", value="PIC 9(09)V9(02)")})})
    private @DecimalMax(value="999999999.99") @DecimalMin(value="0") @Digits(integer=9, fraction=2) BigDecimal nonOpioidDeviceCapAmountQv;
    @BigDecimalScale
    @DecimalMax(value="999999999.99")
    @DecimalMin(value="0")
    @Digits(integer=9, fraction=2)
    @Schema(description="Second Non-opioid surgical pain relief device payment limitation.", example="2894225.35", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="L-PAYER-ONLY-VC-QP", value="PIC 9(09)V9(02)")})})
    private @DecimalMax(value="999999999.99") @DecimalMin(value="0") @Digits(integer=9, fraction=2) BigDecimal nonOpioidDeviceCapAmountQp;

    @Generated
    public BigDecimal getApcDeviceOffsetAmountQn() {
        return this.apcDeviceOffsetAmountQn;
    }

    @Generated
    public BigDecimal getApcDeviceOffsetAmountQo() {
        return this.apcDeviceOffsetAmountQo;
    }

    @Generated
    public BigDecimal getDeviceCreditCapOffsetAmountQu() {
        return this.deviceCreditCapOffsetAmountQu;
    }

    @Generated
    public BigDecimal getTerminatedPassthroughOffsetAmountQq() {
        return this.terminatedPassthroughOffsetAmountQq;
    }

    @Generated
    public BigDecimal getNonOpioidDeviceCapAmountQv() {
        return this.nonOpioidDeviceCapAmountQv;
    }

    @Generated
    public BigDecimal getNonOpioidDeviceCapAmountQp() {
        return this.nonOpioidDeviceCapAmountQp;
    }

    @Generated
    public void setApcDeviceOffsetAmountQn(BigDecimal apcDeviceOffsetAmountQn) {
        this.apcDeviceOffsetAmountQn = apcDeviceOffsetAmountQn;
    }

    @Generated
    public void setApcDeviceOffsetAmountQo(BigDecimal apcDeviceOffsetAmountQo) {
        this.apcDeviceOffsetAmountQo = apcDeviceOffsetAmountQo;
    }

    @Generated
    public void setDeviceCreditCapOffsetAmountQu(BigDecimal deviceCreditCapOffsetAmountQu) {
        this.deviceCreditCapOffsetAmountQu = deviceCreditCapOffsetAmountQu;
    }

    @Generated
    public void setTerminatedPassthroughOffsetAmountQq(BigDecimal terminatedPassthroughOffsetAmountQq) {
        this.terminatedPassthroughOffsetAmountQq = terminatedPassthroughOffsetAmountQq;
    }

    @Generated
    public void setNonOpioidDeviceCapAmountQv(BigDecimal nonOpioidDeviceCapAmountQv) {
        this.nonOpioidDeviceCapAmountQv = nonOpioidDeviceCapAmountQv;
    }

    @Generated
    public void setNonOpioidDeviceCapAmountQp(BigDecimal nonOpioidDeviceCapAmountQp) {
        this.nonOpioidDeviceCapAmountQp = nonOpioidDeviceCapAmountQp;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PayerOnlyValueCodeOffsetData)) {
            return false;
        }
        PayerOnlyValueCodeOffsetData other = (PayerOnlyValueCodeOffsetData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigDecimal this$apcDeviceOffsetAmountQn = this.getApcDeviceOffsetAmountQn();
        BigDecimal other$apcDeviceOffsetAmountQn = other.getApcDeviceOffsetAmountQn();
        if (this$apcDeviceOffsetAmountQn == null ? other$apcDeviceOffsetAmountQn != null : !((Object)this$apcDeviceOffsetAmountQn).equals(other$apcDeviceOffsetAmountQn)) {
            return false;
        }
        BigDecimal this$apcDeviceOffsetAmountQo = this.getApcDeviceOffsetAmountQo();
        BigDecimal other$apcDeviceOffsetAmountQo = other.getApcDeviceOffsetAmountQo();
        if (this$apcDeviceOffsetAmountQo == null ? other$apcDeviceOffsetAmountQo != null : !((Object)this$apcDeviceOffsetAmountQo).equals(other$apcDeviceOffsetAmountQo)) {
            return false;
        }
        BigDecimal this$deviceCreditCapOffsetAmountQu = this.getDeviceCreditCapOffsetAmountQu();
        BigDecimal other$deviceCreditCapOffsetAmountQu = other.getDeviceCreditCapOffsetAmountQu();
        if (this$deviceCreditCapOffsetAmountQu == null ? other$deviceCreditCapOffsetAmountQu != null : !((Object)this$deviceCreditCapOffsetAmountQu).equals(other$deviceCreditCapOffsetAmountQu)) {
            return false;
        }
        BigDecimal this$terminatedPassthroughOffsetAmountQq = this.getTerminatedPassthroughOffsetAmountQq();
        BigDecimal other$terminatedPassthroughOffsetAmountQq = other.getTerminatedPassthroughOffsetAmountQq();
        if (this$terminatedPassthroughOffsetAmountQq == null ? other$terminatedPassthroughOffsetAmountQq != null : !((Object)this$terminatedPassthroughOffsetAmountQq).equals(other$terminatedPassthroughOffsetAmountQq)) {
            return false;
        }
        BigDecimal this$nonOpioidDeviceCapAmountQv = this.getNonOpioidDeviceCapAmountQv();
        BigDecimal other$nonOpioidDeviceCapAmountQv = other.getNonOpioidDeviceCapAmountQv();
        if (this$nonOpioidDeviceCapAmountQv == null ? other$nonOpioidDeviceCapAmountQv != null : !((Object)this$nonOpioidDeviceCapAmountQv).equals(other$nonOpioidDeviceCapAmountQv)) {
            return false;
        }
        BigDecimal this$nonOpioidDeviceCapAmountQp = this.getNonOpioidDeviceCapAmountQp();
        BigDecimal other$nonOpioidDeviceCapAmountQp = other.getNonOpioidDeviceCapAmountQp();
        return !(this$nonOpioidDeviceCapAmountQp == null ? other$nonOpioidDeviceCapAmountQp != null : !((Object)this$nonOpioidDeviceCapAmountQp).equals(other$nonOpioidDeviceCapAmountQp));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PayerOnlyValueCodeOffsetData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigDecimal $apcDeviceOffsetAmountQn = this.getApcDeviceOffsetAmountQn();
        result = result * 59 + ($apcDeviceOffsetAmountQn == null ? 43 : ((Object)$apcDeviceOffsetAmountQn).hashCode());
        BigDecimal $apcDeviceOffsetAmountQo = this.getApcDeviceOffsetAmountQo();
        result = result * 59 + ($apcDeviceOffsetAmountQo == null ? 43 : ((Object)$apcDeviceOffsetAmountQo).hashCode());
        BigDecimal $deviceCreditCapOffsetAmountQu = this.getDeviceCreditCapOffsetAmountQu();
        result = result * 59 + ($deviceCreditCapOffsetAmountQu == null ? 43 : ((Object)$deviceCreditCapOffsetAmountQu).hashCode());
        BigDecimal $terminatedPassthroughOffsetAmountQq = this.getTerminatedPassthroughOffsetAmountQq();
        result = result * 59 + ($terminatedPassthroughOffsetAmountQq == null ? 43 : ((Object)$terminatedPassthroughOffsetAmountQq).hashCode());
        BigDecimal $nonOpioidDeviceCapAmountQv = this.getNonOpioidDeviceCapAmountQv();
        result = result * 59 + ($nonOpioidDeviceCapAmountQv == null ? 43 : ((Object)$nonOpioidDeviceCapAmountQv).hashCode());
        BigDecimal $nonOpioidDeviceCapAmountQp = this.getNonOpioidDeviceCapAmountQp();
        result = result * 59 + ($nonOpioidDeviceCapAmountQp == null ? 43 : ((Object)$nonOpioidDeviceCapAmountQp).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PayerOnlyValueCodeOffsetData(apcDeviceOffsetAmountQn=" + this.getApcDeviceOffsetAmountQn() + ", apcDeviceOffsetAmountQo=" + this.getApcDeviceOffsetAmountQo() + ", deviceCreditCapOffsetAmountQu=" + this.getDeviceCreditCapOffsetAmountQu() + ", terminatedPassthroughOffsetAmountQq=" + this.getTerminatedPassthroughOffsetAmountQq() + ", nonOpioidDeviceCapAmountQv=" + this.getNonOpioidDeviceCapAmountQv() + ", nonOpioidDeviceCapAmountQp=" + this.getNonOpioidDeviceCapAmountQp() + ")";
    }

    @Generated
    public PayerOnlyValueCodeOffsetData() {
    }
}

