/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import gov.cms.fiss.pricers.common.api.OutpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationContext;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimData;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingRequest;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingResponse;
import gov.cms.fiss.pricers.opps.api.v2.OppsPaymentData;
import gov.cms.fiss.pricers.opps.api.v2.ServiceLinePaymentData;
import gov.cms.fiss.pricers.opps.core.OutlierPaymentInfo;
import gov.cms.fiss.pricers.opps.core.codes.ActionFlag;
import gov.cms.fiss.pricers.opps.core.codes.PackageFlag;
import gov.cms.fiss.pricers.opps.core.codes.PaymentAdjustmentFlag;
import gov.cms.fiss.pricers.opps.core.codes.PaymentMethodFlag;
import gov.cms.fiss.pricers.opps.core.codes.ReturnCode;
import gov.cms.fiss.pricers.opps.core.codes.StatusIndicator;
import gov.cms.fiss.pricers.opps.core.model.APCCalculationData;
import gov.cms.fiss.pricers.opps.core.model.CoinsuranceCapEntry;
import gov.cms.fiss.pricers.opps.core.model.DeductibleLine;
import gov.cms.fiss.pricers.opps.core.tables.DataTables;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class OppsPricerContext
extends CalculationContext<OppsClaimPricingRequest, OppsClaimPricingResponse> {
    public static final List<String> LINE_DENY_OR_REJECT_FLAG = List.of("0", "3");
    public static final List<String> LINE_REVENUE_CODE = List.of("0390", "0392", "0399");
    public static final List<String> SCH_PROVIDER_TYPE = List.of("16", "17", "21", "22");
    public static final List<String> REH_PROVIDER_TYPE_24 = List.of("24");
    public static final List<String> REH_PROVIDER_TYPE_25 = List.of("25");
    public static final BigDecimal PFS_REDUCTION_COINSURANCE_RATE = new BigDecimal("0.20");
    public static final BigDecimal PFS_REDUCTION_REIMBURSEMENT_RATE = new BigDecimal("0.80");
    public static final BigDecimal DISCOUNT_FRACTION = new BigDecimal("0.50000000");
    public static final BigDecimal TERMINATION_PROCEDURE_DISCOUNT = new BigDecimal("0.500");
    public static final BigDecimal OUTLIER_FACTOR = new BigDecimal("1.75");
    public static final BigDecimal OUTLIER_FACTOR_ALT = new BigDecimal("3.4");
    public static final BigDecimal OUTLIER_PERCENT = new BigDecimal(".5");
    public static final BigDecimal CMHC_OUTLIER_PERCENT_CAP = new BigDecimal(".08");
    private static final Pattern OUTLIER_PROVIDER_CCN = Pattern.compile("..(14|4[679])[0-9][0-9]");
    private static final Pattern RURAL_CBSA = Pattern.compile("0[1-9]|[1-9][0-9]");
    private static final Pattern SIGNIFICANT_PROCEDURE_HCPCS = Pattern.compile("^[1-6][0-9]{4}$");
    private static final BigDecimal DEFAULT_INPATIENT_DEDUCTIBLE_CAP = new BigDecimal(1408);
    private static final BigDecimal DEFAULT_WAGE_INDEX_QUARTILE = new BigDecimal("0.8457");
    private static final BigDecimal DEFAULT_WAGE_INDEX_PERCENT_REDUCTION = new BigDecimal("-0.05");
    private static final BigDecimal DEFAULT_WAGE_INDEX_PERCENT_ADJUSTMENT = new BigDecimal("0.95");
    private static final BigDecimal DEFAULT_PHYSICIAN_FEE_SCHEDULE_REDUCTION = new BigDecimal("0.4");
    private static final BigDecimal DEFAULT_PAYMENT_METHOD_FLAG_A_REDUCTION = new BigDecimal("0.4");
    private static final BigDecimal DEFAULT_CT_SCAN_REDUCTION = new BigDecimal("0.85");
    private static final BigDecimal DEFAULT_X_RAY_FILM_REDUCTION = new BigDecimal("0.8");
    private static final BigDecimal DEFAULT_X_RAY_CRT_REDUCTION = new BigDecimal("0.93");
    private static final BigDecimal DEFAULT_LINE_PAYMENT_OUTLIER_OFFSET = new BigDecimal("5075");
    private static final BigDecimal DEFAULT_APC_QUALITY_REDUCTION = new BigDecimal("0.981");
    private static final BigDecimal DEFAULT_SOLE_COMMUNITY_HOSPITAL_ADJUSTMENT_RATE = new BigDecimal("1.071");
    private static final BigDecimal REH_FIVE_PERCENT_ADDON = new BigDecimal("0.05");
    private boolean rehExcludeCoinsurance = false;
    private BigDecimal rehFivePercentAddon;
    private boolean isRuralSch = false;
    private boolean isRehProviderType24Or25 = false;
    private static final BigDecimal REH_ELIGIBLE_COINSURANCE = new BigDecimal("0.20");
    @JsonIgnore
    private final DataTables dataTables;
    private final List<CoinsuranceCapEntry> coinsuranceCaps = new ArrayList<CoinsuranceCapEntry>();
    private final SortedMap<String, BigDecimal> compositeSubCharges = new TreeMap<String, BigDecimal>();
    private List<DeductibleLine> deductibleLines = new ArrayList<DeductibleLine>();
    private BigDecimal wageIndex = BigDecimalUtils.ZERO;
    private int beneficiaryBloodPintsUsed;
    private BigDecimal beneficiaryDeductible = BigDecimalUtils.ZERO;
    private BigDecimal claimDeviceCreditAmount = BigDecimalUtils.ZERO;
    private BigDecimal bloodProductCharges = BigDecimalUtils.ZERO;
    private BigDecimal totalBloodCharges = BigDecimalUtils.ZERO;
    private BigDecimal bloodProductPercentage = BigDecimalUtils.ZERO;
    private BigDecimal qnWageAdjustedPassThroughDeviceOffset = BigDecimalUtils.ZERO;
    private BigDecimal qoWageAdjustedPassThroughDeviceOffset = BigDecimalUtils.ZERO;
    private boolean bloodFlag;
    private boolean st0Flag;
    private boolean nFlag;
    private BigDecimal totalCharge = BigDecimalUtils.ZERO;
    private BigDecimal totalNCharge = BigDecimalUtils.ZERO;
    private OutlierPaymentInfo outlierPaymentInfo = new OutlierPaymentInfo();
    private BigDecimal totalSTCharge = BigDecimalUtils.ZERO;
    private BigDecimal totalSTPayment = BigDecimalUtils.ZERO;
    private BigDecimal totalClaimPayment = BigDecimalUtils.ZERO;
    private BigDecimal totalSTVXPayment = BigDecimalUtils.ZERO;
    private BigDecimal inpatientDeductibleLimit = this.getInpatientDeductibleCap();
    private BigDecimal totalQnPassThroughDeviceCharges = BigDecimalUtils.ZERO;
    private BigDecimal totalQoPassThroughDeviceCharges = BigDecimalUtils.ZERO;
    private BigDecimal totalTerminatedProcedureDeviceOffsetPayments = BigDecimalUtils.ZERO;
    private BigDecimal totalDeviceCreditPayments = BigDecimalUtils.ZERO;
    private BigDecimal apcPayment = BigDecimalUtils.ZERO;
    private BigDecimal discountRate = BigDecimalUtils.ZERO;
    private APCCalculationData apcCalculationData;

    protected OppsPricerContext(OppsClaimPricingRequest input, OppsClaimPricingResponse output, DataTables dataTables) {
        super(input, output);
        this.dataTables = dataTables;
        this.initializeContext();
    }

    public static boolean isRuralCbsa(String cbsa) {
        return RURAL_CBSA.matcher(StringUtils.trimToEmpty(cbsa)).matches();
    }

    public static boolean isBloodPaymentAdjustment(List<String> paymentAdjustmentFlags) {
        return Stream.of(PaymentAdjustmentFlag.BLOOD_DEDUCTIBLE_5, PaymentAdjustmentFlag.BLOOD_NOT_DEDUCTIBLE_6).anyMatch(paf -> paf.is(paymentAdjustmentFlags));
    }

    public static boolean isSection603(String paymentMethodFlag) {
        return Stream.of(PaymentMethodFlag.SECTION603_NO_REDUCTION_7, PaymentMethodFlag.SECTION603_REDUCTION_8, PaymentMethodFlag.CONTRACTOR_BYPASS_SECTION_603_NO_REDUCTION_X, PaymentMethodFlag.CONTRACTOR_BYPASS_SECTION_603_REDUCTION_Y).anyMatch(pmf -> pmf.is(paymentMethodFlag));
    }

    public static boolean isZeroValue(String codeString) {
        return StringUtils.isEmpty(RegExUtils.removeAll(codeString, "[0 ]"));
    }

    public static boolean isComprehensiveBloodDeductible(String statusIndicator, List<String> paymentAdjustmentFlags, boolean comprehensiveApcClaimFlag) {
        return comprehensiveApcClaimFlag && paymentAdjustmentFlags != null && paymentAdjustmentFlags.contains(PaymentAdjustmentFlag.BLOOD_DEDUCTIBLE_5.getFlag()) && StatusIndicator.R_BLOOD.is(statusIndicator);
    }

    public static boolean hasExternalAdjustment(String lineActionFlag) {
        return ActionFlag.EXTERNAL_LINE_ITEM_ADJUSTMENT_4.is(lineActionFlag);
    }

    public static boolean isSignificantProcedure(String statusIndicator, String hcpcs) {
        return (StatusIndicator.T_PROCEDURE_REDUCIBLE.is(statusIndicator) || StatusIndicator.S_PROCEDURE_NOT_DISCOUNTED.is(statusIndicator)) && SIGNIFICANT_PROCEDURE_HCPCS.matcher(hcpcs).matches();
    }

    public static boolean isSeparatelyPayable(String statusIndicator) {
        return Stream.of(StatusIndicator.P_PARTIAL_HOSPITALIZATION, StatusIndicator.R_BLOOD, StatusIndicator.S_PROCEDURE_NOT_DISCOUNTED, StatusIndicator.T_PROCEDURE_REDUCIBLE, StatusIndicator.U_BRACHYTHERAPY, StatusIndicator.V_EMERGENCY, StatusIndicator.X_ANCILLARY, StatusIndicator.J1_COMPREHENSIVE_APC_OUTPATIENT, StatusIndicator.J2_COMPREHENSIVE_APC_HOSPITAL).anyMatch(si -> si.is(statusIndicator));
    }

    protected void initializeContext() {
        this.getPaymentData().setServiceLinePayments(new ArrayList<ServiceLinePaymentData>());
        ((OppsClaimPricingResponse)this.getOutput()).setReturnCodeData(ReturnCode.PROCESSED_1.toReturnCodeData());
        for (IoceServiceLineData lineInput : this.getClaimData().getIoceServiceLines()) {
            ServiceLinePaymentData lineOutput = new ServiceLinePaymentData();
            lineOutput.setLineNumber(lineInput.getLineNumber());
            lineOutput.setReturnCode(ReturnCode.NOT_PROCESSED_0.toReturnCodeData());
            this.getPaymentData().getServiceLinePayments().add(lineOutput);
        }
    }

    public void addCoinsuranceCap(CoinsuranceCapEntry coinsuranceCapEntry) {
        this.coinsuranceCaps.add(coinsuranceCapEntry);
    }

    public BigDecimal getCompositeSubCharge(String compositeAdjustmentFlag) {
        return (BigDecimal)this.compositeSubCharges.get(compositeAdjustmentFlag);
    }

    public void addCompositeSubCharge(String compositeAdjustmentFlag, BigDecimal submittedCharge) {
        BigDecimal compositeTotalSubCharge = (BigDecimal)this.compositeSubCharges.get(compositeAdjustmentFlag);
        if (compositeTotalSubCharge == null) {
            this.compositeSubCharges.put(compositeAdjustmentFlag, submittedCharge);
        } else {
            this.compositeSubCharges.replace(compositeAdjustmentFlag, compositeTotalSubCharge.add(submittedCharge));
        }
    }

    public ServiceLinePaymentData getServiceLinePaymentByLineNumber(int number) {
        return this.getPaymentData().getServiceLinePayments().stream().filter(e -> e.getLineNumber() == number).findFirst().orElse(null);
    }

    public boolean getComprehensiveApcClaimStatus() {
        return this.getClaimData().getIoceServiceLines().stream().anyMatch(line -> this.isComprehensiveApc(line.getStatusIndicator()));
    }

    private boolean isComprehensiveApc(String statusIndicator) {
        return Stream.of(StatusIndicator.J1_COMPREHENSIVE_APC_OUTPATIENT, StatusIndicator.J2_COMPREHENSIVE_APC_HOSPITAL).anyMatch(si -> si.is(statusIndicator));
    }

    public void applyClaimReturnCode(ReturnCode returnCode) {
        ((OppsClaimPricingResponse)this.getOutput()).setReturnCodeData(returnCode.toReturnCodeData());
        if (returnCode.getCode() >= 50) {
            this.setCalculationCompleted();
        }
    }

    public boolean isBloodDeductibleHcpcsLine(String statusIndicator, String hcpcs, List<String> paymentAdjustmentFlags) {
        return StatusIndicator.R_BLOOD.is(statusIndicator) && this.dataTables.isBloodHcpcsDeductible(hcpcs) && OppsPricerContext.isBloodPaymentAdjustment(paymentAdjustmentFlags);
    }

    public boolean notEligibleForOutlierPayment(String statusIndicator, String packageFlag, String paymentMethodFlag, List<String> paymentAdjustmentFlags) {
        return Stream.of(StatusIndicator.H_PASS_THROUGH_DEVICE, StatusIndicator.N_PACKAGED_INTO_APC).anyMatch(si -> si.is(statusIndicator)) || PackageFlag.DRUG_ADMINISTRATION_4.is(packageFlag) || OppsPricerContext.isSection603(paymentMethodFlag) || OppsPricerContext.isComprehensiveBloodDeductible(statusIndicator, paymentAdjustmentFlags, this.getComprehensiveApcClaimStatus());
    }

    public boolean isCommunityMentalHealthCenter() {
        return OUTLIER_PROVIDER_CCN.matcher(this.getProviderData().getProviderCcn()).matches();
    }

    public boolean isREHStatusIndicatorExclusion(String statusIndicator) {
        return Stream.of(StatusIndicator.A_NOT_PAID_OPPS, StatusIndicator.F_CORNEAL_TISSUE, StatusIndicator.G_DRUG_PASS_THROUGH, StatusIndicator.K_NON_PASS_THROUGH_DRUG, StatusIndicator.L_FLU_PPV_VACCINES).anyMatch(si -> si.is(statusIndicator));
    }

    public OutpatientProviderData getProviderData() {
        return (OutpatientProviderData)((OppsClaimPricingRequest)this.getInput()).getProviderData();
    }

    @JsonIgnore
    public OppsClaimData getClaimData() {
        return (OppsClaimData)((OppsClaimPricingRequest)this.getInput()).getClaimData();
    }

    @JsonIgnore
    public OppsPaymentData getPaymentData() {
        return (OppsPaymentData)((OppsClaimPricingResponse)this.getOutput()).getPaymentData();
    }

    public abstract String getCalculationVersion();

    public BigDecimal getInpatientDeductibleCap() {
        return DEFAULT_INPATIENT_DEDUCTIBLE_CAP;
    }

    public BigDecimal getWageIndexQuartile() {
        return DEFAULT_WAGE_INDEX_QUARTILE;
    }

    public BigDecimal getWageIndexPercentReduction() {
        return DEFAULT_WAGE_INDEX_PERCENT_REDUCTION;
    }

    public BigDecimal getWageIndexPercentAdjustment() {
        return DEFAULT_WAGE_INDEX_PERCENT_ADJUSTMENT;
    }

    public BigDecimal getPhysicianFeeScheduleReduction() {
        return DEFAULT_PHYSICIAN_FEE_SCHEDULE_REDUCTION;
    }

    public BigDecimal getPaymentMethodFlagAReduction() {
        return DEFAULT_PAYMENT_METHOD_FLAG_A_REDUCTION;
    }

    public BigDecimal getCTScanReduction() {
        return DEFAULT_CT_SCAN_REDUCTION;
    }

    public BigDecimal getXRayFilmReduction() {
        return DEFAULT_X_RAY_FILM_REDUCTION;
    }

    public BigDecimal getXRayCRTReduction() {
        return DEFAULT_X_RAY_CRT_REDUCTION;
    }

    public BigDecimal getLinePaymentOutlierOffset() {
        return DEFAULT_LINE_PAYMENT_OUTLIER_OFFSET;
    }

    public BigDecimal getApcQualityReduction() {
        return DEFAULT_APC_QUALITY_REDUCTION;
    }

    public BigDecimal getSoleCommunityHospitalAdjustmentRate() {
        return DEFAULT_SOLE_COMMUNITY_HOSPITAL_ADJUSTMENT_RATE;
    }

    public BigDecimal getREHApplyFivePercentAddOn() {
        return REH_FIVE_PERCENT_ADDON;
    }

    public BigDecimal getRehEligibleCoinsurance() {
        return REH_ELIGIBLE_COINSURANCE;
    }

    public BigDecimal getColonialProcedureCap() {
        return BigDecimal.ONE;
    }

    @Generated
    public boolean isRehExcludeCoinsurance() {
        return this.rehExcludeCoinsurance;
    }

    @Generated
    public void setRehExcludeCoinsurance(boolean rehExcludeCoinsurance) {
        this.rehExcludeCoinsurance = rehExcludeCoinsurance;
    }

    @Generated
    public BigDecimal getRehFivePercentAddon() {
        return this.rehFivePercentAddon;
    }

    @Generated
    public void setRehFivePercentAddon(BigDecimal rehFivePercentAddon) {
        this.rehFivePercentAddon = rehFivePercentAddon;
    }

    @Generated
    public boolean isRuralSch() {
        return this.isRuralSch;
    }

    @Generated
    public void setRuralSch(boolean isRuralSch) {
        this.isRuralSch = isRuralSch;
    }

    @Generated
    public boolean isRehProviderType24Or25() {
        return this.isRehProviderType24Or25;
    }

    @Generated
    public void setRehProviderType24Or25(boolean isRehProviderType24Or25) {
        this.isRehProviderType24Or25 = isRehProviderType24Or25;
    }

    @Generated
    public DataTables getDataTables() {
        return this.dataTables;
    }

    @Generated
    public List<CoinsuranceCapEntry> getCoinsuranceCaps() {
        return this.coinsuranceCaps;
    }

    @Generated
    public List<DeductibleLine> getDeductibleLines() {
        return this.deductibleLines;
    }

    @Generated
    public void setDeductibleLines(List<DeductibleLine> deductibleLines) {
        this.deductibleLines = deductibleLines;
    }

    @Generated
    public BigDecimal getWageIndex() {
        return this.wageIndex;
    }

    @Generated
    public void setWageIndex(BigDecimal wageIndex) {
        this.wageIndex = wageIndex;
    }

    @Generated
    public int getBeneficiaryBloodPintsUsed() {
        return this.beneficiaryBloodPintsUsed;
    }

    @Generated
    public void setBeneficiaryBloodPintsUsed(int beneficiaryBloodPintsUsed) {
        this.beneficiaryBloodPintsUsed = beneficiaryBloodPintsUsed;
    }

    @Generated
    public BigDecimal getBeneficiaryDeductible() {
        return this.beneficiaryDeductible;
    }

    @Generated
    public void setBeneficiaryDeductible(BigDecimal beneficiaryDeductible) {
        this.beneficiaryDeductible = beneficiaryDeductible;
    }

    @Generated
    public BigDecimal getClaimDeviceCreditAmount() {
        return this.claimDeviceCreditAmount;
    }

    @Generated
    public void setClaimDeviceCreditAmount(BigDecimal claimDeviceCreditAmount) {
        this.claimDeviceCreditAmount = claimDeviceCreditAmount;
    }

    @Generated
    public BigDecimal getBloodProductCharges() {
        return this.bloodProductCharges;
    }

    @Generated
    public void setBloodProductCharges(BigDecimal bloodProductCharges) {
        this.bloodProductCharges = bloodProductCharges;
    }

    @Generated
    public BigDecimal getTotalBloodCharges() {
        return this.totalBloodCharges;
    }

    @Generated
    public void setTotalBloodCharges(BigDecimal totalBloodCharges) {
        this.totalBloodCharges = totalBloodCharges;
    }

    @Generated
    public BigDecimal getBloodProductPercentage() {
        return this.bloodProductPercentage;
    }

    @Generated
    public void setBloodProductPercentage(BigDecimal bloodProductPercentage) {
        this.bloodProductPercentage = bloodProductPercentage;
    }

    @Generated
    public BigDecimal getQnWageAdjustedPassThroughDeviceOffset() {
        return this.qnWageAdjustedPassThroughDeviceOffset;
    }

    @Generated
    public void setQnWageAdjustedPassThroughDeviceOffset(BigDecimal qnWageAdjustedPassThroughDeviceOffset) {
        this.qnWageAdjustedPassThroughDeviceOffset = qnWageAdjustedPassThroughDeviceOffset;
    }

    @Generated
    public BigDecimal getQoWageAdjustedPassThroughDeviceOffset() {
        return this.qoWageAdjustedPassThroughDeviceOffset;
    }

    @Generated
    public void setQoWageAdjustedPassThroughDeviceOffset(BigDecimal qoWageAdjustedPassThroughDeviceOffset) {
        this.qoWageAdjustedPassThroughDeviceOffset = qoWageAdjustedPassThroughDeviceOffset;
    }

    @Generated
    public boolean isBloodFlag() {
        return this.bloodFlag;
    }

    @Generated
    public void setBloodFlag(boolean bloodFlag) {
        this.bloodFlag = bloodFlag;
    }

    @Generated
    public boolean isSt0Flag() {
        return this.st0Flag;
    }

    @Generated
    public void setSt0Flag(boolean st0Flag) {
        this.st0Flag = st0Flag;
    }

    @Generated
    public boolean isNFlag() {
        return this.nFlag;
    }

    @Generated
    public void setNFlag(boolean nFlag) {
        this.nFlag = nFlag;
    }

    @Generated
    public BigDecimal getTotalCharge() {
        return this.totalCharge;
    }

    @Generated
    public void setTotalCharge(BigDecimal totalCharge) {
        this.totalCharge = totalCharge;
    }

    @Generated
    public BigDecimal getTotalNCharge() {
        return this.totalNCharge;
    }

    @Generated
    public void setTotalNCharge(BigDecimal totalNCharge) {
        this.totalNCharge = totalNCharge;
    }

    @Generated
    public OutlierPaymentInfo getOutlierPaymentInfo() {
        return this.outlierPaymentInfo;
    }

    @Generated
    public void setOutlierPaymentInfo(OutlierPaymentInfo outlierPaymentInfo) {
        this.outlierPaymentInfo = outlierPaymentInfo;
    }

    @Generated
    public BigDecimal getTotalSTCharge() {
        return this.totalSTCharge;
    }

    @Generated
    public void setTotalSTCharge(BigDecimal totalSTCharge) {
        this.totalSTCharge = totalSTCharge;
    }

    @Generated
    public BigDecimal getTotalSTPayment() {
        return this.totalSTPayment;
    }

    @Generated
    public void setTotalSTPayment(BigDecimal totalSTPayment) {
        this.totalSTPayment = totalSTPayment;
    }

    @Generated
    public BigDecimal getTotalClaimPayment() {
        return this.totalClaimPayment;
    }

    @Generated
    public void setTotalClaimPayment(BigDecimal totalClaimPayment) {
        this.totalClaimPayment = totalClaimPayment;
    }

    @Generated
    public BigDecimal getTotalSTVXPayment() {
        return this.totalSTVXPayment;
    }

    @Generated
    public void setTotalSTVXPayment(BigDecimal totalSTVXPayment) {
        this.totalSTVXPayment = totalSTVXPayment;
    }

    @Generated
    public BigDecimal getInpatientDeductibleLimit() {
        return this.inpatientDeductibleLimit;
    }

    @Generated
    public void setInpatientDeductibleLimit(BigDecimal inpatientDeductibleLimit) {
        this.inpatientDeductibleLimit = inpatientDeductibleLimit;
    }

    @Generated
    public BigDecimal getTotalQnPassThroughDeviceCharges() {
        return this.totalQnPassThroughDeviceCharges;
    }

    @Generated
    public void setTotalQnPassThroughDeviceCharges(BigDecimal totalQnPassThroughDeviceCharges) {
        this.totalQnPassThroughDeviceCharges = totalQnPassThroughDeviceCharges;
    }

    @Generated
    public BigDecimal getTotalQoPassThroughDeviceCharges() {
        return this.totalQoPassThroughDeviceCharges;
    }

    @Generated
    public void setTotalQoPassThroughDeviceCharges(BigDecimal totalQoPassThroughDeviceCharges) {
        this.totalQoPassThroughDeviceCharges = totalQoPassThroughDeviceCharges;
    }

    @Generated
    public BigDecimal getTotalTerminatedProcedureDeviceOffsetPayments() {
        return this.totalTerminatedProcedureDeviceOffsetPayments;
    }

    @Generated
    public void setTotalTerminatedProcedureDeviceOffsetPayments(BigDecimal totalTerminatedProcedureDeviceOffsetPayments) {
        this.totalTerminatedProcedureDeviceOffsetPayments = totalTerminatedProcedureDeviceOffsetPayments;
    }

    @Generated
    public BigDecimal getTotalDeviceCreditPayments() {
        return this.totalDeviceCreditPayments;
    }

    @Generated
    public void setTotalDeviceCreditPayments(BigDecimal totalDeviceCreditPayments) {
        this.totalDeviceCreditPayments = totalDeviceCreditPayments;
    }

    @Generated
    public BigDecimal getApcPayment() {
        return this.apcPayment;
    }

    @Generated
    public void setApcPayment(BigDecimal apcPayment) {
        this.apcPayment = apcPayment;
    }

    @Generated
    public BigDecimal getDiscountRate() {
        return this.discountRate;
    }

    @Generated
    public void setDiscountRate(BigDecimal discountRate) {
        this.discountRate = discountRate;
    }

    @Generated
    public APCCalculationData getApcCalculationData() {
        return this.apcCalculationData;
    }

    @Generated
    public void setApcCalculationData(APCCalculationData apcCalculationData) {
        this.apcCalculationData = apcCalculationData;
    }
}

