/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingRequest;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingResponse;
import gov.cms.fiss.pricers.opps.api.v2.OppsPaymentData;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import java.math.BigDecimal;

public class EndOfClaimProcessing
implements CalculationRule<OppsClaimPricingRequest, OppsClaimPricingResponse, OppsPricerContext> {
    @Override
    public void calculate(OppsPricerContext calculationContext) {
        OppsPaymentData paymentData = calculationContext.getPaymentData();
        paymentData.setTotalClaimCharges(calculationContext.getTotalCharge());
        paymentData.setTotalPayment(calculationContext.getTotalClaimPayment());
        int beneficiaryBloodPintsRemaining = calculationContext.getClaimData().getBloodPintsRemaining();
        int beneficiaryBloodPintsUsed = calculationContext.getBeneficiaryBloodPintsUsed();
        paymentData.setBloodPintsUsed(beneficiaryBloodPintsRemaining - beneficiaryBloodPintsUsed);
        BigDecimal outlierPayment = calculationContext.getOutlierPaymentInfo().getOutlierPayment();
        if (BigDecimalUtils.isGreaterThanZero(outlierPayment)) {
            paymentData.setTotalClaimOutlierPayment(outlierPayment);
        }
    }
}

