/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimData;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingRequest;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingResponse;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import gov.cms.fiss.pricers.opps.core.OutlierPaymentInfo;
import gov.cms.fiss.pricers.opps.core.codes.ReturnCode;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class EnforceCmhcOutlierPaymentCaps
implements CalculationRule<OppsClaimPricingRequest, OppsClaimPricingResponse, OppsPricerContext> {
    @Override
    public void calculate(OppsPricerContext calculationContext) {
        OppsClaimPricingRequest input = (OppsClaimPricingRequest)calculationContext.getInput();
        OutlierPaymentInfo outlierPaymentInfo = calculationContext.getOutlierPaymentInfo();
        BigDecimal cmhcTotalOutlier = outlierPaymentInfo.getCmhcTotalOutlier();
        BigDecimal cmhcTotalPayment = outlierPaymentInfo.getCmhcTotalPayment();
        BigDecimal outlierPayment = outlierPaymentInfo.getOutlierPayment();
        if (calculationContext.isCommunityMentalHealthCenter() && BigDecimalUtils.isGreaterThanZero(cmhcTotalOutlier)) {
            cmhcTotalPayment = cmhcTotalPayment.add(((OppsClaimData)input.getClaimData()).getPriorPaymentTotal());
            if (BigDecimalUtils.isGreaterThan((cmhcTotalOutlier = cmhcTotalOutlier.add(((OppsClaimData)input.getClaimData()).getPriorOutlierTotal())).divide(cmhcTotalPayment, RoundingMode.HALF_UP), OppsPricerContext.CMHC_OUTLIER_PERCENT_CAP)) {
                outlierPayment = BigDecimalUtils.ZERO;
                calculationContext.applyClaimReturnCode(ReturnCode.CMHC_LIMIT_REACHED_2);
            }
        }
        calculationContext.setOutlierPaymentInfo(new OutlierPaymentInfo(cmhcTotalPayment, cmhcTotalOutlier, outlierPayment));
    }
}

