/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.opps.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingRequest;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingResponse;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import gov.cms.fiss.pricers.opps.core.model.DeductibleLine;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class OrderDeductibleTable
implements CalculationRule<OppsClaimPricingRequest, OppsClaimPricingResponse, OppsPricerContext> {
    @Override
    public void calculate(OppsPricerContext calculationContext) {
        List<DeductibleLine> deductibleLines = calculationContext.getDeductibleLines();
        ArrayList<DeductibleLine> reorderedList = new ArrayList<DeductibleLine>();
        deductibleLines.sort(DeductibleLine::compareByApcRank);
        List bloodDeductibleLines = deductibleLines.stream().filter(l -> l.getBloodRank() != null).collect(Collectors.toList());
        bloodDeductibleLines.sort(DeductibleLine::compareByDosThenBloodRank);
        Iterator iterator = bloodDeductibleLines.iterator();
        for (DeductibleLine deductibleLine : deductibleLines) {
            IoceServiceLineData lineInput = deductibleLine.getServiceLine();
            if (calculationContext.isBloodDeductibleHcpcsLine(lineInput.getStatusIndicator(), lineInput.getHcpcsCode(), lineInput.getPaymentAdjustmentFlags())) {
                DeductibleLine bloodDeductibleLine = (DeductibleLine)iterator.next();
                DeductibleLine replacementLine = deductibleLines.stream().filter(e -> Objects.equals(e.getServiceLine(), bloodDeductibleLine.getServiceLine())).findFirst().orElseThrow();
                reorderedList.add(replacementLine);
                continue;
            }
            reorderedList.add(deductibleLine);
        }
        calculationContext.setDeductibleLines(reorderedList);
    }
}

