/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules.adjust_procedure_lines;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.opps.api.v2.ServiceLinePaymentData;
import gov.cms.fiss.pricers.opps.core.DeductibleLineContext;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import gov.cms.fiss.pricers.opps.core.codes.PackageFlag;
import gov.cms.fiss.pricers.opps.core.model.DeductibleLine;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.stream.Stream;

public class CalculateLinePayment
implements CalculationRule<DeductibleLine, ServiceLinePaymentData, DeductibleLineContext> {
    @Override
    public void calculate(DeductibleLineContext calculationContext) {
        BigDecimal compositeSubCharge;
        DeductibleLine deductibleLine;
        IoceServiceLineData line;
        String statusIndicator;
        OppsPricerContext pricerContext = calculationContext.getPricerContext();
        if (pricerContext.notEligibleForOutlierPayment(statusIndicator = (line = (deductibleLine = (DeductibleLine)calculationContext.getInput()).getServiceLine()).getStatusIndicator(), line.getPackageFlag(), line.getPaymentMethodFlag(), line.getPaymentAdjustmentFlags())) {
            calculationContext.getLineCalculation().setPayment(null);
            return;
        }
        BigDecimal linePayment = pricerContext.getServiceLinePaymentByLineNumber(line.getLineNumber()).getPayment();
        if (pricerContext.isSt0Flag() && OppsPricerContext.isSignificantProcedure(statusIndicator, line.getHcpcsCode()) && BigDecimalUtils.isGreaterThanZero(pricerContext.getTotalSTPayment())) {
            deductibleLine.setSubCharge(linePayment.divide(pricerContext.getTotalSTPayment(), 8, RoundingMode.HALF_UP).multiply(pricerContext.getTotalSTCharge()).setScale(2, RoundingMode.HALF_UP));
        } else if (pricerContext.isNFlag() && !pricerContext.isSt0Flag() && OppsPricerContext.isSeparatelyPayable(statusIndicator) && this.isArtificialOrNotPackaged(line.getPackageFlag()) && BigDecimalUtils.isGreaterThanZero(pricerContext.getTotalSTVXPayment())) {
            deductibleLine.setSubCharge(linePayment.divide(pricerContext.getTotalSTVXPayment(), 8, RoundingMode.HALF_UP).multiply(pricerContext.getTotalNCharge()).setScale(2, RoundingMode.HALF_UP).add(deductibleLine.getSubCharge()));
        }
        if (pricerContext.isNFlag() && pricerContext.isSt0Flag() && OppsPricerContext.isSeparatelyPayable(statusIndicator) && this.isArtificialOrNotPackaged(line.getPackageFlag()) && BigDecimalUtils.isGreaterThanZero(pricerContext.getTotalSTVXPayment())) {
            deductibleLine.setSubCharge(linePayment.divide(pricerContext.getTotalSTVXPayment(), 8, RoundingMode.HALF_UP).multiply(pricerContext.getTotalNCharge()).setScale(2, RoundingMode.HALF_UP).add(deductibleLine.getSubCharge()));
        }
        if (!OppsPricerContext.isZeroValue(line.getCompositeAdjustmentFlag()) && (compositeSubCharge = pricerContext.getCompositeSubCharge(line.getCompositeAdjustmentFlag())) != null) {
            deductibleLine.setSubCharge(deductibleLine.getSubCharge().add(compositeSubCharge));
        }
        calculationContext.getLineCalculation().setPayment(linePayment);
    }

    private boolean isArtificialOrNotPackaged(String packageFlag) {
        return Stream.of(PackageFlag.NOT_PACKAGED_0, PackageFlag.ARTIFICIAL_SURGICAL_3).anyMatch(pf -> pf.is(packageFlag));
    }
}

