/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules.calculate_deductible_lines;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingResponse;
import gov.cms.fiss.pricers.opps.api.v2.OppsPaymentData;
import gov.cms.fiss.pricers.opps.api.v2.ServiceLinePaymentData;
import gov.cms.fiss.pricers.opps.core.DeductibleLineContext;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import gov.cms.fiss.pricers.opps.core.model.DeductibleLine;
import gov.cms.fiss.pricers.opps.core.model.LineCalculation;

public class AccumulateClaimTotals
implements CalculationRule<DeductibleLine, ServiceLinePaymentData, DeductibleLineContext> {
    @Override
    public boolean shouldExecute(DeductibleLineContext calculationContext) {
        ServiceLinePaymentData lineOutput = (ServiceLinePaymentData)calculationContext.getOutput();
        return Integer.parseInt(lineOutput.getReturnCode().getCode()) < 30;
    }

    @Override
    public void calculate(DeductibleLineContext calculationContext) {
        OppsPricerContext pricerContext = calculationContext.getPricerContext();
        LineCalculation lineCalculation = calculationContext.getLineCalculation();
        OppsPaymentData paymentData = (OppsPaymentData)((OppsClaimPricingResponse)pricerContext.getOutput()).getPaymentData();
        String lineActionFlag = ((DeductibleLine)calculationContext.getInput()).getServiceLine().getActionFlag();
        paymentData.setTotalClaimDeductible(lineCalculation.getTotalDeductible().add(paymentData.getTotalClaimDeductible()));
        if (!OppsPricerContext.hasExternalAdjustment(lineActionFlag)) {
            pricerContext.setTotalClaimPayment(pricerContext.getTotalClaimPayment().add(lineCalculation.getPayment()));
        }
        paymentData.setBloodDeductibleDue(paymentData.getBloodDeductibleDue().add(lineCalculation.getBloodDeductible()));
        paymentData.setDeviceCreditQd(paymentData.getDeviceCreditQd().add(lineCalculation.getDeviceCreditAmount()));
    }
}

