/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules.calculate_deductible_lines;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.opps.api.v2.ServiceLinePaymentData;
import gov.cms.fiss.pricers.opps.core.DeductibleLineContext;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import gov.cms.fiss.pricers.opps.core.codes.StatusIndicator;
import gov.cms.fiss.pricers.opps.core.model.CoinsuranceCapEntry;
import gov.cms.fiss.pricers.opps.core.model.DeductibleLine;
import gov.cms.fiss.pricers.opps.core.model.LineCalculation;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.stream.Stream;

public class PopulateCoinsuranceCapTable2024
implements CalculationRule<DeductibleLine, ServiceLinePaymentData, DeductibleLineContext> {
    @Override
    public boolean shouldExecute(DeductibleLineContext calculationContext) {
        return Integer.parseInt(((ServiceLinePaymentData)calculationContext.getOutput()).getReturnCode().getCode()) < 30;
    }

    @Override
    public void calculate(DeductibleLineContext deductibleLineContext) {
        boolean packagedBloodDeductibleLineFlag;
        OppsPricerContext calculationContext = deductibleLineContext.getPricerContext();
        LineCalculation lineCalculation = deductibleLineContext.getLineCalculation();
        IoceServiceLineData lineInput = lineCalculation.getLineInput();
        DeductibleLine deductibleLine = lineCalculation.getDeductibleLine();
        String statusIndicator = lineInput.getStatusIndicator();
        boolean bl = packagedBloodDeductibleLineFlag = OppsPricerContext.isComprehensiveBloodDeductible(statusIndicator, lineInput.getPaymentAdjustmentFlags(), calculationContext.getComprehensiveApcClaimStatus()) && calculationContext.getDataTables().isBloodHcpcsDeductible(lineInput.getHcpcsCode());
        if (packagedBloodDeductibleLineFlag || OppsPricerContext.isSection603(lineInput.getPaymentMethodFlag()) && !calculationContext.isRehProviderType24Or25()) {
            return;
        }
        if (this.isSignificantProcedureOrClinicVisit(statusIndicator)) {
            BigDecimal nationalWageAdjustedCoinsurance = deductibleLine.getNationalCoinsurance().multiply(deductibleLine.getWageIndex().multiply(new BigDecimal(".60")).add(new BigDecimal(".40"))).setScale(2, RoundingMode.HALF_UP);
            if (BigDecimalUtils.isGreaterThan(nationalWageAdjustedCoinsurance, calculationContext.getInpatientDeductibleLimit())) {
                nationalWageAdjustedCoinsurance = calculationContext.getInpatientDeductibleLimit();
            }
            BigDecimal coinsuranceAmount = lineCalculation.getPayment().subtract(lineCalculation.getTotalDeductible()).subtract(lineCalculation.getReimbursement()).subtract(lineCalculation.getBloodDeductible());
            this.addOrUpdateCoinsuranceCapTable(calculationContext, lineCalculation, nationalWageAdjustedCoinsurance, coinsuranceAmount);
        } else if (StatusIndicator.R_BLOOD.is(statusIndicator)) {
            BigDecimal nationalWageAdjustedCoinsurance = BigDecimalUtils.ZERO;
            BigDecimal coinsuranceAmount = lineCalculation.getPayment().subtract(lineCalculation.getTotalDeductible()).subtract(lineCalculation.getReimbursement()).subtract(lineCalculation.getBloodDeductible());
            calculationContext.setBloodFlag(true);
            this.addOrUpdateCoinsuranceCapTable(calculationContext, lineCalculation, nationalWageAdjustedCoinsurance, coinsuranceAmount);
            this.addCoinsuranceCapEntry(calculationContext, 2, lineCalculation, nationalWageAdjustedCoinsurance, coinsuranceAmount);
        }
    }

    protected void addOrUpdateCoinsuranceCapTable(OppsPricerContext calculationContext, LineCalculation lineCalculation, BigDecimal nationalWageAdjustedCoinsurance, BigDecimal coinsuranceAmount) {
        IoceServiceLineData lineInput = lineCalculation.getLineInput();
        LocalDate dos = lineCalculation.getLineInput().getDateOfService();
        CoinsuranceCapEntry entry = calculationContext.getCoinsuranceCaps().stream().filter(e -> e.getDateOfService().isEqual(dos) && e.getCode().equals(1)).findAny().orElse(null);
        if (entry == null) {
            this.addCoinsuranceCapEntry(calculationContext, 1, lineCalculation, nationalWageAdjustedCoinsurance, coinsuranceAmount);
        } else {
            this.updateCoinsuranceCapEntry(entry, lineInput, nationalWageAdjustedCoinsurance, coinsuranceAmount);
        }
    }

    protected void updateCoinsuranceCapEntry(CoinsuranceCapEntry entry, IoceServiceLineData lineInput, BigDecimal nationalWageAdjustedCoinsurance, BigDecimal coinsuranceAmount) {
        String statusIndicator = lineInput.getStatusIndicator();
        if (StatusIndicator.R_BLOOD.is(statusIndicator)) {
            entry.setCoinsurance2(entry.getCoinsurance2().add(coinsuranceAmount));
        } else if (StatusIndicator.X_ANCILLARY.is(entry.getStatusIndicator())) {
            entry.setServiceLine(lineInput);
            entry.setCoinsurance1(coinsuranceAmount);
            entry.setNationalWageAdjustedCoinsurance(nationalWageAdjustedCoinsurance);
            entry.setStatusIndicator(statusIndicator);
        } else if (BigDecimalUtils.isGreaterThan(coinsuranceAmount, entry.getCoinsurance1())) {
            entry.setServiceLine(lineInput);
            entry.setCoinsurance1(coinsuranceAmount);
            entry.setNationalWageAdjustedCoinsurance(nationalWageAdjustedCoinsurance);
            entry.setStatusIndicator(statusIndicator);
        }
    }

    protected void addCoinsuranceCapEntry(OppsPricerContext calculationContext, int code, LineCalculation lineCalculation, BigDecimal nationalWageAdjustedCoinsurance, BigDecimal coinsuranceAmount) {
        IoceServiceLineData lineInput = lineCalculation.getLineInput();
        String statusIndicator = lineInput.getStatusIndicator();
        CoinsuranceCapEntry entry = new CoinsuranceCapEntry();
        entry.setServiceLine(lineInput);
        entry.setDateOfService(lineInput.getDateOfService());
        entry.setCode(code);
        if (code == 2) {
            entry.setCoinsurance1(BigDecimalUtils.ZERO);
            entry.setNationalWageAdjustedCoinsurance(nationalWageAdjustedCoinsurance);
            entry.setCoinsurance2(coinsuranceAmount);
            entry.setStatusIndicator(statusIndicator);
        } else if (StatusIndicator.R_BLOOD.is(statusIndicator)) {
            entry.setCoinsurance1(BigDecimalUtils.ZERO);
            entry.setNationalWageAdjustedCoinsurance(BigDecimalUtils.ZERO);
            entry.setCoinsurance2(coinsuranceAmount);
            entry.setStatusIndicator(StatusIndicator.X_ANCILLARY.getIndicator());
        } else {
            entry.setCoinsurance1(coinsuranceAmount);
            entry.setNationalWageAdjustedCoinsurance(nationalWageAdjustedCoinsurance);
            entry.setCoinsurance2(BigDecimalUtils.ZERO);
            entry.setStatusIndicator(statusIndicator);
        }
        calculationContext.addCoinsuranceCap(entry);
    }

    private boolean isSignificantProcedureOrClinicVisit(String statusIndicator) {
        return Stream.of(StatusIndicator.S_PROCEDURE_NOT_DISCOUNTED, StatusIndicator.T_PROCEDURE_REDUCIBLE, StatusIndicator.V_EMERGENCY).anyMatch(si -> si.is(statusIndicator));
    }
}

