/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules.calculate_deductible_lines.calculate_standard_payment;

import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimData;
import gov.cms.fiss.pricers.opps.core.DeductibleLineContext;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import gov.cms.fiss.pricers.opps.core.codes.PaymentAdjustmentFlag;
import gov.cms.fiss.pricers.opps.core.model.DeductibleLine;
import gov.cms.fiss.pricers.opps.core.rules.calculate_deductible_lines.calculate_standard_payment.AbstractDeductibleLineRule;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculateTerminatedProcedureDeviceOffset
extends AbstractDeductibleLineRule {
    @Override
    public void calculate(DeductibleLineContext calculationContext) {
        OppsPricerContext pricerContext = calculationContext.getPricerContext();
        OppsClaimData claimData = pricerContext.getClaimData();
        BigDecimal payerValueCodeQq = BigDecimalUtils.defaultValue(claimData.getPayerOnlyValueCodeOffsets().getTerminatedPassthroughOffsetAmountQq());
        DeductibleLine deductibleLine = (DeductibleLine)calculationContext.getInput();
        BigDecimal totalTerminatedProcedureDeviceOffsetPayments = pricerContext.getTotalTerminatedProcedureDeviceOffsetPayments();
        if (PaymentAdjustmentFlag.TERMINATED_PROCEDURE_PASS_THROUGH_DEVICE_16.is(deductibleLine.getServiceLine().getPaymentAdjustmentFlags())) {
            BigDecimal rate;
            BigDecimal offset;
            if (BigDecimalUtils.isLessThanOrEqualToZero(payerValueCodeQq) && BigDecimalUtils.isLessThanOrEqualToZero(totalTerminatedProcedureDeviceOffsetPayments)) {
                return;
            }
            BigDecimal lineApcPayment = deductibleLine.getApcPayment();
            if (BigDecimalUtils.isGreaterThanOrEqualTo(lineApcPayment, offset = (rate = lineApcPayment.divide(totalTerminatedProcedureDeviceOffsetPayments, 4, RoundingMode.HALF_UP)).multiply(payerValueCodeQq).setScale(2, RoundingMode.HALF_UP))) {
                deductibleLine.setApcPayment(lineApcPayment.subtract(offset));
            } else {
                deductibleLine.setApcPayment(BigDecimalUtils.ZERO);
            }
        }
    }
}

