/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules.calculate_deductible_lines.calculate_standard_payment.calculate_status_indicator_payments;

import gov.cms.fiss.pricers.common.api.OutpatientProviderData;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.opps.api.v2.ServiceLinePaymentData;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import gov.cms.fiss.pricers.opps.core.codes.PaymentAdjustmentFlag;
import gov.cms.fiss.pricers.opps.core.codes.PaymentMethodFlag;
import gov.cms.fiss.pricers.opps.core.codes.ReturnCode;
import gov.cms.fiss.pricers.opps.core.codes.StatusIndicator;
import gov.cms.fiss.pricers.opps.core.model.DeductibleLine;
import gov.cms.fiss.pricers.opps.core.model.LineCalculation;
import gov.cms.fiss.pricers.opps.core.rules.calculate_deductible_lines.calculate_standard_payment.AbstractDeductibleLineRule;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractStatusIndicatorPayments2024
extends AbstractDeductibleLineRule {
    private static final Pattern BILL_TYPE = Pattern.compile("14[0-9A-Z]");

    protected BigDecimal calculateBeneficiaryDeductible(LineCalculation lineCalculation, BigDecimal beneficiaryDeductible) {
        IoceServiceLineData lineInput = lineCalculation.getLineInput();
        ServiceLinePaymentData lineOutput = lineCalculation.getLineOutput();
        if (!this.isDeductibleAdjustment(lineInput.getPaymentAdjustmentFlags())) {
            return beneficiaryDeductible;
        }
        BigDecimal bloodPayment = BigDecimalUtils.ZERO;
        if (BigDecimalUtils.isGreaterThanZero(beneficiaryDeductible)) {
            bloodPayment = lineCalculation.getPayment().subtract(lineCalculation.getBloodDeductible());
        }
        if (BigDecimalUtils.isGreaterThanOrEqualTo(bloodPayment, beneficiaryDeductible)) {
            lineCalculation.setTotalDeductible(BigDecimalUtils.defaultValue(beneficiaryDeductible));
            return BigDecimalUtils.ZERO;
        }
        lineCalculation.setTotalDeductible(bloodPayment);
        lineOutput.setReturnCode(ReturnCode.PAYMENT_EQUALS_ZERO_20.toReturnCodeData());
        return beneficiaryDeductible.subtract(bloodPayment);
    }

    protected void calculateWageAdjustedPaymentAndSchAdj(OppsPricerContext calculationContext, OutpatientProviderData providerData, LineCalculation lineCalculation, String billType) {
        IoceServiceLineData lineInput = lineCalculation.getLineInput();
        DeductibleLine deductibleLine = lineCalculation.getDeductibleLine();
        String si = lineInput.getStatusIndicator();
        List<String> paymentAdjustmentFlags = lineInput.getPaymentAdjustmentFlags();
        BigDecimal soleCommunityHospital = (OppsPricerContext.isRuralCbsa(providerData.getCbsaActualGeographicLocation()) || OppsPricerContext.isRuralCbsa(providerData.getCbsaWageIndexLocation()) || OppsPricerContext.isRuralCbsa(providerData.getPaymentCbsa())) && StringUtils.isNotBlank(providerData.getProviderType()) && OppsPricerContext.SCH_PROVIDER_TYPE.contains(providerData.getProviderType()) && !this.isBillType14x(billType) && !OppsPricerContext.isSection603(lineInput.getPaymentMethodFlag()) ? deductibleLine.getApcPayment().multiply(calculationContext.getSoleCommunityHospitalAdjustmentRate()).setScale(2, RoundingMode.HALF_UP) : deductibleLine.getApcPayment();
        if (this.isBloodProductOrBrachytherapy(si)) {
            lineCalculation.setPayment(soleCommunityHospital.multiply(new BigDecimal(deductibleLine.getServiceUnits())).multiply(deductibleLine.getDiscountRate()).setScale(2, RoundingMode.HALF_UP));
            AbstractStatusIndicatorPayments2024.rehFivePercentAddOn(calculationContext, providerData, lineCalculation, si);
        } else {
            lineCalculation.setPayment(soleCommunityHospital.multiply(new BigDecimal(".60")).multiply(deductibleLine.getWageIndex()).add(soleCommunityHospital.multiply(new BigDecimal(".40"))).multiply(new BigDecimal(deductibleLine.getServiceUnits())).multiply(deductibleLine.getDiscountRate()).setScale(2, RoundingMode.HALF_UP));
            AbstractStatusIndicatorPayments2024.rehFivePercentAddOn(calculationContext, providerData, lineCalculation, si);
            if (PaymentMethodFlag.RADIATION_ONCOLOGY_MODEL_B.is(lineInput.getPaymentMethodFlag()) && BigDecimalUtils.isGreaterThanZero(providerData.getPaymentModelAdjustment())) {
                lineCalculation.setPayment(lineCalculation.getPayment().multiply(providerData.getPaymentModelAdjustment()).setScale(2, RoundingMode.HALF_UP));
            }
        }
        if (PaymentAdjustmentFlag.DEVICE_CREDIT_17.is(paymentAdjustmentFlags) && BigDecimalUtils.isGreaterThanZero(lineCalculation.getDeviceCreditAmount())) {
            if (BigDecimalUtils.isGreaterThanOrEqualTo(lineCalculation.getPayment(), lineCalculation.getDeviceCreditAmount())) {
                lineCalculation.setPayment(lineCalculation.getPayment().subtract(lineCalculation.getDeviceCreditAmount()));
            } else {
                lineCalculation.setPayment(BigDecimalUtils.ZERO);
            }
        }
    }

    protected static void rehFivePercentAddOn(OppsPricerContext calculationContext, OutpatientProviderData providerData, LineCalculation lineCalculation, String si) {
        if (StringUtils.isNotBlank(providerData.getProviderType()) && !calculationContext.isREHStatusIndicatorExclusion(si) && (OppsPricerContext.REH_PROVIDER_TYPE_24.contains(providerData.getProviderType()) || OppsPricerContext.REH_PROVIDER_TYPE_25.contains(providerData.getProviderType()))) {
            BigDecimal rehFivePercentAddon = lineCalculation.getPayment().multiply(calculationContext.getREHApplyFivePercentAddOn()).setScale(2, RoundingMode.HALF_UP);
            calculationContext.setRehFivePercentAddon(rehFivePercentAddon);
            calculationContext.setRehExcludeCoinsurance(true);
            lineCalculation.setPayment(lineCalculation.getPayment().add(rehFivePercentAddon).setScale(2, RoundingMode.HALF_UP));
        }
    }

    private boolean isDeductibleAdjustment(List<String> paymentAdjustmentFlags) {
        return Stream.of(PaymentAdjustmentFlag.DEDUCTIBLE_NOT_APPLICABLE_4, PaymentAdjustmentFlag.DEDUCTIBLE_AND_COINSURANCE_NOT_APPLICABLE_9, PaymentAdjustmentFlag.X_RAY_NO_COINSURANCE_23, PaymentAdjustmentFlag.COMPUTED_RADIOLOGY_NO_COINSURANCE_24, PaymentAdjustmentFlag.COLONIAL_PROCEDURE_25).noneMatch(si -> si.is(paymentAdjustmentFlags));
    }

    public boolean isBloodProductOrBrachytherapy(String statusIndicator) {
        return Stream.of(StatusIndicator.R_BLOOD, StatusIndicator.U_BRACHYTHERAPY).anyMatch(si -> si.is(statusIndicator));
    }

    private boolean isBillType14x(String billType) {
        return BILL_TYPE.matcher(billType).matches();
    }
}

