/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules.calculate_deductible_lines.calculate_standard_payment.calculate_status_indicator_payments;

import gov.cms.fiss.pricers.common.api.OutpatientProviderData;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.opps.core.DeductibleLineContext;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import gov.cms.fiss.pricers.opps.core.codes.PaymentAdjustmentFlag;
import gov.cms.fiss.pricers.opps.core.codes.PaymentIndicator;
import gov.cms.fiss.pricers.opps.core.codes.ReturnCode;
import gov.cms.fiss.pricers.opps.core.codes.StatusIndicator;
import gov.cms.fiss.pricers.opps.core.model.DeductibleLine;
import gov.cms.fiss.pricers.opps.core.model.LineCalculation;
import gov.cms.fiss.pricers.opps.core.rules.calculate_deductible_lines.calculate_standard_payment.calculate_status_indicator_payments.AbstractStatusIndicatorPayments2024;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.stream.Stream;

public class BloodProductAndBrachytherapy
extends AbstractStatusIndicatorPayments2024 {
    @Override
    public boolean shouldExecute(DeductibleLineContext context) {
        return this.isBloodProductOrBrachytherapy(context.getStatusIndicator());
    }

    @Override
    public void calculate(DeductibleLineContext calculationContext) {
        LineCalculation lineCalculation = calculationContext.getLineCalculation();
        OppsPricerContext pricerContext = calculationContext.getPricerContext();
        OutpatientProviderData providerData = pricerContext.getProviderData();
        IoceServiceLineData ioceServiceLine = lineCalculation.getLineInput();
        String paymentIndicator = ioceServiceLine.getPaymentIndicator();
        String billType = pricerContext.getClaimData().getTypeOfBill();
        if (this.isPayStandardAmountIndicator(paymentIndicator)) {
            pricerContext.setBeneficiaryBloodPintsUsed(this.calculateBloodAndBrachyLines(pricerContext, providerData, lineCalculation, billType, calculationContext.isPackagedBloodDeductibleLine(), pricerContext.getBeneficiaryBloodPintsUsed(), pricerContext.getBloodProductPercentage()));
            if (!calculationContext.isPackagedBloodDeductibleLine()) {
                pricerContext.setBeneficiaryDeductible(this.calculateBeneficiaryDeductible(lineCalculation, pricerContext.getBeneficiaryDeductible()));
            }
        } else {
            calculationContext.applyLineReturnCode(ReturnCode.STATUS_INDICATOR_INVALID_FOR_OPPS_41);
        }
    }

    protected int calculateBloodAndBrachyLines(OppsPricerContext calculationContext, OutpatientProviderData providerData, LineCalculation lineCalculation, String billType, boolean packagedBloodDeductibleLineFlag, int beneficiaryBloodPintsUsed, BigDecimal deductibleBloodPercentage) {
        List<String> paymentAdjustmentFlags;
        String hcpcs;
        IoceServiceLineData lineInput = lineCalculation.getLineInput();
        String statusIndicator = lineInput.getStatusIndicator();
        if (calculationContext.isBloodDeductibleHcpcsLine(statusIndicator, hcpcs = lineInput.getHcpcsCode(), paymentAdjustmentFlags = lineInput.getPaymentAdjustmentFlags())) {
            beneficiaryBloodPintsUsed = this.calculateBloodFraction(lineCalculation, beneficiaryBloodPintsUsed);
            this.adjustBloodCost(lineCalculation, deductibleBloodPercentage);
            this.calculateWageAdjustedPaymentAndSchAdj(calculationContext, providerData, lineCalculation, billType);
            lineCalculation.setBloodDeductible(lineCalculation.getPayment().multiply(lineCalculation.getBloodFraction()).setScale(2, RoundingMode.HALF_UP));
            if (packagedBloodDeductibleLineFlag) {
                lineCalculation.setPayment(lineCalculation.getBloodDeductible());
            }
        } else {
            if (StatusIndicator.R_BLOOD.is(statusIndicator) && OppsPricerContext.isBloodPaymentAdjustment(paymentAdjustmentFlags)) {
                this.adjustBloodCost(lineCalculation, deductibleBloodPercentage);
            }
            this.calculateWageAdjustedPaymentAndSchAdj(calculationContext, providerData, lineCalculation, billType);
        }
        return beneficiaryBloodPintsUsed;
    }

    protected int calculateBloodFraction(LineCalculation lineCalculation, int beneficiaryBloodPintsUsed) {
        IoceServiceLineData lineInput = lineCalculation.getLineInput();
        DeductibleLine deductibleLine = lineCalculation.getDeductibleLine();
        lineCalculation.setBloodFraction(BigDecimalUtils.ZERO);
        if (!PaymentAdjustmentFlag.BLOOD_DEDUCTIBLE_5.is(lineInput.getPaymentAdjustmentFlags()) || beneficiaryBloodPintsUsed == 0) {
            return beneficiaryBloodPintsUsed;
        }
        if (deductibleLine.getServiceUnits() <= beneficiaryBloodPintsUsed) {
            lineCalculation.setBloodFraction(new BigDecimal("1.00"));
            beneficiaryBloodPintsUsed -= deductibleLine.getServiceUnits().intValue();
        } else {
            lineCalculation.setBloodFraction(new BigDecimal(beneficiaryBloodPintsUsed).divide(new BigDecimal(deductibleLine.getServiceUnits()), 8, RoundingMode.DOWN));
            beneficiaryBloodPintsUsed = 0;
        }
        return beneficiaryBloodPintsUsed;
    }

    protected void adjustBloodCost(LineCalculation lineCalculation, BigDecimal deductibleBloodPercentage) {
        IoceServiceLineData lineInput = lineCalculation.getLineInput();
        DeductibleLine deductibleLine = lineCalculation.getDeductibleLine();
        List<String> paymentAdjustmentFlags = lineInput.getPaymentAdjustmentFlags();
        if (PaymentAdjustmentFlag.BLOOD_DEDUCTIBLE_5.is(paymentAdjustmentFlags)) {
            deductibleLine.setApcPayment(deductibleLine.getApcPayment().multiply(deductibleBloodPercentage).setScale(2, RoundingMode.DOWN));
        }
        if (PaymentAdjustmentFlag.BLOOD_NOT_DEDUCTIBLE_6.is(paymentAdjustmentFlags)) {
            deductibleLine.setApcPayment(deductibleLine.getApcPayment().multiply(BigDecimal.ONE.subtract(deductibleBloodPercentage)).setScale(2, RoundingMode.DOWN));
        }
    }

    private boolean isPayStandardAmountIndicator(String paymentIndicator) {
        return Stream.of(PaymentIndicator.PAID_STANDARD_HOSPITAL_OPPS_AMOUNT_1, PaymentIndicator.PAID_STANDARD_AMOUNT_FOR_PASS_THROUGH_DRUG_OR_BIOLOGICAL_5, PaymentIndicator.ADDITIONAL_PAYMENT_FOR_NEW_DRUG_OR_BIOLOGICAL_7).anyMatch(pi -> pi.is(paymentIndicator));
    }
}

