/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules.calculate_deductible_lines.calculate_standard_payment.calculate_status_indicator_payments;

import gov.cms.fiss.pricers.common.api.OutpatientProviderData;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimData;
import gov.cms.fiss.pricers.opps.core.DeductibleLineContext;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import gov.cms.fiss.pricers.opps.core.codes.PaymentAdjustmentFlag;
import gov.cms.fiss.pricers.opps.core.codes.PaymentIndicator;
import gov.cms.fiss.pricers.opps.core.codes.ReturnCode;
import gov.cms.fiss.pricers.opps.core.codes.StatusIndicator;
import gov.cms.fiss.pricers.opps.core.model.DevicePassThroughInfo;
import gov.cms.fiss.pricers.opps.core.model.LineCalculation;
import gov.cms.fiss.pricers.opps.core.rules.calculate_deductible_lines.calculate_standard_payment.calculate_status_indicator_payments.AbstractStatusIndicatorPayments2024;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.stream.Stream;

public class PassThroughDeviceCategories2025
extends AbstractStatusIndicatorPayments2024 {
    @Override
    public boolean shouldExecute(DeductibleLineContext context) {
        return StatusIndicator.H_PASS_THROUGH_DEVICE.is(context.getStatusIndicator()) || StatusIndicator.H1_NON_OPIOID_MEDICAL_DEVICE.is(context.getStatusIndicator());
    }

    @Override
    public void calculate(DeductibleLineContext calculationContext) {
        LineCalculation lineCalculation = calculationContext.getLineCalculation();
        OppsPricerContext pricerContext = calculationContext.getPricerContext();
        OutpatientProviderData providerData = pricerContext.getProviderData();
        IoceServiceLineData ioceServiceLine = lineCalculation.getLineInput();
        String paymentIndicator = ioceServiceLine.getPaymentIndicator();
        if (PaymentIndicator.PAYMENT_BASED_ON_CHARGE_ADJUSTED_TO_COST_6.is(paymentIndicator)) {
            DevicePassThroughInfo info = new DevicePassThroughInfo(pricerContext.getTotalQnPassThroughDeviceCharges(), pricerContext.getQnWageAdjustedPassThroughDeviceOffset(), pricerContext.getTotalQoPassThroughDeviceCharges(), pricerContext.getQoWageAdjustedPassThroughDeviceOffset());
            this.calculateDeviceLinePayment(pricerContext, providerData, lineCalculation, info);
            pricerContext.setBeneficiaryDeductible(this.calculateBeneficiaryDeductible(lineCalculation, pricerContext.getBeneficiaryDeductible()));
        } else {
            calculationContext.applyLineReturnCode(ReturnCode.INVALID_STATUS_INDICATOR_44);
        }
    }

    protected void calculateDeviceLinePayment(OppsPricerContext pricerContext, OutpatientProviderData providerData, LineCalculation lineCalculation, DevicePassThroughInfo info) {
        IoceServiceLineData lineInput = lineCalculation.getLineInput();
        BigDecimal lineItemPayment = providerData.getDeviceCostToChargeRatio() == null || BigDecimalUtils.isZero(providerData.getDeviceCostToChargeRatio()) ? lineInput.getCoveredCharges().multiply(providerData.getOperatingCostToChargeRatio()).setScale(2, RoundingMode.HALF_UP) : lineInput.getCoveredCharges().multiply(providerData.getDeviceCostToChargeRatio()).setScale(2, RoundingMode.HALF_UP);
        lineCalculation.setPayment(lineItemPayment);
        OppsClaimData claimData = pricerContext.getClaimData();
        List<String> paymentAdjustmentFlags = lineInput.getPaymentAdjustmentFlags();
        if (StatusIndicator.H1_NON_OPIOID_MEDICAL_DEVICE.is(lineInput.getStatusIndicator()) && PaymentAdjustmentFlag.FIRST_LINE_CAP_NONOPIOID_H1_26.is(paymentAdjustmentFlags)) {
            BigDecimal payerValueCodeQv = BigDecimalUtils.defaultValue(claimData.getPayerOnlyValueCodeOffsets().getNonOpioidDeviceCapAmountQv());
            if (BigDecimalUtils.isLessThan(lineCalculation.getPayment(), payerValueCodeQv)) {
                lineCalculation.setPayment(lineItemPayment);
            } else {
                lineCalculation.setPayment(payerValueCodeQv);
            }
        }
        if (StatusIndicator.H1_NON_OPIOID_MEDICAL_DEVICE.is(lineInput.getStatusIndicator()) && PaymentAdjustmentFlag.SECOND_LINE_CAP_NONOPIOID_H1_27.is(paymentAdjustmentFlags)) {
            BigDecimal payerValueCodeQp = BigDecimalUtils.defaultValue(claimData.getPayerOnlyValueCodeOffsets().getNonOpioidDeviceCapAmountQp());
            if (BigDecimalUtils.isLessThan(lineCalculation.getPayment(), payerValueCodeQp)) {
                lineCalculation.setPayment(lineItemPayment);
            } else {
                lineCalculation.setPayment(payerValueCodeQp);
            }
        }
        if (StatusIndicator.H_PASS_THROUGH_DEVICE.is(lineInput.getStatusIndicator())) {
            PassThroughDeviceCategories2025.rehFivePercentAddOn(pricerContext, providerData, lineCalculation, StatusIndicator.H_PASS_THROUGH_DEVICE.getIndicator());
            lineItemPayment = lineCalculation.getPayment();
        }
        if (StatusIndicator.H1_NON_OPIOID_MEDICAL_DEVICE.is(lineInput.getStatusIndicator())) {
            PassThroughDeviceCategories2025.rehFivePercentAddOn(pricerContext, providerData, lineCalculation, StatusIndicator.H1_NON_OPIOID_MEDICAL_DEVICE.getIndicator());
            lineItemPayment = lineCalculation.getPayment();
        }
        if (this.isDevicePassThroughAdjustment(lineInput.getPaymentAdjustmentFlags())) {
            lineItemPayment = this.calculatePassThroughDeviceOffset(lineCalculation, lineItemPayment, info);
        }
        if (BigDecimalUtils.isLessThanZero(lineItemPayment)) {
            lineCalculation.setPayment(BigDecimalUtils.ZERO);
        } else {
            lineCalculation.setPayment(lineItemPayment);
        }
    }

    private boolean isDevicePassThroughAdjustment(List<String> paymentAdjustmentFlags) {
        return Stream.of(PaymentAdjustmentFlag.DEVICE_PASS_THROUGH_12, PaymentAdjustmentFlag.DEVICE_PASS_THROUGH_13).anyMatch(paf -> paf.is(paymentAdjustmentFlags));
    }

    protected BigDecimal calculatePassThroughDeviceOffset(LineCalculation lineCalculation, BigDecimal lineItemPayment, DevicePassThroughInfo devicePassThroughInfo) {
        IoceServiceLineData lineInput = lineCalculation.getLineInput();
        List<String> paymentAdjustmentFlags = lineInput.getPaymentAdjustmentFlags();
        BigDecimal totalPassThruDeviceCharges = BigDecimalUtils.ZERO;
        BigDecimal wageAdjustedPassThruDeviceOffset = BigDecimalUtils.ZERO;
        if (PaymentAdjustmentFlag.DEVICE_PASS_THROUGH_12.is(paymentAdjustmentFlags)) {
            totalPassThruDeviceCharges = devicePassThroughInfo.getTotalQn();
            wageAdjustedPassThruDeviceOffset = devicePassThroughInfo.getWageAdjustedQn();
        } else if (PaymentAdjustmentFlag.DEVICE_PASS_THROUGH_13.is(paymentAdjustmentFlags)) {
            totalPassThruDeviceCharges = devicePassThroughInfo.getTotalQo();
            wageAdjustedPassThruDeviceOffset = devicePassThroughInfo.getWageAdjustedQo();
        }
        if (BigDecimalUtils.isLessThanOrEqualToZero(totalPassThruDeviceCharges)) {
            return lineItemPayment;
        }
        BigDecimal passThroughDeviceOffsetChargeRate = lineInput.getCoveredCharges().divide(totalPassThruDeviceCharges, 8, RoundingMode.HALF_UP);
        BigDecimal passThroughDeviceLineOffset = passThroughDeviceOffsetChargeRate.multiply(wageAdjustedPassThruDeviceOffset).setScale(2, RoundingMode.HALF_UP);
        lineItemPayment = BigDecimalUtils.isGreaterThanOrEqualTo(lineItemPayment, passThroughDeviceLineOffset) ? lineItemPayment.subtract(passThroughDeviceLineOffset) : BigDecimalUtils.ZERO;
        return lineItemPayment;
    }
}

