/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules.coinsurance_and_reimbursement_calculation;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.api.v2.ServiceLinePaymentData;
import gov.cms.fiss.pricers.opps.core.CoinsuranceCapContext;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import gov.cms.fiss.pricers.opps.core.codes.ReturnCode;
import gov.cms.fiss.pricers.opps.core.model.CoinsuranceCapEntry;
import gov.cms.fiss.pricers.opps.core.model.CoinsuranceCapValues;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class AdjustBloodCoinsuranceForInpatientLimit
implements CalculationRule<CoinsuranceCapEntry, CoinsuranceCapValues, CoinsuranceCapContext> {
    @Override
    public void calculate(CoinsuranceCapContext calculationContext) {
        OppsPricerContext pricerContext = calculationContext.getPricerContext();
        CoinsuranceCapEntry entry = (CoinsuranceCapEntry)calculationContext.getInput();
        CoinsuranceCapValues coinsuranceCapValues = (CoinsuranceCapValues)calculationContext.getOutput();
        BigDecimal newTotal = coinsuranceCapValues.getTotal();
        if (((CoinsuranceCapEntry)calculationContext.getInput()).getCode() == 2) {
            if (entry.getDateOfService().equals(coinsuranceCapValues.getLastCoinsuranceDateOfService())) {
                ServiceLinePaymentData line = pricerContext.getServiceLinePaymentByLineNumber(entry.getServiceLine().getLineNumber());
                BigDecimal shift = entry.getCoinsurance2().multiply(BigDecimal.ONE.subtract(coinsuranceCapValues.getRatio())).setScale(2, RoundingMode.DOWN);
                newTotal = line.getCoinsuranceAmount().add(newTotal).subtract(shift);
                if (BigDecimalUtils.isGreaterThan(newTotal, pricerContext.getInpatientDeductibleLimit())) {
                    shift = shift.add(newTotal).subtract(pricerContext.getInpatientDeductibleLimit());
                }
                line.setCoinsuranceAmount(line.getCoinsuranceAmount().subtract(shift));
                boolean reimbursementWith25Percent = false;
                if (BigDecimalUtils.isLessThanZero(line.getCoinsuranceAmount())) {
                    line.setCoinsuranceAmount(BigDecimalUtils.ZERO);
                    reimbursementWith25Percent = true;
                }
                if (reimbursementWith25Percent) {
                    line.setReimbursementAmount(line.getReimbursementAmount().add(((CoinsuranceCapEntry)calculationContext.getInput()).getCoinsurance2()));
                } else {
                    line.setReimbursementAmount(line.getReimbursementAmount().add(shift));
                }
                line.setReturnCode(ReturnCode.DAILY_COINSURANCE_LIMITATION_22.toReturnCodeData());
            }
            coinsuranceCapValues.setTotal(newTotal);
        }
    }
}

