/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules.initialize_and_validate_claim;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimData;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingRequest;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingResponse;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import java.math.BigDecimal;

public class DetermineDeviceCreditAmount
implements CalculationRule<OppsClaimPricingRequest, OppsClaimPricingResponse, OppsPricerContext> {
    @Override
    public void calculate(OppsPricerContext calculationContext) {
        OppsClaimData claimData = calculationContext.getClaimData();
        BigDecimal deviceCreditCapOffsetAmountQu = BigDecimalUtils.defaultValue(claimData.getPayerOnlyValueCodeOffsets().getDeviceCreditCapOffsetAmountQu());
        if (BigDecimalUtils.isGreaterThanZero(deviceCreditCapOffsetAmountQu) && BigDecimalUtils.isGreaterThanZero(claimData.getDeviceCredit())) {
            calculationContext.setClaimDeviceCreditAmount(deviceCreditCapOffsetAmountQu.min(claimData.getDeviceCredit()));
        }
    }
}

