/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules.initialize_and_validate_lines;

import gov.cms.fiss.pricers.opps.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import gov.cms.fiss.pricers.opps.core.ServiceLineContext;
import gov.cms.fiss.pricers.opps.core.codes.ReturnCode;
import gov.cms.fiss.pricers.opps.core.model.APCCalculationData;
import gov.cms.fiss.pricers.opps.core.rules.initialize_and_validate_lines.AbstractLineCalculationRule;
import gov.cms.fiss.pricers.opps.core.tables.ApcRateHistoryEntry;
import java.time.LocalDate;
import java.util.Map;
import java.util.NavigableMap;

public class ApcLookup
extends AbstractLineCalculationRule {
    @Override
    public void calculate(ServiceLineContext calculationContext) {
        APCCalculationData apcData = new APCCalculationData();
        OppsPricerContext pricerContext = calculationContext.getPricerContext();
        IoceServiceLineData ioceServiceLine = (IoceServiceLineData)calculationContext.getInput();
        LocalDate serviceDate = pricerContext.getClaimData().getServiceFromDate();
        calculationContext.getPricerContext().setApcCalculationData(apcData);
        NavigableMap<LocalDate, ApcRateHistoryEntry> entries = pricerContext.getDataTables().getApcRateHistoryEntry(ioceServiceLine.getPaymentApc());
        if (entries == null) {
            calculationContext.applyLineReturnCode(ReturnCode.APC_NOT_FOUND_30);
            return;
        }
        Map.Entry<LocalDate, ApcRateHistoryEntry> mapEntry = entries.floorEntry(serviceDate);
        ApcRateHistoryEntry rateHistoryEntry = mapEntry == null ? null : mapEntry.getValue().copyBuilder().build();
        if (rateHistoryEntry != null) {
            pricerContext.setApcPayment(rateHistoryEntry.getPaymentRate());
            apcData.setRank(rateHistoryEntry.getRank());
            apcData.setMinimumCoinsurance(rateHistoryEntry.getMinimumCoinsurance());
            apcData.setNationalCoinsurance(rateHistoryEntry.getNationalCoinsurance());
            apcData.setRate(rateHistoryEntry.getReimbursementPercent());
        }
    }
}

