/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules.initialize_and_validate_lines;

import gov.cms.fiss.pricers.opps.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import gov.cms.fiss.pricers.opps.core.ServiceLineContext;
import gov.cms.fiss.pricers.opps.core.codes.PackageFlag;
import gov.cms.fiss.pricers.opps.core.codes.StatusIndicator;
import gov.cms.fiss.pricers.opps.core.rules.initialize_and_validate_lines.AbstractLineCalculationRule;
import java.math.BigDecimal;
import java.util.stream.Stream;

public class CalculateTotalsStep1
extends AbstractLineCalculationRule {
    @Override
    public void calculate(ServiceLineContext calculationContext) {
        OppsPricerContext pricerContext = calculationContext.getPricerContext();
        IoceServiceLineData ioceServiceLine = (IoceServiceLineData)calculationContext.getInput();
        BigDecimal subCharge = ioceServiceLine.getCoveredCharges();
        if (!OppsPricerContext.hasExternalAdjustment(ioceServiceLine.getActionFlag())) {
            pricerContext.setTotalCharge(pricerContext.getTotalCharge().add(subCharge));
        }
        if (this.shouldAccumulateNLineCharge(calculationContext)) {
            pricerContext.setTotalNCharge(pricerContext.getTotalNCharge().add(subCharge));
            pricerContext.setNFlag(true);
        }
        if (StatusIndicator.N_PACKAGED_INTO_APC.is(ioceServiceLine.getStatusIndicator())) {
            if (pricerContext.getComprehensiveApcClaimStatus() && OppsPricerContext.LINE_REVENUE_CODE.contains(ioceServiceLine.getRevenueCode())) {
                pricerContext.setTotalBloodCharges(pricerContext.getTotalBloodCharges().add(subCharge));
            }
            if (!OppsPricerContext.isZeroValue(ioceServiceLine.getCompositeAdjustmentFlag())) {
                this.calculateCompositeSubCharges(calculationContext);
            }
        }
    }

    protected boolean shouldAccumulateNLineCharge(ServiceLineContext calculationContext) {
        IoceServiceLineData line = (IoceServiceLineData)calculationContext.getInput();
        OppsPricerContext pricerContext = calculationContext.getPricerContext();
        boolean comprehensiveApcClaimFlag = pricerContext.getComprehensiveApcClaimStatus();
        return this.isPackaged(line.getPackageFlag()) && OppsPricerContext.isZeroValue(line.getCompositeAdjustmentFlag()) || OppsPricerContext.isComprehensiveBloodDeductible(line.getStatusIndicator(), line.getPaymentAdjustmentFlags(), comprehensiveApcClaimFlag);
    }

    protected void calculateCompositeSubCharges(ServiceLineContext calculationContext) {
        IoceServiceLineData ioceServiceLine = (IoceServiceLineData)calculationContext.getInput();
        calculationContext.getPricerContext().addCompositeSubCharge(ioceServiceLine.getCompositeAdjustmentFlag(), ioceServiceLine.getCoveredCharges());
    }

    private boolean isPackaged(String packageFlag) {
        return Stream.of(PackageFlag.SERVICE_1, PackageFlag.PER_DIEM_2, PackageFlag.DRUG_ADMINISTRATION_4).anyMatch(pf -> pf.is(packageFlag));
    }
}

