/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules.initialize_and_validate_lines;

import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import gov.cms.fiss.pricers.opps.core.ServiceLineContext;
import gov.cms.fiss.pricers.opps.core.codes.PaymentAdjustmentFlag;
import gov.cms.fiss.pricers.opps.core.rules.initialize_and_validate_lines.AbstractLineCalculationRule;
import java.math.BigDecimal;
import java.util.List;

public class CalculateTotalsStep2
extends AbstractLineCalculationRule {
    @Override
    public void calculate(ServiceLineContext calculationContext) {
        OppsPricerContext pricerContext = calculationContext.getPricerContext();
        IoceServiceLineData ioceServiceLine = (IoceServiceLineData)calculationContext.getInput();
        BigDecimal submittedCharge = ioceServiceLine.getCoveredCharges();
        List<String> paymentAdjustmentFlags = ioceServiceLine.getPaymentAdjustmentFlags();
        if (OppsPricerContext.isBloodPaymentAdjustment(paymentAdjustmentFlags)) {
            if (PaymentAdjustmentFlag.BLOOD_DEDUCTIBLE_5.is(paymentAdjustmentFlags)) {
                pricerContext.setBloodProductCharges(pricerContext.getBloodProductCharges().add(submittedCharge));
            }
            pricerContext.setTotalBloodCharges(pricerContext.getTotalBloodCharges().add(submittedCharge));
        }
        if (BigDecimalUtils.isGreaterThanZero(pricerContext.getClaimDeviceCreditAmount()) && PaymentAdjustmentFlag.DEVICE_CREDIT_17.is(paymentAdjustmentFlags)) {
            pricerContext.setTotalDeviceCreditPayments(pricerContext.getTotalDeviceCreditPayments().add(pricerContext.getApcPayment()));
        }
        if (BigDecimalUtils.isGreaterThanZero(BigDecimalUtils.defaultValue(pricerContext.getClaimData().getPayerOnlyValueCodeOffsets().getTerminatedPassthroughOffsetAmountQq()))) {
            pricerContext.setTotalTerminatedProcedureDeviceOffsetPayments(pricerContext.getTotalTerminatedProcedureDeviceOffsetPayments().add(pricerContext.getApcPayment()));
        }
        if (PaymentAdjustmentFlag.DEVICE_PASS_THROUGH_12.is(paymentAdjustmentFlags)) {
            pricerContext.setTotalQnPassThroughDeviceCharges(pricerContext.getTotalQnPassThroughDeviceCharges().add(submittedCharge));
        }
        if (PaymentAdjustmentFlag.DEVICE_PASS_THROUGH_13.is(paymentAdjustmentFlags)) {
            pricerContext.setTotalQoPassThroughDeviceCharges(pricerContext.getTotalQoPassThroughDeviceCharges().add(submittedCharge));
        }
    }
}

