/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules.initialize_and_validate_lines;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimData;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingRequest;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingResponse;
import gov.cms.fiss.pricers.opps.api.v2.ServiceLinePaymentData;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import gov.cms.fiss.pricers.opps.core.codes.PaymentAdjustmentFlag;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class ColonialProcedureCoinsuranceCheck
implements CalculationRule<OppsClaimPricingRequest, OppsClaimPricingResponse, OppsPricerContext> {
    @Override
    public void calculate(OppsPricerContext oppsPricerContext) {
        OppsClaimData claimData = oppsPricerContext.getClaimData();
        for (IoceServiceLineData lineInput : claimData.getIoceServiceLines()) {
            if (!PaymentAdjustmentFlag.COLONIAL_PROCEDURE_25.is(lineInput.getPaymentAdjustmentFlags())) continue;
            this.applyCap(oppsPricerContext.getServiceLinePaymentByLineNumber(lineInput.getLineNumber()), oppsPricerContext.getColonialProcedureCap());
        }
    }

    private void applyCap(ServiceLinePaymentData line, BigDecimal coinsuranceCap) {
        BigDecimal payment = line.getPayment();
        BigDecimal coinsurance = line.getCoinsuranceAmount();
        BigDecimal reimbursement = line.getReimbursementAmount();
        if (!BigDecimalUtils.isGreaterThanZero(payment)) {
            return;
        }
        BigDecimal coinsurancePercentage = coinsurance.divide(payment, 2, RoundingMode.HALF_UP);
        if (BigDecimalUtils.isLessThanOrEqualTo(coinsurancePercentage, coinsuranceCap)) {
            return;
        }
        BigDecimal offset = coinsurance.subtract(payment.multiply(coinsuranceCap)).setScale(2, RoundingMode.HALF_UP);
        line.setReimbursementAmount(reimbursement.add(offset));
        line.setCoinsuranceAmount(coinsurance.subtract(offset));
    }
}

