/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules.initialize_and_validate_lines;

import gov.cms.fiss.pricers.common.api.AmbulatoryPaymentClassificationData;
import gov.cms.fiss.pricers.opps.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.opps.api.v2.ServiceLinePaymentData;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import gov.cms.fiss.pricers.opps.core.ServiceLineContext;
import gov.cms.fiss.pricers.opps.core.codes.ReturnCode;
import gov.cms.fiss.pricers.opps.core.codes.StatusIndicator;
import gov.cms.fiss.pricers.opps.core.model.APCCalculationData;
import gov.cms.fiss.pricers.opps.core.model.DeductibleLine;
import gov.cms.fiss.pricers.opps.core.rules.initialize_and_validate_lines.AbstractLineCalculationRule;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

public class PopulateDeductibleTable
extends AbstractLineCalculationRule {
    @Override
    public boolean shouldExecute(ServiceLineContext calculationContext) {
        return List.of(Integer.valueOf(ReturnCode.PROCESSED_1.getCode()), Integer.valueOf(ReturnCode.ABSENT_QUALITY_REPORTING_11.getCode())).contains(Integer.parseInt(((ServiceLinePaymentData)calculationContext.getOutput()).getReturnCode().getCode()));
    }

    @Override
    public void calculate(ServiceLineContext calculationContext) {
        OppsPricerContext pricerContext = calculationContext.getPricerContext();
        IoceServiceLineData ioceServiceLine = (IoceServiceLineData)calculationContext.getInput();
        APCCalculationData apcData = pricerContext.getApcCalculationData();
        DeductibleLine deductibleLine = new DeductibleLine(ioceServiceLine, apcData, pricerContext.getApcPayment(), pricerContext.getWageIndex(), pricerContext.getDiscountRate());
        if (StatusIndicator.P_PARTIAL_HOSPITALIZATION.is(ioceServiceLine.getStatusIndicator())) {
            deductibleLine.setServiceUnits(1);
        }
        pricerContext.getDeductibleLines().add(deductibleLine);
        BigDecimal reducedCoinsurance = this.getReducedCoinsurance(pricerContext.getProviderData().getReducedCoinsuranceData(), ioceServiceLine, deductibleLine.getDiscountRate());
        if (reducedCoinsurance != null) {
            deductibleLine.setReducedCoinsurance(reducedCoinsurance);
            calculationContext.applyLineReturnCode(ReturnCode.COINSURANCE_REDUCTION_25);
            return;
        }
        Integer bloodRank = pricerContext.getDataTables().getBloodRank(ioceServiceLine.getHcpcsCode());
        if (bloodRank != null && OppsPricerContext.isBloodPaymentAdjustment(ioceServiceLine.getPaymentAdjustmentFlags())) {
            deductibleLine.setBloodRank(bloodRank);
            deductibleLine.setDateOfService(ioceServiceLine.getDateOfService());
        }
    }

    protected BigDecimal getReducedCoinsurance(List<AmbulatoryPaymentClassificationData> apcTable, IoceServiceLineData ioceServiceLine, BigDecimal discountRate) {
        if (apcTable != null) {
            for (AmbulatoryPaymentClassificationData apcData : apcTable) {
                String oppsApc = ioceServiceLine.getPaymentApc().substring(1);
                if (!apcData.getAmbulatoryPaymentClassificationCode().equals(oppsApc)) continue;
                return apcData.getReducedCoinsuranceAmount().multiply(new BigDecimal(ioceServiceLine.getApcServiceUnits())).multiply(discountRate).setScale(2, RoundingMode.HALF_UP);
            }
        }
        return null;
    }
}

